<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Sale.ApproveInsurance.Request StructType
 * @subpackage Structs
 */
class BizAction_Sale_ApproveInsurance_Request extends AnyEntity
{
    /**
     * The AllActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllActive;
    /**
     * The Approve
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Approve;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The InsurancePolicyGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InsurancePolicyGuid;
    /**
     * The InsurancePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $InsurancePrice;
    /**
     * The Media
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_Media
     */
    public $Media;
    /**
     * The ModifierIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ModifierIds;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The NumInsuredItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumInsuredItems;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for BizAction.Sale.ApproveInsurance.Request
     * @uses BizAction_Sale_ApproveInsurance_Request::setAllActive()
     * @uses BizAction_Sale_ApproveInsurance_Request::setApprove()
     * @uses BizAction_Sale_ApproveInsurance_Request::setDescription()
     * @uses BizAction_Sale_ApproveInsurance_Request::setInsurancePolicyGuid()
     * @uses BizAction_Sale_ApproveInsurance_Request::setInsurancePrice()
     * @uses BizAction_Sale_ApproveInsurance_Request::setMedia()
     * @uses BizAction_Sale_ApproveInsurance_Request::setModifierIds()
     * @uses BizAction_Sale_ApproveInsurance_Request::setName()
     * @uses BizAction_Sale_ApproveInsurance_Request::setNumInsuredItems()
     * @uses BizAction_Sale_ApproveInsurance_Request::setTransactionGuid()
     * @param bool $allActive
     * @param bool $approve
     * @param \patest\StructType\GlobalString $description
     * @param string $insurancePolicyGuid
     * @param \patest\StructType\Money $insurancePrice
     * @param \patest\StructType\Sales_Media $media
     * @param string $modifierIds
     * @param \patest\StructType\GlobalString $name
     * @param int $numInsuredItems
     * @param string $transactionGuid
     */
    public function __construct($allActive = null, $approve = null, \patest\StructType\GlobalString $description = null, $insurancePolicyGuid = null, \patest\StructType\Money $insurancePrice = null, \patest\StructType\Sales_Media $media = null, $modifierIds = null, \patest\StructType\GlobalString $name = null, $numInsuredItems = null, $transactionGuid = null)
    {
        $this
            ->setAllActive($allActive)
            ->setApprove($approve)
            ->setDescription($description)
            ->setInsurancePolicyGuid($insurancePolicyGuid)
            ->setInsurancePrice($insurancePrice)
            ->setMedia($media)
            ->setModifierIds($modifierIds)
            ->setName($name)
            ->setNumInsuredItems($numInsuredItems)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get AllActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllActive()
    {
        return isset($this->AllActive) ? $this->AllActive : null;
    }
    /**
     * Set AllActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allActive
     * @return \patest\StructType\BizAction_Sale_ApproveInsurance_Request
     */
    public function setAllActive($allActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($allActive) && !is_bool($allActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allActive, true), gettype($allActive)), __LINE__);
        }
        if (is_null($allActive) || (is_array($allActive) && empty($allActive))) {
            unset($this->AllActive);
        } else {
            $this->AllActive = $allActive;
        }
        return $this;
    }
    /**
     * Get Approve value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getApprove()
    {
        return isset($this->Approve) ? $this->Approve : null;
    }
    /**
     * Set Approve value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $approve
     * @return \patest\StructType\BizAction_Sale_ApproveInsurance_Request
     */
    public function setApprove($approve = null)
    {
        // validation for constraint: boolean
        if (!is_null($approve) && !is_bool($approve)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($approve, true), gettype($approve)), __LINE__);
        }
        if (is_null($approve) || (is_array($approve) && empty($approve))) {
            unset($this->Approve);
        } else {
            $this->Approve = $approve;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\BizAction_Sale_ApproveInsurance_Request
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get InsurancePolicyGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInsurancePolicyGuid()
    {
        return isset($this->InsurancePolicyGuid) ? $this->InsurancePolicyGuid : null;
    }
    /**
     * Set InsurancePolicyGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $insurancePolicyGuid
     * @return \patest\StructType\BizAction_Sale_ApproveInsurance_Request
     */
    public function setInsurancePolicyGuid($insurancePolicyGuid = null)
    {
        // validation for constraint: string
        if (!is_null($insurancePolicyGuid) && !is_string($insurancePolicyGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insurancePolicyGuid, true), gettype($insurancePolicyGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($insurancePolicyGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $insurancePolicyGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($insurancePolicyGuid, true)), __LINE__);
        }
        if (is_null($insurancePolicyGuid) || (is_array($insurancePolicyGuid) && empty($insurancePolicyGuid))) {
            unset($this->InsurancePolicyGuid);
        } else {
            $this->InsurancePolicyGuid = $insurancePolicyGuid;
        }
        return $this;
    }
    /**
     * Get InsurancePrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getInsurancePrice()
    {
        return isset($this->InsurancePrice) ? $this->InsurancePrice : null;
    }
    /**
     * Set InsurancePrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $insurancePrice
     * @return \patest\StructType\BizAction_Sale_ApproveInsurance_Request
     */
    public function setInsurancePrice(\patest\StructType\Money $insurancePrice = null)
    {
        if (is_null($insurancePrice) || (is_array($insurancePrice) && empty($insurancePrice))) {
            unset($this->InsurancePrice);
        } else {
            $this->InsurancePrice = $insurancePrice;
        }
        return $this;
    }
    /**
     * Get Media value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_Media|null
     */
    public function getMedia()
    {
        return isset($this->Media) ? $this->Media : null;
    }
    /**
     * Set Media value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_Media $media
     * @return \patest\StructType\BizAction_Sale_ApproveInsurance_Request
     */
    public function setMedia(\patest\StructType\Sales_Media $media = null)
    {
        if (is_null($media) || (is_array($media) && empty($media))) {
            unset($this->Media);
        } else {
            $this->Media = $media;
        }
        return $this;
    }
    /**
     * Get ModifierIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModifierIds()
    {
        return isset($this->ModifierIds) ? $this->ModifierIds : null;
    }
    /**
     * Set ModifierIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modifierIds
     * @return \patest\StructType\BizAction_Sale_ApproveInsurance_Request
     */
    public function setModifierIds($modifierIds = null)
    {
        // validation for constraint: string
        if (!is_null($modifierIds) && !is_string($modifierIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modifierIds, true), gettype($modifierIds)), __LINE__);
        }
        if (is_null($modifierIds) || (is_array($modifierIds) && empty($modifierIds))) {
            unset($this->ModifierIds);
        } else {
            $this->ModifierIds = $modifierIds;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\BizAction_Sale_ApproveInsurance_Request
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NumInsuredItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumInsuredItems()
    {
        return isset($this->NumInsuredItems) ? $this->NumInsuredItems : null;
    }
    /**
     * Set NumInsuredItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numInsuredItems
     * @return \patest\StructType\BizAction_Sale_ApproveInsurance_Request
     */
    public function setNumInsuredItems($numInsuredItems = null)
    {
        // validation for constraint: int
        if (!is_null($numInsuredItems) && !(is_int($numInsuredItems) || ctype_digit($numInsuredItems))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numInsuredItems, true), gettype($numInsuredItems)), __LINE__);
        }
        if (is_null($numInsuredItems) || (is_array($numInsuredItems) && empty($numInsuredItems))) {
            unset($this->NumInsuredItems);
        } else {
            $this->NumInsuredItems = $numInsuredItems;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\BizAction_Sale_ApproveInsurance_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
}
