<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Reporting.Report.UploadReportImage.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Reporting_Report_UploadReportImage_Request extends AnyEntity
{
    /**
     * The ImageData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImageData;
    /**
     * The ReportId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReportId;
    /**
     * Constructor method for BizAction.Reporting.Report.UploadReportImage.Request
     * @uses BizAction_Reporting_Report_UploadReportImage_Request::setImageData()
     * @uses BizAction_Reporting_Report_UploadReportImage_Request::setReportId()
     * @param string $imageData
     * @param string $reportId
     */
    public function __construct($imageData = null, $reportId = null)
    {
        $this
            ->setImageData($imageData)
            ->setReportId($reportId);
    }
    /**
     * Get ImageData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImageData()
    {
        return isset($this->ImageData) ? $this->ImageData : null;
    }
    /**
     * Set ImageData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $imageData
     * @return \patest\StructType\BizAction_Reporting_Report_UploadReportImage_Request
     */
    public function setImageData($imageData = null)
    {
        // validation for constraint: string
        if (!is_null($imageData) && !is_string($imageData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageData, true), gettype($imageData)), __LINE__);
        }
        if (is_null($imageData) || (is_array($imageData) && empty($imageData))) {
            unset($this->ImageData);
        } else {
            $this->ImageData = $imageData;
        }
        return $this;
    }
    /**
     * Get ReportId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReportId()
    {
        return isset($this->ReportId) ? $this->ReportId : null;
    }
    /**
     * Set ReportId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reportId
     * @return \patest\StructType\BizAction_Reporting_Report_UploadReportImage_Request
     */
    public function setReportId($reportId = null)
    {
        // validation for constraint: string
        if (!is_null($reportId) && !is_string($reportId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportId, true), gettype($reportId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($reportId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $reportId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($reportId, true)), __LINE__);
        }
        if (is_null($reportId) || (is_array($reportId) && empty($reportId))) {
            unset($this->ReportId);
        } else {
            $this->ReportId = $reportId;
        }
        return $this;
    }
}
