<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Reporting.ETL.Run.Request StructType
 * @subpackage Structs
 */
class BizAction_Reporting_ETL_Run_Request extends AnyEntity
{
    /**
     * The delayMs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $delayMs;
    /**
     * The isWait4PendingDbTransactions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $isWait4PendingDbTransactions;
    /**
     * The WaitForEtlFaultCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WaitForEtlFaultCode;
    /**
     * The WaitForEtlToFinishInSec
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $WaitForEtlToFinishInSec;
    /**
     * Constructor method for BizAction.Reporting.ETL.Run.Request
     * @uses BizAction_Reporting_ETL_Run_Request::setDelayMs()
     * @uses BizAction_Reporting_ETL_Run_Request::setIsWait4PendingDbTransactions()
     * @uses BizAction_Reporting_ETL_Run_Request::setWaitForEtlFaultCode()
     * @uses BizAction_Reporting_ETL_Run_Request::setWaitForEtlToFinishInSec()
     * @param int $delayMs
     * @param bool $isWait4PendingDbTransactions
     * @param string $waitForEtlFaultCode
     * @param int $waitForEtlToFinishInSec
     */
    public function __construct($delayMs = null, $isWait4PendingDbTransactions = null, $waitForEtlFaultCode = null, $waitForEtlToFinishInSec = null)
    {
        $this
            ->setDelayMs($delayMs)
            ->setIsWait4PendingDbTransactions($isWait4PendingDbTransactions)
            ->setWaitForEtlFaultCode($waitForEtlFaultCode)
            ->setWaitForEtlToFinishInSec($waitForEtlToFinishInSec);
    }
    /**
     * Get delayMs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDelayMs()
    {
        return isset($this->delayMs) ? $this->delayMs : null;
    }
    /**
     * Set delayMs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $delayMs
     * @return \patest\StructType\BizAction_Reporting_ETL_Run_Request
     */
    public function setDelayMs($delayMs = null)
    {
        // validation for constraint: int
        if (!is_null($delayMs) && !(is_int($delayMs) || ctype_digit($delayMs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($delayMs, true), gettype($delayMs)), __LINE__);
        }
        if (is_null($delayMs) || (is_array($delayMs) && empty($delayMs))) {
            unset($this->delayMs);
        } else {
            $this->delayMs = $delayMs;
        }
        return $this;
    }
    /**
     * Get isWait4PendingDbTransactions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsWait4PendingDbTransactions()
    {
        return isset($this->isWait4PendingDbTransactions) ? $this->isWait4PendingDbTransactions : null;
    }
    /**
     * Set isWait4PendingDbTransactions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isWait4PendingDbTransactions
     * @return \patest\StructType\BizAction_Reporting_ETL_Run_Request
     */
    public function setIsWait4PendingDbTransactions($isWait4PendingDbTransactions = null)
    {
        // validation for constraint: boolean
        if (!is_null($isWait4PendingDbTransactions) && !is_bool($isWait4PendingDbTransactions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isWait4PendingDbTransactions, true), gettype($isWait4PendingDbTransactions)), __LINE__);
        }
        if (is_null($isWait4PendingDbTransactions) || (is_array($isWait4PendingDbTransactions) && empty($isWait4PendingDbTransactions))) {
            unset($this->isWait4PendingDbTransactions);
        } else {
            $this->isWait4PendingDbTransactions = $isWait4PendingDbTransactions;
        }
        return $this;
    }
    /**
     * Get WaitForEtlFaultCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWaitForEtlFaultCode()
    {
        return isset($this->WaitForEtlFaultCode) ? $this->WaitForEtlFaultCode : null;
    }
    /**
     * Set WaitForEtlFaultCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $waitForEtlFaultCode
     * @return \patest\StructType\BizAction_Reporting_ETL_Run_Request
     */
    public function setWaitForEtlFaultCode($waitForEtlFaultCode = null)
    {
        // validation for constraint: string
        if (!is_null($waitForEtlFaultCode) && !is_string($waitForEtlFaultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($waitForEtlFaultCode, true), gettype($waitForEtlFaultCode)), __LINE__);
        }
        if (is_null($waitForEtlFaultCode) || (is_array($waitForEtlFaultCode) && empty($waitForEtlFaultCode))) {
            unset($this->WaitForEtlFaultCode);
        } else {
            $this->WaitForEtlFaultCode = $waitForEtlFaultCode;
        }
        return $this;
    }
    /**
     * Get WaitForEtlToFinishInSec value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getWaitForEtlToFinishInSec()
    {
        return isset($this->WaitForEtlToFinishInSec) ? $this->WaitForEtlToFinishInSec : null;
    }
    /**
     * Set WaitForEtlToFinishInSec value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $waitForEtlToFinishInSec
     * @return \patest\StructType\BizAction_Reporting_ETL_Run_Request
     */
    public function setWaitForEtlToFinishInSec($waitForEtlToFinishInSec = null)
    {
        // validation for constraint: int
        if (!is_null($waitForEtlToFinishInSec) && !(is_int($waitForEtlToFinishInSec) || ctype_digit($waitForEtlToFinishInSec))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($waitForEtlToFinishInSec, true), gettype($waitForEtlToFinishInSec)), __LINE__);
        }
        if (is_null($waitForEtlToFinishInSec) || (is_array($waitForEtlToFinishInSec) && empty($waitForEtlToFinishInSec))) {
            unset($this->WaitForEtlToFinishInSec);
        } else {
            $this->WaitForEtlToFinishInSec = $waitForEtlToFinishInSec;
        }
        return $this;
    }
}
