<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Reporting.CloseTill.Request StructType
 * @subpackage Structs
 */
class BizAction_Reporting_CloseTill_Request extends AnyEntity
{
    /**
     * The CloseAllShifts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CloseAllShifts;
    /**
     * The RunEtl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $RunEtl;
    /**
     * The TillId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TillId;
    /**
     * Constructor method for BizAction.Reporting.CloseTill.Request
     * @uses BizAction_Reporting_CloseTill_Request::setCloseAllShifts()
     * @uses BizAction_Reporting_CloseTill_Request::setRunEtl()
     * @uses BizAction_Reporting_CloseTill_Request::setTillId()
     * @param bool $closeAllShifts
     * @param bool $runEtl
     * @param string $tillId
     */
    public function __construct($closeAllShifts = null, $runEtl = null, $tillId = null)
    {
        $this
            ->setCloseAllShifts($closeAllShifts)
            ->setRunEtl($runEtl)
            ->setTillId($tillId);
    }
    /**
     * Get CloseAllShifts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCloseAllShifts()
    {
        return isset($this->CloseAllShifts) ? $this->CloseAllShifts : null;
    }
    /**
     * Set CloseAllShifts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $closeAllShifts
     * @return \patest\StructType\BizAction_Reporting_CloseTill_Request
     */
    public function setCloseAllShifts($closeAllShifts = null)
    {
        // validation for constraint: boolean
        if (!is_null($closeAllShifts) && !is_bool($closeAllShifts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($closeAllShifts, true), gettype($closeAllShifts)), __LINE__);
        }
        if (is_null($closeAllShifts) || (is_array($closeAllShifts) && empty($closeAllShifts))) {
            unset($this->CloseAllShifts);
        } else {
            $this->CloseAllShifts = $closeAllShifts;
        }
        return $this;
    }
    /**
     * Get RunEtl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRunEtl()
    {
        return isset($this->RunEtl) ? $this->RunEtl : null;
    }
    /**
     * Set RunEtl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $runEtl
     * @return \patest\StructType\BizAction_Reporting_CloseTill_Request
     */
    public function setRunEtl($runEtl = null)
    {
        // validation for constraint: boolean
        if (!is_null($runEtl) && !is_bool($runEtl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($runEtl, true), gettype($runEtl)), __LINE__);
        }
        if (is_null($runEtl) || (is_array($runEtl) && empty($runEtl))) {
            unset($this->RunEtl);
        } else {
            $this->RunEtl = $runEtl;
        }
        return $this;
    }
    /**
     * Get TillId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTillId()
    {
        return isset($this->TillId) ? $this->TillId : null;
    }
    /**
     * Set TillId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tillId
     * @return \patest\StructType\BizAction_Reporting_CloseTill_Request
     */
    public function setTillId($tillId = null)
    {
        // validation for constraint: string
        if (!is_null($tillId) && !is_string($tillId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tillId, true), gettype($tillId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($tillId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $tillId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($tillId, true)), __LINE__);
        }
        if (is_null($tillId) || (is_array($tillId) && empty($tillId))) {
            unset($this->TillId);
        } else {
            $this->TillId = $tillId;
        }
        return $this;
    }
}
