<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Printing.RecalculateBatchPrintFields.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Printing_RecalculateBatchPrintFields_Request extends AnyEntity
{
    /**
     * The BatchPrintId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BatchPrintId;
    /**
     * Constructor method for BizAction.Printing.RecalculateBatchPrintFields.Request
     * @uses BizAction_Printing_RecalculateBatchPrintFields_Request::setBatchPrintId()
     * @param string $batchPrintId
     */
    public function __construct($batchPrintId = null)
    {
        $this
            ->setBatchPrintId($batchPrintId);
    }
    /**
     * Get BatchPrintId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchPrintId()
    {
        return isset($this->BatchPrintId) ? $this->BatchPrintId : null;
    }
    /**
     * Set BatchPrintId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchPrintId
     * @return \patest\StructType\BizAction_Printing_RecalculateBatchPrintFields_Request
     */
    public function setBatchPrintId($batchPrintId = null)
    {
        // validation for constraint: string
        if (!is_null($batchPrintId) && !is_string($batchPrintId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchPrintId, true), gettype($batchPrintId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($batchPrintId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $batchPrintId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($batchPrintId, true)), __LINE__);
        }
        if (is_null($batchPrintId) || (is_array($batchPrintId) && empty($batchPrintId))) {
            unset($this->BatchPrintId);
        } else {
            $this->BatchPrintId = $batchPrintId;
        }
        return $this;
    }
}
