<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Printing.BatchPrint.Request.Base StructType
 * @subpackage Structs
 */
class BizAction_Printing_BatchPrint_Request_Base extends AnyEntity
{
    /**
     * The ApplicationChannelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ApplicationChannelId;
    /**
     * The BatchPrintId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BatchPrintId;
    /**
     * The BatchPrintReasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BatchPrintReasonId;
    /**
     * The ClientExtendedData1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientExtendedData1;
    /**
     * The ClientExtendedData2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientExtendedData2;
    /**
     * The ClientTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ClientTypes
     */
    public $ClientTypes;
    /**
     * The DeliveryMethodIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\DeliveryMethodIds
     */
    public $DeliveryMethodIds;
    /**
     * The FilterOnlyByTRNSIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $FilterOnlyByTRNSIds;
    /**
     * The FromFirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromFirstName;
    /**
     * The FromName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromName;
    /**
     * The IncludeClientWithPhoto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IncludeClientWithPhoto;
    /**
     * The IncludeItemsFromUnconfirmedTransactions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IncludeItemsFromUnconfirmedTransactions;
    /**
     * The IncludeReservedItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IncludeReservedItems;
    /**
     * The MandatoryDocumentTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MandatoryDocumentTypes;
    /**
     * The NotifyOnCompletion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NotifyOnCompletion;
    /**
     * The PrintCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintCount;
    /**
     * The PrintingMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintingMode;
    /**
     * The PrintOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintOptions;
    /**
     * The PrintUpTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintUpTo;
    /**
     * The QueryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $QueryId;
    /**
     * The ReportGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReportGuid;
    /**
     * The Scenario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Scenario;
    /**
     * The SiteId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SiteId;
    /**
     * The SiteIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SiteIds
     */
    public $SiteIds;
    /**
     * The TargetPrinterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetPrinterId;
    /**
     * The TransactionFromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionFromDate;
    /**
     * The TransactionIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionIds;
    /**
     * The TransactionsFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionsFilter;
    /**
     * The TransactionToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionToDate;
    /**
     * The UntilFirstlName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UntilFirstlName;
    /**
     * The UntilName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UntilName;
    /**
     * Constructor method for BizAction.Printing.BatchPrint.Request.Base
     * @uses BizAction_Printing_BatchPrint_Request_Base::setApplicationChannelId()
     * @uses BizAction_Printing_BatchPrint_Request_Base::setBatchPrintId()
     * @uses BizAction_Printing_BatchPrint_Request_Base::setBatchPrintReasonId()
     * @uses BizAction_Printing_BatchPrint_Request_Base::setClientExtendedData1()
     * @uses BizAction_Printing_BatchPrint_Request_Base::setClientExtendedData2()
     * @uses BizAction_Printing_BatchPrint_Request_Base::setClientTypes()
     * @uses BizAction_Printing_BatchPrint_Request_Base::setDeliveryMethodIds()
     * @uses BizAction_Printing_BatchPrint_Request_Base::setFilterOnlyByTRNSIds()
     * @uses BizAction_Printing_BatchPrint_Request_Base::setFromFirstName()
     * @uses BizAction_Printing_BatchPrint_Request_Base::setFromName()
     * @uses BizAction_Printing_BatchPrint_Request_Base::setIncludeClientWithPhoto()
     * @uses BizAction_Printing_BatchPrint_Request_Base::setIncludeItemsFromUnconfirmedTransactions()
     * @uses BizAction_Printing_BatchPrint_Request_Base::setIncludeReservedItems()
     * @uses BizAction_Printing_BatchPrint_Request_Base::setMandatoryDocumentTypes()
     * @uses BizAction_Printing_BatchPrint_Request_Base::setNotifyOnCompletion()
     * @uses BizAction_Printing_BatchPrint_Request_Base::setPrintCount()
     * @uses BizAction_Printing_BatchPrint_Request_Base::setPrintingMode()
     * @uses BizAction_Printing_BatchPrint_Request_Base::setPrintOptions()
     * @uses BizAction_Printing_BatchPrint_Request_Base::setPrintUpTo()
     * @uses BizAction_Printing_BatchPrint_Request_Base::setQueryId()
     * @uses BizAction_Printing_BatchPrint_Request_Base::setReportGuid()
     * @uses BizAction_Printing_BatchPrint_Request_Base::setScenario()
     * @uses BizAction_Printing_BatchPrint_Request_Base::setSiteId()
     * @uses BizAction_Printing_BatchPrint_Request_Base::setSiteIds()
     * @uses BizAction_Printing_BatchPrint_Request_Base::setTargetPrinterId()
     * @uses BizAction_Printing_BatchPrint_Request_Base::setTransactionFromDate()
     * @uses BizAction_Printing_BatchPrint_Request_Base::setTransactionIds()
     * @uses BizAction_Printing_BatchPrint_Request_Base::setTransactionsFilter()
     * @uses BizAction_Printing_BatchPrint_Request_Base::setTransactionToDate()
     * @uses BizAction_Printing_BatchPrint_Request_Base::setUntilFirstlName()
     * @uses BizAction_Printing_BatchPrint_Request_Base::setUntilName()
     * @param string $applicationChannelId
     * @param string $batchPrintId
     * @param string $batchPrintReasonId
     * @param string $clientExtendedData1
     * @param string $clientExtendedData2
     * @param \patest\StructType\ClientTypes $clientTypes
     * @param \patest\StructType\DeliveryMethodIds $deliveryMethodIds
     * @param bool $filterOnlyByTRNSIds
     * @param string $fromFirstName
     * @param string $fromName
     * @param string $includeClientWithPhoto
     * @param string $includeItemsFromUnconfirmedTransactions
     * @param string $includeReservedItems
     * @param string $mandatoryDocumentTypes
     * @param string $notifyOnCompletion
     * @param int $printCount
     * @param string $printingMode
     * @param string $printOptions
     * @param int $printUpTo
     * @param string $queryId
     * @param string $reportGuid
     * @param string $scenario
     * @param string $siteId
     * @param \patest\StructType\SiteIds $siteIds
     * @param string $targetPrinterId
     * @param string $transactionFromDate
     * @param string $transactionIds
     * @param string $transactionsFilter
     * @param string $transactionToDate
     * @param string $untilFirstlName
     * @param string $untilName
     */
    public function __construct($applicationChannelId = null, $batchPrintId = null, $batchPrintReasonId = null, $clientExtendedData1 = null, $clientExtendedData2 = null, \patest\StructType\ClientTypes $clientTypes = null, \patest\StructType\DeliveryMethodIds $deliveryMethodIds = null, $filterOnlyByTRNSIds = null, $fromFirstName = null, $fromName = null, $includeClientWithPhoto = null, $includeItemsFromUnconfirmedTransactions = null, $includeReservedItems = null, $mandatoryDocumentTypes = null, $notifyOnCompletion = null, $printCount = null, $printingMode = null, $printOptions = null, $printUpTo = null, $queryId = null, $reportGuid = null, $scenario = null, $siteId = null, \patest\StructType\SiteIds $siteIds = null, $targetPrinterId = null, $transactionFromDate = null, $transactionIds = null, $transactionsFilter = null, $transactionToDate = null, $untilFirstlName = null, $untilName = null)
    {
        $this
            ->setApplicationChannelId($applicationChannelId)
            ->setBatchPrintId($batchPrintId)
            ->setBatchPrintReasonId($batchPrintReasonId)
            ->setClientExtendedData1($clientExtendedData1)
            ->setClientExtendedData2($clientExtendedData2)
            ->setClientTypes($clientTypes)
            ->setDeliveryMethodIds($deliveryMethodIds)
            ->setFilterOnlyByTRNSIds($filterOnlyByTRNSIds)
            ->setFromFirstName($fromFirstName)
            ->setFromName($fromName)
            ->setIncludeClientWithPhoto($includeClientWithPhoto)
            ->setIncludeItemsFromUnconfirmedTransactions($includeItemsFromUnconfirmedTransactions)
            ->setIncludeReservedItems($includeReservedItems)
            ->setMandatoryDocumentTypes($mandatoryDocumentTypes)
            ->setNotifyOnCompletion($notifyOnCompletion)
            ->setPrintCount($printCount)
            ->setPrintingMode($printingMode)
            ->setPrintOptions($printOptions)
            ->setPrintUpTo($printUpTo)
            ->setQueryId($queryId)
            ->setReportGuid($reportGuid)
            ->setScenario($scenario)
            ->setSiteId($siteId)
            ->setSiteIds($siteIds)
            ->setTargetPrinterId($targetPrinterId)
            ->setTransactionFromDate($transactionFromDate)
            ->setTransactionIds($transactionIds)
            ->setTransactionsFilter($transactionsFilter)
            ->setTransactionToDate($transactionToDate)
            ->setUntilFirstlName($untilFirstlName)
            ->setUntilName($untilName);
    }
    /**
     * Get ApplicationChannelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannelId()
    {
        return isset($this->ApplicationChannelId) ? $this->ApplicationChannelId : null;
    }
    /**
     * Set ApplicationChannelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannelId
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setApplicationChannelId($applicationChannelId = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannelId) && !is_string($applicationChannelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannelId, true), gettype($applicationChannelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($applicationChannelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $applicationChannelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($applicationChannelId, true)), __LINE__);
        }
        if (is_null($applicationChannelId) || (is_array($applicationChannelId) && empty($applicationChannelId))) {
            unset($this->ApplicationChannelId);
        } else {
            $this->ApplicationChannelId = $applicationChannelId;
        }
        return $this;
    }
    /**
     * Get BatchPrintId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchPrintId()
    {
        return isset($this->BatchPrintId) ? $this->BatchPrintId : null;
    }
    /**
     * Set BatchPrintId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchPrintId
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setBatchPrintId($batchPrintId = null)
    {
        // validation for constraint: string
        if (!is_null($batchPrintId) && !is_string($batchPrintId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchPrintId, true), gettype($batchPrintId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($batchPrintId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $batchPrintId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($batchPrintId, true)), __LINE__);
        }
        if (is_null($batchPrintId) || (is_array($batchPrintId) && empty($batchPrintId))) {
            unset($this->BatchPrintId);
        } else {
            $this->BatchPrintId = $batchPrintId;
        }
        return $this;
    }
    /**
     * Get BatchPrintReasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchPrintReasonId()
    {
        return isset($this->BatchPrintReasonId) ? $this->BatchPrintReasonId : null;
    }
    /**
     * Set BatchPrintReasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchPrintReasonId
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setBatchPrintReasonId($batchPrintReasonId = null)
    {
        // validation for constraint: string
        if (!is_null($batchPrintReasonId) && !is_string($batchPrintReasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchPrintReasonId, true), gettype($batchPrintReasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($batchPrintReasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $batchPrintReasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($batchPrintReasonId, true)), __LINE__);
        }
        if (is_null($batchPrintReasonId) || (is_array($batchPrintReasonId) && empty($batchPrintReasonId))) {
            unset($this->BatchPrintReasonId);
        } else {
            $this->BatchPrintReasonId = $batchPrintReasonId;
        }
        return $this;
    }
    /**
     * Get ClientExtendedData1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientExtendedData1()
    {
        return isset($this->ClientExtendedData1) ? $this->ClientExtendedData1 : null;
    }
    /**
     * Set ClientExtendedData1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientExtendedData1
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setClientExtendedData1($clientExtendedData1 = null)
    {
        // validation for constraint: string
        if (!is_null($clientExtendedData1) && !is_string($clientExtendedData1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientExtendedData1, true), gettype($clientExtendedData1)), __LINE__);
        }
        if (is_null($clientExtendedData1) || (is_array($clientExtendedData1) && empty($clientExtendedData1))) {
            unset($this->ClientExtendedData1);
        } else {
            $this->ClientExtendedData1 = $clientExtendedData1;
        }
        return $this;
    }
    /**
     * Get ClientExtendedData2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientExtendedData2()
    {
        return isset($this->ClientExtendedData2) ? $this->ClientExtendedData2 : null;
    }
    /**
     * Set ClientExtendedData2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientExtendedData2
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setClientExtendedData2($clientExtendedData2 = null)
    {
        // validation for constraint: string
        if (!is_null($clientExtendedData2) && !is_string($clientExtendedData2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientExtendedData2, true), gettype($clientExtendedData2)), __LINE__);
        }
        if (is_null($clientExtendedData2) || (is_array($clientExtendedData2) && empty($clientExtendedData2))) {
            unset($this->ClientExtendedData2);
        } else {
            $this->ClientExtendedData2 = $clientExtendedData2;
        }
        return $this;
    }
    /**
     * Get ClientTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ClientTypes|null
     */
    public function getClientTypes()
    {
        return isset($this->ClientTypes) ? $this->ClientTypes : null;
    }
    /**
     * Set ClientTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ClientTypes $clientTypes
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setClientTypes(\patest\StructType\ClientTypes $clientTypes = null)
    {
        if (is_null($clientTypes) || (is_array($clientTypes) && empty($clientTypes))) {
            unset($this->ClientTypes);
        } else {
            $this->ClientTypes = $clientTypes;
        }
        return $this;
    }
    /**
     * Get DeliveryMethodIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\DeliveryMethodIds|null
     */
    public function getDeliveryMethodIds()
    {
        return isset($this->DeliveryMethodIds) ? $this->DeliveryMethodIds : null;
    }
    /**
     * Set DeliveryMethodIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\DeliveryMethodIds $deliveryMethodIds
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setDeliveryMethodIds(\patest\StructType\DeliveryMethodIds $deliveryMethodIds = null)
    {
        if (is_null($deliveryMethodIds) || (is_array($deliveryMethodIds) && empty($deliveryMethodIds))) {
            unset($this->DeliveryMethodIds);
        } else {
            $this->DeliveryMethodIds = $deliveryMethodIds;
        }
        return $this;
    }
    /**
     * Get FilterOnlyByTRNSIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getFilterOnlyByTRNSIds()
    {
        return isset($this->FilterOnlyByTRNSIds) ? $this->FilterOnlyByTRNSIds : null;
    }
    /**
     * Set FilterOnlyByTRNSIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $filterOnlyByTRNSIds
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setFilterOnlyByTRNSIds($filterOnlyByTRNSIds = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterOnlyByTRNSIds) && !is_bool($filterOnlyByTRNSIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($filterOnlyByTRNSIds, true), gettype($filterOnlyByTRNSIds)), __LINE__);
        }
        if (is_null($filterOnlyByTRNSIds) || (is_array($filterOnlyByTRNSIds) && empty($filterOnlyByTRNSIds))) {
            unset($this->FilterOnlyByTRNSIds);
        } else {
            $this->FilterOnlyByTRNSIds = $filterOnlyByTRNSIds;
        }
        return $this;
    }
    /**
     * Get FromFirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromFirstName()
    {
        return isset($this->FromFirstName) ? $this->FromFirstName : null;
    }
    /**
     * Set FromFirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromFirstName
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setFromFirstName($fromFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($fromFirstName) && !is_string($fromFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromFirstName, true), gettype($fromFirstName)), __LINE__);
        }
        if (is_null($fromFirstName) || (is_array($fromFirstName) && empty($fromFirstName))) {
            unset($this->FromFirstName);
        } else {
            $this->FromFirstName = $fromFirstName;
        }
        return $this;
    }
    /**
     * Get FromName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromName()
    {
        return isset($this->FromName) ? $this->FromName : null;
    }
    /**
     * Set FromName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromName
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setFromName($fromName = null)
    {
        // validation for constraint: string
        if (!is_null($fromName) && !is_string($fromName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromName, true), gettype($fromName)), __LINE__);
        }
        if (is_null($fromName) || (is_array($fromName) && empty($fromName))) {
            unset($this->FromName);
        } else {
            $this->FromName = $fromName;
        }
        return $this;
    }
    /**
     * Get IncludeClientWithPhoto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIncludeClientWithPhoto()
    {
        return isset($this->IncludeClientWithPhoto) ? $this->IncludeClientWithPhoto : null;
    }
    /**
     * Set IncludeClientWithPhoto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchPrintIncludeClientWithPhotoPolicy::valueIsValid()
     * @uses \patest\EnumType\BatchPrintIncludeClientWithPhotoPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $includeClientWithPhoto
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setIncludeClientWithPhoto($includeClientWithPhoto = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintIncludeClientWithPhotoPolicy::valueIsValid($includeClientWithPhoto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintIncludeClientWithPhotoPolicy', is_array($includeClientWithPhoto) ? implode(', ', $includeClientWithPhoto) : var_export($includeClientWithPhoto, true), implode(', ', \patest\EnumType\BatchPrintIncludeClientWithPhotoPolicy::getValidValues())), __LINE__);
        }
        if (is_null($includeClientWithPhoto) || (is_array($includeClientWithPhoto) && empty($includeClientWithPhoto))) {
            unset($this->IncludeClientWithPhoto);
        } else {
            $this->IncludeClientWithPhoto = $includeClientWithPhoto;
        }
        return $this;
    }
    /**
     * Get IncludeItemsFromUnconfirmedTransactions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIncludeItemsFromUnconfirmedTransactions()
    {
        return isset($this->IncludeItemsFromUnconfirmedTransactions) ? $this->IncludeItemsFromUnconfirmedTransactions : null;
    }
    /**
     * Set IncludeItemsFromUnconfirmedTransactions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchPrintIncludeItemsPolicy::valueIsValid()
     * @uses \patest\EnumType\BatchPrintIncludeItemsPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $includeItemsFromUnconfirmedTransactions
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setIncludeItemsFromUnconfirmedTransactions($includeItemsFromUnconfirmedTransactions = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintIncludeItemsPolicy::valueIsValid($includeItemsFromUnconfirmedTransactions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintIncludeItemsPolicy', is_array($includeItemsFromUnconfirmedTransactions) ? implode(', ', $includeItemsFromUnconfirmedTransactions) : var_export($includeItemsFromUnconfirmedTransactions, true), implode(', ', \patest\EnumType\BatchPrintIncludeItemsPolicy::getValidValues())), __LINE__);
        }
        if (is_null($includeItemsFromUnconfirmedTransactions) || (is_array($includeItemsFromUnconfirmedTransactions) && empty($includeItemsFromUnconfirmedTransactions))) {
            unset($this->IncludeItemsFromUnconfirmedTransactions);
        } else {
            $this->IncludeItemsFromUnconfirmedTransactions = $includeItemsFromUnconfirmedTransactions;
        }
        return $this;
    }
    /**
     * Get IncludeReservedItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIncludeReservedItems()
    {
        return isset($this->IncludeReservedItems) ? $this->IncludeReservedItems : null;
    }
    /**
     * Set IncludeReservedItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchPrintIncludeItemsPolicy::valueIsValid()
     * @uses \patest\EnumType\BatchPrintIncludeItemsPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $includeReservedItems
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setIncludeReservedItems($includeReservedItems = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintIncludeItemsPolicy::valueIsValid($includeReservedItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintIncludeItemsPolicy', is_array($includeReservedItems) ? implode(', ', $includeReservedItems) : var_export($includeReservedItems, true), implode(', ', \patest\EnumType\BatchPrintIncludeItemsPolicy::getValidValues())), __LINE__);
        }
        if (is_null($includeReservedItems) || (is_array($includeReservedItems) && empty($includeReservedItems))) {
            unset($this->IncludeReservedItems);
        } else {
            $this->IncludeReservedItems = $includeReservedItems;
        }
        return $this;
    }
    /**
     * Get MandatoryDocumentTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMandatoryDocumentTypes()
    {
        return isset($this->MandatoryDocumentTypes) ? $this->MandatoryDocumentTypes : null;
    }
    /**
     * Set MandatoryDocumentTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mandatoryDocumentTypes
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setMandatoryDocumentTypes($mandatoryDocumentTypes = null)
    {
        // validation for constraint: string
        if (!is_null($mandatoryDocumentTypes) && !is_string($mandatoryDocumentTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mandatoryDocumentTypes, true), gettype($mandatoryDocumentTypes)), __LINE__);
        }
        if (is_null($mandatoryDocumentTypes) || (is_array($mandatoryDocumentTypes) && empty($mandatoryDocumentTypes))) {
            unset($this->MandatoryDocumentTypes);
        } else {
            $this->MandatoryDocumentTypes = $mandatoryDocumentTypes;
        }
        return $this;
    }
    /**
     * Get NotifyOnCompletion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotifyOnCompletion()
    {
        return isset($this->NotifyOnCompletion) ? $this->NotifyOnCompletion : null;
    }
    /**
     * Set NotifyOnCompletion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notifyOnCompletion
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setNotifyOnCompletion($notifyOnCompletion = null)
    {
        // validation for constraint: string
        if (!is_null($notifyOnCompletion) && !is_string($notifyOnCompletion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notifyOnCompletion, true), gettype($notifyOnCompletion)), __LINE__);
        }
        if (is_null($notifyOnCompletion) || (is_array($notifyOnCompletion) && empty($notifyOnCompletion))) {
            unset($this->NotifyOnCompletion);
        } else {
            $this->NotifyOnCompletion = $notifyOnCompletion;
        }
        return $this;
    }
    /**
     * Get PrintCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintCount()
    {
        return isset($this->PrintCount) ? $this->PrintCount : null;
    }
    /**
     * Set PrintCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printCount
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setPrintCount($printCount = null)
    {
        // validation for constraint: int
        if (!is_null($printCount) && !(is_int($printCount) || ctype_digit($printCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printCount, true), gettype($printCount)), __LINE__);
        }
        if (is_null($printCount) || (is_array($printCount) && empty($printCount))) {
            unset($this->PrintCount);
        } else {
            $this->PrintCount = $printCount;
        }
        return $this;
    }
    /**
     * Get PrintingMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintingMode()
    {
        return isset($this->PrintingMode) ? $this->PrintingMode : null;
    }
    /**
     * Set PrintingMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchPrintingMode::valueIsValid()
     * @uses \patest\EnumType\BatchPrintingMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $printingMode
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setPrintingMode($printingMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintingMode::valueIsValid($printingMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintingMode', is_array($printingMode) ? implode(', ', $printingMode) : var_export($printingMode, true), implode(', ', \patest\EnumType\BatchPrintingMode::getValidValues())), __LINE__);
        }
        if (is_null($printingMode) || (is_array($printingMode) && empty($printingMode))) {
            unset($this->PrintingMode);
        } else {
            $this->PrintingMode = $printingMode;
        }
        return $this;
    }
    /**
     * Get PrintOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintOptions()
    {
        return isset($this->PrintOptions) ? $this->PrintOptions : null;
    }
    /**
     * Set PrintOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printOptions
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setPrintOptions($printOptions = null)
    {
        // validation for constraint: string
        if (!is_null($printOptions) && !is_string($printOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printOptions, true), gettype($printOptions)), __LINE__);
        }
        if (is_null($printOptions) || (is_array($printOptions) && empty($printOptions))) {
            unset($this->PrintOptions);
        } else {
            $this->PrintOptions = $printOptions;
        }
        return $this;
    }
    /**
     * Get PrintUpTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintUpTo()
    {
        return isset($this->PrintUpTo) ? $this->PrintUpTo : null;
    }
    /**
     * Set PrintUpTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printUpTo
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setPrintUpTo($printUpTo = null)
    {
        // validation for constraint: int
        if (!is_null($printUpTo) && !(is_int($printUpTo) || ctype_digit($printUpTo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printUpTo, true), gettype($printUpTo)), __LINE__);
        }
        if (is_null($printUpTo) || (is_array($printUpTo) && empty($printUpTo))) {
            unset($this->PrintUpTo);
        } else {
            $this->PrintUpTo = $printUpTo;
        }
        return $this;
    }
    /**
     * Get QueryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQueryId()
    {
        return isset($this->QueryId) ? $this->QueryId : null;
    }
    /**
     * Set QueryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $queryId
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setQueryId($queryId = null)
    {
        // validation for constraint: string
        if (!is_null($queryId) && !is_string($queryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queryId, true), gettype($queryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($queryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $queryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($queryId, true)), __LINE__);
        }
        if (is_null($queryId) || (is_array($queryId) && empty($queryId))) {
            unset($this->QueryId);
        } else {
            $this->QueryId = $queryId;
        }
        return $this;
    }
    /**
     * Get ReportGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReportGuid()
    {
        return isset($this->ReportGuid) ? $this->ReportGuid : null;
    }
    /**
     * Set ReportGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reportGuid
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setReportGuid($reportGuid = null)
    {
        // validation for constraint: string
        if (!is_null($reportGuid) && !is_string($reportGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportGuid, true), gettype($reportGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($reportGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $reportGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($reportGuid, true)), __LINE__);
        }
        if (is_null($reportGuid) || (is_array($reportGuid) && empty($reportGuid))) {
            unset($this->ReportGuid);
        } else {
            $this->ReportGuid = $reportGuid;
        }
        return $this;
    }
    /**
     * Get Scenario value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScenario()
    {
        return isset($this->Scenario) ? $this->Scenario : null;
    }
    /**
     * Set Scenario value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scenario
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setScenario($scenario = null)
    {
        // validation for constraint: string
        if (!is_null($scenario) && !is_string($scenario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scenario, true), gettype($scenario)), __LINE__);
        }
        if (is_null($scenario) || (is_array($scenario) && empty($scenario))) {
            unset($this->Scenario);
        } else {
            $this->Scenario = $scenario;
        }
        return $this;
    }
    /**
     * Get SiteId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiteId()
    {
        return isset($this->SiteId) ? $this->SiteId : null;
    }
    /**
     * Set SiteId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siteId
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setSiteId($siteId = null)
    {
        // validation for constraint: string
        if (!is_null($siteId) && !is_string($siteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteId, true), gettype($siteId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($siteId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $siteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($siteId, true)), __LINE__);
        }
        if (is_null($siteId) || (is_array($siteId) && empty($siteId))) {
            unset($this->SiteId);
        } else {
            $this->SiteId = $siteId;
        }
        return $this;
    }
    /**
     * Get SiteIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SiteIds|null
     */
    public function getSiteIds()
    {
        return isset($this->SiteIds) ? $this->SiteIds : null;
    }
    /**
     * Set SiteIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SiteIds $siteIds
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setSiteIds(\patest\StructType\SiteIds $siteIds = null)
    {
        if (is_null($siteIds) || (is_array($siteIds) && empty($siteIds))) {
            unset($this->SiteIds);
        } else {
            $this->SiteIds = $siteIds;
        }
        return $this;
    }
    /**
     * Get TargetPrinterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetPrinterId()
    {
        return isset($this->TargetPrinterId) ? $this->TargetPrinterId : null;
    }
    /**
     * Set TargetPrinterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetPrinterId
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setTargetPrinterId($targetPrinterId = null)
    {
        // validation for constraint: string
        if (!is_null($targetPrinterId) && !is_string($targetPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetPrinterId, true), gettype($targetPrinterId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetPrinterId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetPrinterId, true)), __LINE__);
        }
        if (is_null($targetPrinterId) || (is_array($targetPrinterId) && empty($targetPrinterId))) {
            unset($this->TargetPrinterId);
        } else {
            $this->TargetPrinterId = $targetPrinterId;
        }
        return $this;
    }
    /**
     * Get TransactionFromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionFromDate()
    {
        return isset($this->TransactionFromDate) ? $this->TransactionFromDate : null;
    }
    /**
     * Set TransactionFromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionFromDate
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setTransactionFromDate($transactionFromDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionFromDate) && !is_string($transactionFromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionFromDate, true), gettype($transactionFromDate)), __LINE__);
        }
        if (is_null($transactionFromDate) || (is_array($transactionFromDate) && empty($transactionFromDate))) {
            unset($this->TransactionFromDate);
        } else {
            $this->TransactionFromDate = $transactionFromDate;
        }
        return $this;
    }
    /**
     * Get TransactionIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionIds()
    {
        return isset($this->TransactionIds) ? $this->TransactionIds : null;
    }
    /**
     * Set TransactionIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionIds
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setTransactionIds($transactionIds = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIds) && !is_string($transactionIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionIds, true), gettype($transactionIds)), __LINE__);
        }
        if (is_null($transactionIds) || (is_array($transactionIds) && empty($transactionIds))) {
            unset($this->TransactionIds);
        } else {
            $this->TransactionIds = $transactionIds;
        }
        return $this;
    }
    /**
     * Get TransactionsFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionsFilter()
    {
        return isset($this->TransactionsFilter) ? $this->TransactionsFilter : null;
    }
    /**
     * Set TransactionsFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchPrintTransactionsFilterByOrgUnit::valueIsValid()
     * @uses \patest\EnumType\BatchPrintTransactionsFilterByOrgUnit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionsFilter
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setTransactionsFilter($transactionsFilter = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintTransactionsFilterByOrgUnit::valueIsValid($transactionsFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintTransactionsFilterByOrgUnit', is_array($transactionsFilter) ? implode(', ', $transactionsFilter) : var_export($transactionsFilter, true), implode(', ', \patest\EnumType\BatchPrintTransactionsFilterByOrgUnit::getValidValues())), __LINE__);
        }
        if (is_null($transactionsFilter) || (is_array($transactionsFilter) && empty($transactionsFilter))) {
            unset($this->TransactionsFilter);
        } else {
            $this->TransactionsFilter = $transactionsFilter;
        }
        return $this;
    }
    /**
     * Get TransactionToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionToDate()
    {
        return isset($this->TransactionToDate) ? $this->TransactionToDate : null;
    }
    /**
     * Set TransactionToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionToDate
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setTransactionToDate($transactionToDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionToDate) && !is_string($transactionToDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionToDate, true), gettype($transactionToDate)), __LINE__);
        }
        if (is_null($transactionToDate) || (is_array($transactionToDate) && empty($transactionToDate))) {
            unset($this->TransactionToDate);
        } else {
            $this->TransactionToDate = $transactionToDate;
        }
        return $this;
    }
    /**
     * Get UntilFirstlName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUntilFirstlName()
    {
        return isset($this->UntilFirstlName) ? $this->UntilFirstlName : null;
    }
    /**
     * Set UntilFirstlName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $untilFirstlName
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setUntilFirstlName($untilFirstlName = null)
    {
        // validation for constraint: string
        if (!is_null($untilFirstlName) && !is_string($untilFirstlName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($untilFirstlName, true), gettype($untilFirstlName)), __LINE__);
        }
        if (is_null($untilFirstlName) || (is_array($untilFirstlName) && empty($untilFirstlName))) {
            unset($this->UntilFirstlName);
        } else {
            $this->UntilFirstlName = $untilFirstlName;
        }
        return $this;
    }
    /**
     * Get UntilName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUntilName()
    {
        return isset($this->UntilName) ? $this->UntilName : null;
    }
    /**
     * Set UntilName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $untilName
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Request_Base
     */
    public function setUntilName($untilName = null)
    {
        // validation for constraint: string
        if (!is_null($untilName) && !is_string($untilName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($untilName, true), gettype($untilName)), __LINE__);
        }
        if (is_null($untilName) || (is_array($untilName) && empty($untilName))) {
            unset($this->UntilName);
        } else {
            $this->UntilName = $untilName;
        }
        return $this;
    }
}
