<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Printing.BasketSalePrint.Request StructType
 * @subpackage Structs
 */
class BizAction_Printing_BasketSalePrint_Request extends AnyEntity
{
    /**
     * The ItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemIds;
    /**
     * The MandatoryDocumentTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MandatoryDocumentTypes;
    /**
     * The PrintOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintOptions;
    /**
     * The Reprint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Reprint;
    /**
     * The Scenario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Scenario;
    /**
     * The TargetPrinterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetPrinterId;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * Constructor method for BizAction.Printing.BasketSalePrint.Request
     * @uses BizAction_Printing_BasketSalePrint_Request::setItemIds()
     * @uses BizAction_Printing_BasketSalePrint_Request::setMandatoryDocumentTypes()
     * @uses BizAction_Printing_BasketSalePrint_Request::setPrintOptions()
     * @uses BizAction_Printing_BasketSalePrint_Request::setReprint()
     * @uses BizAction_Printing_BasketSalePrint_Request::setScenario()
     * @uses BizAction_Printing_BasketSalePrint_Request::setTargetPrinterId()
     * @uses BizAction_Printing_BasketSalePrint_Request::setTransactionId()
     * @param string $itemIds
     * @param string $mandatoryDocumentTypes
     * @param string $printOptions
     * @param bool $reprint
     * @param string $scenario
     * @param string $targetPrinterId
     * @param string $transactionId
     */
    public function __construct($itemIds = null, $mandatoryDocumentTypes = null, $printOptions = null, $reprint = null, $scenario = null, $targetPrinterId = null, $transactionId = null)
    {
        $this
            ->setItemIds($itemIds)
            ->setMandatoryDocumentTypes($mandatoryDocumentTypes)
            ->setPrintOptions($printOptions)
            ->setReprint($reprint)
            ->setScenario($scenario)
            ->setTargetPrinterId($targetPrinterId)
            ->setTransactionId($transactionId);
    }
    /**
     * Get ItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemIds()
    {
        return isset($this->ItemIds) ? $this->ItemIds : null;
    }
    /**
     * Set ItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemIds
     * @return \patest\StructType\BizAction_Printing_BasketSalePrint_Request
     */
    public function setItemIds($itemIds = null)
    {
        // validation for constraint: string
        if (!is_null($itemIds) && !is_string($itemIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemIds, true), gettype($itemIds)), __LINE__);
        }
        if (is_null($itemIds) || (is_array($itemIds) && empty($itemIds))) {
            unset($this->ItemIds);
        } else {
            $this->ItemIds = $itemIds;
        }
        return $this;
    }
    /**
     * Get MandatoryDocumentTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMandatoryDocumentTypes()
    {
        return isset($this->MandatoryDocumentTypes) ? $this->MandatoryDocumentTypes : null;
    }
    /**
     * Set MandatoryDocumentTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mandatoryDocumentTypes
     * @return \patest\StructType\BizAction_Printing_BasketSalePrint_Request
     */
    public function setMandatoryDocumentTypes($mandatoryDocumentTypes = null)
    {
        // validation for constraint: string
        if (!is_null($mandatoryDocumentTypes) && !is_string($mandatoryDocumentTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mandatoryDocumentTypes, true), gettype($mandatoryDocumentTypes)), __LINE__);
        }
        if (is_null($mandatoryDocumentTypes) || (is_array($mandatoryDocumentTypes) && empty($mandatoryDocumentTypes))) {
            unset($this->MandatoryDocumentTypes);
        } else {
            $this->MandatoryDocumentTypes = $mandatoryDocumentTypes;
        }
        return $this;
    }
    /**
     * Get PrintOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintOptions()
    {
        return isset($this->PrintOptions) ? $this->PrintOptions : null;
    }
    /**
     * Set PrintOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printOptions
     * @return \patest\StructType\BizAction_Printing_BasketSalePrint_Request
     */
    public function setPrintOptions($printOptions = null)
    {
        // validation for constraint: string
        if (!is_null($printOptions) && !is_string($printOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printOptions, true), gettype($printOptions)), __LINE__);
        }
        if (is_null($printOptions) || (is_array($printOptions) && empty($printOptions))) {
            unset($this->PrintOptions);
        } else {
            $this->PrintOptions = $printOptions;
        }
        return $this;
    }
    /**
     * Get Reprint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReprint()
    {
        return isset($this->Reprint) ? $this->Reprint : null;
    }
    /**
     * Set Reprint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $reprint
     * @return \patest\StructType\BizAction_Printing_BasketSalePrint_Request
     */
    public function setReprint($reprint = null)
    {
        // validation for constraint: boolean
        if (!is_null($reprint) && !is_bool($reprint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reprint, true), gettype($reprint)), __LINE__);
        }
        if (is_null($reprint) || (is_array($reprint) && empty($reprint))) {
            unset($this->Reprint);
        } else {
            $this->Reprint = $reprint;
        }
        return $this;
    }
    /**
     * Get Scenario value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScenario()
    {
        return isset($this->Scenario) ? $this->Scenario : null;
    }
    /**
     * Set Scenario value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scenario
     * @return \patest\StructType\BizAction_Printing_BasketSalePrint_Request
     */
    public function setScenario($scenario = null)
    {
        // validation for constraint: string
        if (!is_null($scenario) && !is_string($scenario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scenario, true), gettype($scenario)), __LINE__);
        }
        if (is_null($scenario) || (is_array($scenario) && empty($scenario))) {
            unset($this->Scenario);
        } else {
            $this->Scenario = $scenario;
        }
        return $this;
    }
    /**
     * Get TargetPrinterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetPrinterId()
    {
        return isset($this->TargetPrinterId) ? $this->TargetPrinterId : null;
    }
    /**
     * Set TargetPrinterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetPrinterId
     * @return \patest\StructType\BizAction_Printing_BasketSalePrint_Request
     */
    public function setTargetPrinterId($targetPrinterId = null)
    {
        // validation for constraint: string
        if (!is_null($targetPrinterId) && !is_string($targetPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetPrinterId, true), gettype($targetPrinterId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetPrinterId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetPrinterId, true)), __LINE__);
        }
        if (is_null($targetPrinterId) || (is_array($targetPrinterId) && empty($targetPrinterId))) {
            unset($this->TargetPrinterId);
        } else {
            $this->TargetPrinterId = $targetPrinterId;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionId()
    {
        return isset($this->TransactionId) ? $this->TransactionId : null;
    }
    /**
     * Set TransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionId
     * @return \patest\StructType\BizAction_Printing_BasketSalePrint_Request
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        if (is_null($transactionId) || (is_array($transactionId) && empty($transactionId))) {
            unset($this->TransactionId);
        } else {
            $this->TransactionId = $transactionId;
        }
        return $this;
    }
}
