<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Payment.CheckInstallmentDate.Request StructType
 * @subpackage Structs
 */
class BizAction_Payment_CheckInstallmentDate_Request extends AnyEntity
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Date;
    /**
     * The InstallmentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InstallmentId;
    /**
     * The PaymentInstallmentsScheduleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentInstallmentsScheduleId;
    /**
     * Constructor method for BizAction.Payment.CheckInstallmentDate.Request
     * @uses BizAction_Payment_CheckInstallmentDate_Request::setDate()
     * @uses BizAction_Payment_CheckInstallmentDate_Request::setInstallmentId()
     * @uses BizAction_Payment_CheckInstallmentDate_Request::setPaymentInstallmentsScheduleId()
     * @param string $date
     * @param string $installmentId
     * @param string $paymentInstallmentsScheduleId
     */
    public function __construct($date = null, $installmentId = null, $paymentInstallmentsScheduleId = null)
    {
        $this
            ->setDate($date)
            ->setInstallmentId($installmentId)
            ->setPaymentInstallmentsScheduleId($paymentInstallmentsScheduleId);
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $date
     * @return \patest\StructType\BizAction_Payment_CheckInstallmentDate_Request
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get InstallmentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentId()
    {
        return isset($this->InstallmentId) ? $this->InstallmentId : null;
    }
    /**
     * Set InstallmentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $installmentId
     * @return \patest\StructType\BizAction_Payment_CheckInstallmentDate_Request
     */
    public function setInstallmentId($installmentId = null)
    {
        // validation for constraint: string
        if (!is_null($installmentId) && !is_string($installmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installmentId, true), gettype($installmentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($installmentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $installmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($installmentId, true)), __LINE__);
        }
        if (is_null($installmentId) || (is_array($installmentId) && empty($installmentId))) {
            unset($this->InstallmentId);
        } else {
            $this->InstallmentId = $installmentId;
        }
        return $this;
    }
    /**
     * Get PaymentInstallmentsScheduleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentInstallmentsScheduleId()
    {
        return isset($this->PaymentInstallmentsScheduleId) ? $this->PaymentInstallmentsScheduleId : null;
    }
    /**
     * Set PaymentInstallmentsScheduleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentInstallmentsScheduleId
     * @return \patest\StructType\BizAction_Payment_CheckInstallmentDate_Request
     */
    public function setPaymentInstallmentsScheduleId($paymentInstallmentsScheduleId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentInstallmentsScheduleId) && !is_string($paymentInstallmentsScheduleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentInstallmentsScheduleId, true), gettype($paymentInstallmentsScheduleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentInstallmentsScheduleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentInstallmentsScheduleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentInstallmentsScheduleId, true)), __LINE__);
        }
        if (is_null($paymentInstallmentsScheduleId) || (is_array($paymentInstallmentsScheduleId) && empty($paymentInstallmentsScheduleId))) {
            unset($this->PaymentInstallmentsScheduleId);
        } else {
            $this->PaymentInstallmentsScheduleId = $paymentInstallmentsScheduleId;
        }
        return $this;
    }
}
