<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Payment.BulkUpdateInstallments.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Payment_BulkUpdateInstallments_Request extends BizAction_Foundation_BulkOperation_Request
{
    /**
     * The Days
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Days;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The PaymentPlanIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PaymentPlanIds
     */
    public $PaymentPlanIds;
    /**
     * The TargetDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetDate;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToDate;
    /**
     * The UpdateOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UpdateOption;
    /**
     * Constructor method for BizAction.Payment.BulkUpdateInstallments.Request
     * @uses BizAction_Payment_BulkUpdateInstallments_Request::setDays()
     * @uses BizAction_Payment_BulkUpdateInstallments_Request::setFromDate()
     * @uses BizAction_Payment_BulkUpdateInstallments_Request::setPaymentPlanIds()
     * @uses BizAction_Payment_BulkUpdateInstallments_Request::setTargetDate()
     * @uses BizAction_Payment_BulkUpdateInstallments_Request::setToDate()
     * @uses BizAction_Payment_BulkUpdateInstallments_Request::setUpdateOption()
     * @param int $days
     * @param string $fromDate
     * @param \patest\StructType\PaymentPlanIds $paymentPlanIds
     * @param string $targetDate
     * @param string $toDate
     * @param string $updateOption
     */
    public function __construct($days = null, $fromDate = null, \patest\StructType\PaymentPlanIds $paymentPlanIds = null, $targetDate = null, $toDate = null, $updateOption = null)
    {
        $this
            ->setDays($days)
            ->setFromDate($fromDate)
            ->setPaymentPlanIds($paymentPlanIds)
            ->setTargetDate($targetDate)
            ->setToDate($toDate)
            ->setUpdateOption($updateOption);
    }
    /**
     * Get Days value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDays()
    {
        return isset($this->Days) ? $this->Days : null;
    }
    /**
     * Set Days value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $days
     * @return \patest\StructType\BizAction_Payment_BulkUpdateInstallments_Request
     */
    public function setDays($days = null)
    {
        // validation for constraint: int
        if (!is_null($days) && !(is_int($days) || ctype_digit($days))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($days, true), gettype($days)), __LINE__);
        }
        if (is_null($days) || (is_array($days) && empty($days))) {
            unset($this->Days);
        } else {
            $this->Days = $days;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\BizAction_Payment_BulkUpdateInstallments_Request
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get PaymentPlanIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PaymentPlanIds|null
     */
    public function getPaymentPlanIds()
    {
        return isset($this->PaymentPlanIds) ? $this->PaymentPlanIds : null;
    }
    /**
     * Set PaymentPlanIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PaymentPlanIds $paymentPlanIds
     * @return \patest\StructType\BizAction_Payment_BulkUpdateInstallments_Request
     */
    public function setPaymentPlanIds(\patest\StructType\PaymentPlanIds $paymentPlanIds = null)
    {
        if (is_null($paymentPlanIds) || (is_array($paymentPlanIds) && empty($paymentPlanIds))) {
            unset($this->PaymentPlanIds);
        } else {
            $this->PaymentPlanIds = $paymentPlanIds;
        }
        return $this;
    }
    /**
     * Get TargetDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetDate()
    {
        return isset($this->TargetDate) ? $this->TargetDate : null;
    }
    /**
     * Set TargetDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetDate
     * @return \patest\StructType\BizAction_Payment_BulkUpdateInstallments_Request
     */
    public function setTargetDate($targetDate = null)
    {
        // validation for constraint: string
        if (!is_null($targetDate) && !is_string($targetDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetDate, true), gettype($targetDate)), __LINE__);
        }
        if (is_null($targetDate) || (is_array($targetDate) && empty($targetDate))) {
            unset($this->TargetDate);
        } else {
            $this->TargetDate = $targetDate;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToDate()
    {
        return isset($this->ToDate) ? $this->ToDate : null;
    }
    /**
     * Set ToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toDate
     * @return \patest\StructType\BizAction_Payment_BulkUpdateInstallments_Request
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        if (is_null($toDate) || (is_array($toDate) && empty($toDate))) {
            unset($this->ToDate);
        } else {
            $this->ToDate = $toDate;
        }
        return $this;
    }
    /**
     * Get UpdateOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpdateOption()
    {
        return isset($this->UpdateOption) ? $this->UpdateOption : null;
    }
    /**
     * Set UpdateOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\InstallmentUpdateOption::valueIsValid()
     * @uses \patest\EnumType\InstallmentUpdateOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $updateOption
     * @return \patest\StructType\BizAction_Payment_BulkUpdateInstallments_Request
     */
    public function setUpdateOption($updateOption = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\InstallmentUpdateOption::valueIsValid($updateOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\InstallmentUpdateOption', is_array($updateOption) ? implode(', ', $updateOption) : var_export($updateOption, true), implode(', ', \patest\EnumType\InstallmentUpdateOption::getValidValues())), __LINE__);
        }
        if (is_null($updateOption) || (is_array($updateOption) && empty($updateOption))) {
            unset($this->UpdateOption);
        } else {
            $this->UpdateOption = $updateOption;
        }
        return $this;
    }
}
