<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Payment.BINCodesBatchOperation.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Payment_BINCodesBatchOperation_Request extends AnyEntity
{
    /**
     * The CreditCompanyId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CreditCompanyId;
    /**
     * The IsFirstRowIsHeaderColumn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFirstRowIsHeaderColumn;
    /**
     * The Preview
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizAction_Payment_BINCodesBatchOperation_PreviewItem
     */
    public $Preview;
    /**
     * The UploadedDataId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UploadedDataId;
    /**
     * Constructor method for BizAction.Payment.BINCodesBatchOperation.Request
     * @uses BizAction_Payment_BINCodesBatchOperation_Request::setCreditCompanyId()
     * @uses BizAction_Payment_BINCodesBatchOperation_Request::setIsFirstRowIsHeaderColumn()
     * @uses BizAction_Payment_BINCodesBatchOperation_Request::setPreview()
     * @uses BizAction_Payment_BINCodesBatchOperation_Request::setUploadedDataId()
     * @param string $creditCompanyId
     * @param bool $isFirstRowIsHeaderColumn
     * @param \patest\StructType\RecordSetOfBizAction_Payment_BINCodesBatchOperation_PreviewItem $preview
     * @param string $uploadedDataId
     */
    public function __construct($creditCompanyId = null, $isFirstRowIsHeaderColumn = null, \patest\StructType\RecordSetOfBizAction_Payment_BINCodesBatchOperation_PreviewItem $preview = null, $uploadedDataId = null)
    {
        $this
            ->setCreditCompanyId($creditCompanyId)
            ->setIsFirstRowIsHeaderColumn($isFirstRowIsHeaderColumn)
            ->setPreview($preview)
            ->setUploadedDataId($uploadedDataId);
    }
    /**
     * Get CreditCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditCompanyId()
    {
        return isset($this->CreditCompanyId) ? $this->CreditCompanyId : null;
    }
    /**
     * Set CreditCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditCompanyId
     * @return \patest\StructType\BizAction_Payment_BINCodesBatchOperation_Request
     */
    public function setCreditCompanyId($creditCompanyId = null)
    {
        // validation for constraint: string
        if (!is_null($creditCompanyId) && !is_string($creditCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditCompanyId, true), gettype($creditCompanyId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($creditCompanyId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $creditCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($creditCompanyId, true)), __LINE__);
        }
        if (is_null($creditCompanyId) || (is_array($creditCompanyId) && empty($creditCompanyId))) {
            unset($this->CreditCompanyId);
        } else {
            $this->CreditCompanyId = $creditCompanyId;
        }
        return $this;
    }
    /**
     * Get IsFirstRowIsHeaderColumn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFirstRowIsHeaderColumn()
    {
        return isset($this->IsFirstRowIsHeaderColumn) ? $this->IsFirstRowIsHeaderColumn : null;
    }
    /**
     * Set IsFirstRowIsHeaderColumn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFirstRowIsHeaderColumn
     * @return \patest\StructType\BizAction_Payment_BINCodesBatchOperation_Request
     */
    public function setIsFirstRowIsHeaderColumn($isFirstRowIsHeaderColumn = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFirstRowIsHeaderColumn) && !is_bool($isFirstRowIsHeaderColumn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFirstRowIsHeaderColumn, true), gettype($isFirstRowIsHeaderColumn)), __LINE__);
        }
        if (is_null($isFirstRowIsHeaderColumn) || (is_array($isFirstRowIsHeaderColumn) && empty($isFirstRowIsHeaderColumn))) {
            unset($this->IsFirstRowIsHeaderColumn);
        } else {
            $this->IsFirstRowIsHeaderColumn = $isFirstRowIsHeaderColumn;
        }
        return $this;
    }
    /**
     * Get Preview value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizAction_Payment_BINCodesBatchOperation_PreviewItem|null
     */
    public function getPreview()
    {
        return isset($this->Preview) ? $this->Preview : null;
    }
    /**
     * Set Preview value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizAction_Payment_BINCodesBatchOperation_PreviewItem $preview
     * @return \patest\StructType\BizAction_Payment_BINCodesBatchOperation_Request
     */
    public function setPreview(\patest\StructType\RecordSetOfBizAction_Payment_BINCodesBatchOperation_PreviewItem $preview = null)
    {
        if (is_null($preview) || (is_array($preview) && empty($preview))) {
            unset($this->Preview);
        } else {
            $this->Preview = $preview;
        }
        return $this;
    }
    /**
     * Get UploadedDataId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUploadedDataId()
    {
        return isset($this->UploadedDataId) ? $this->UploadedDataId : null;
    }
    /**
     * Set UploadedDataId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uploadedDataId
     * @return \patest\StructType\BizAction_Payment_BINCodesBatchOperation_Request
     */
    public function setUploadedDataId($uploadedDataId = null)
    {
        // validation for constraint: string
        if (!is_null($uploadedDataId) && !is_string($uploadedDataId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uploadedDataId, true), gettype($uploadedDataId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($uploadedDataId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $uploadedDataId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($uploadedDataId, true)), __LINE__);
        }
        if (is_null($uploadedDataId) || (is_array($uploadedDataId) && empty($uploadedDataId))) {
            unset($this->UploadedDataId);
        } else {
            $this->UploadedDataId = $uploadedDataId;
        }
        return $this;
    }
}
