<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Payment.AdviseReimbursement.Request StructType
 * @subpackage Structs
 */
class BizAction_Payment_AdviseReimbursement_Request extends AnyEntity
{
    /**
     * The NeedToRefershBasket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NeedToRefershBasket;
    /**
     * The ReimbursementItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPayment_UIReimbursementItem
     */
    public $ReimbursementItems;
    /**
     * The ReimbursementItemsTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReimbursementItemsTitle;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The UseAutomaticallyReimburse
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseAutomaticallyReimburse;
    /**
     * The UseReimburseOneOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseReimburseOneOption;
    /**
     * The UserInfoMsg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserInfoMsg;
    /**
     * Constructor method for BizAction.Payment.AdviseReimbursement.Request
     * @uses BizAction_Payment_AdviseReimbursement_Request::setNeedToRefershBasket()
     * @uses BizAction_Payment_AdviseReimbursement_Request::setReimbursementItems()
     * @uses BizAction_Payment_AdviseReimbursement_Request::setReimbursementItemsTitle()
     * @uses BizAction_Payment_AdviseReimbursement_Request::setTransactionGuid()
     * @uses BizAction_Payment_AdviseReimbursement_Request::setUseAutomaticallyReimburse()
     * @uses BizAction_Payment_AdviseReimbursement_Request::setUseReimburseOneOption()
     * @uses BizAction_Payment_AdviseReimbursement_Request::setUserInfoMsg()
     * @param bool $needToRefershBasket
     * @param \patest\StructType\RecordSetOfPayment_UIReimbursementItem $reimbursementItems
     * @param string $reimbursementItemsTitle
     * @param string $transactionGuid
     * @param bool $useAutomaticallyReimburse
     * @param bool $useReimburseOneOption
     * @param string $userInfoMsg
     */
    public function __construct($needToRefershBasket = null, \patest\StructType\RecordSetOfPayment_UIReimbursementItem $reimbursementItems = null, $reimbursementItemsTitle = null, $transactionGuid = null, $useAutomaticallyReimburse = null, $useReimburseOneOption = null, $userInfoMsg = null)
    {
        $this
            ->setNeedToRefershBasket($needToRefershBasket)
            ->setReimbursementItems($reimbursementItems)
            ->setReimbursementItemsTitle($reimbursementItemsTitle)
            ->setTransactionGuid($transactionGuid)
            ->setUseAutomaticallyReimburse($useAutomaticallyReimburse)
            ->setUseReimburseOneOption($useReimburseOneOption)
            ->setUserInfoMsg($userInfoMsg);
    }
    /**
     * Get NeedToRefershBasket value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNeedToRefershBasket()
    {
        return isset($this->NeedToRefershBasket) ? $this->NeedToRefershBasket : null;
    }
    /**
     * Set NeedToRefershBasket value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $needToRefershBasket
     * @return \patest\StructType\BizAction_Payment_AdviseReimbursement_Request
     */
    public function setNeedToRefershBasket($needToRefershBasket = null)
    {
        // validation for constraint: boolean
        if (!is_null($needToRefershBasket) && !is_bool($needToRefershBasket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($needToRefershBasket, true), gettype($needToRefershBasket)), __LINE__);
        }
        if (is_null($needToRefershBasket) || (is_array($needToRefershBasket) && empty($needToRefershBasket))) {
            unset($this->NeedToRefershBasket);
        } else {
            $this->NeedToRefershBasket = $needToRefershBasket;
        }
        return $this;
    }
    /**
     * Get ReimbursementItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPayment_UIReimbursementItem|null
     */
    public function getReimbursementItems()
    {
        return isset($this->ReimbursementItems) ? $this->ReimbursementItems : null;
    }
    /**
     * Set ReimbursementItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPayment_UIReimbursementItem $reimbursementItems
     * @return \patest\StructType\BizAction_Payment_AdviseReimbursement_Request
     */
    public function setReimbursementItems(\patest\StructType\RecordSetOfPayment_UIReimbursementItem $reimbursementItems = null)
    {
        if (is_null($reimbursementItems) || (is_array($reimbursementItems) && empty($reimbursementItems))) {
            unset($this->ReimbursementItems);
        } else {
            $this->ReimbursementItems = $reimbursementItems;
        }
        return $this;
    }
    /**
     * Get ReimbursementItemsTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReimbursementItemsTitle()
    {
        return isset($this->ReimbursementItemsTitle) ? $this->ReimbursementItemsTitle : null;
    }
    /**
     * Set ReimbursementItemsTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reimbursementItemsTitle
     * @return \patest\StructType\BizAction_Payment_AdviseReimbursement_Request
     */
    public function setReimbursementItemsTitle($reimbursementItemsTitle = null)
    {
        // validation for constraint: string
        if (!is_null($reimbursementItemsTitle) && !is_string($reimbursementItemsTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reimbursementItemsTitle, true), gettype($reimbursementItemsTitle)), __LINE__);
        }
        if (is_null($reimbursementItemsTitle) || (is_array($reimbursementItemsTitle) && empty($reimbursementItemsTitle))) {
            unset($this->ReimbursementItemsTitle);
        } else {
            $this->ReimbursementItemsTitle = $reimbursementItemsTitle;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\BizAction_Payment_AdviseReimbursement_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get UseAutomaticallyReimburse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseAutomaticallyReimburse()
    {
        return isset($this->UseAutomaticallyReimburse) ? $this->UseAutomaticallyReimburse : null;
    }
    /**
     * Set UseAutomaticallyReimburse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useAutomaticallyReimburse
     * @return \patest\StructType\BizAction_Payment_AdviseReimbursement_Request
     */
    public function setUseAutomaticallyReimburse($useAutomaticallyReimburse = null)
    {
        // validation for constraint: boolean
        if (!is_null($useAutomaticallyReimburse) && !is_bool($useAutomaticallyReimburse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useAutomaticallyReimburse, true), gettype($useAutomaticallyReimburse)), __LINE__);
        }
        if (is_null($useAutomaticallyReimburse) || (is_array($useAutomaticallyReimburse) && empty($useAutomaticallyReimburse))) {
            unset($this->UseAutomaticallyReimburse);
        } else {
            $this->UseAutomaticallyReimburse = $useAutomaticallyReimburse;
        }
        return $this;
    }
    /**
     * Get UseReimburseOneOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseReimburseOneOption()
    {
        return isset($this->UseReimburseOneOption) ? $this->UseReimburseOneOption : null;
    }
    /**
     * Set UseReimburseOneOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useReimburseOneOption
     * @return \patest\StructType\BizAction_Payment_AdviseReimbursement_Request
     */
    public function setUseReimburseOneOption($useReimburseOneOption = null)
    {
        // validation for constraint: boolean
        if (!is_null($useReimburseOneOption) && !is_bool($useReimburseOneOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useReimburseOneOption, true), gettype($useReimburseOneOption)), __LINE__);
        }
        if (is_null($useReimburseOneOption) || (is_array($useReimburseOneOption) && empty($useReimburseOneOption))) {
            unset($this->UseReimburseOneOption);
        } else {
            $this->UseReimburseOneOption = $useReimburseOneOption;
        }
        return $this;
    }
    /**
     * Get UserInfoMsg value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserInfoMsg()
    {
        return isset($this->UserInfoMsg) ? $this->UserInfoMsg : null;
    }
    /**
     * Set UserInfoMsg value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userInfoMsg
     * @return \patest\StructType\BizAction_Payment_AdviseReimbursement_Request
     */
    public function setUserInfoMsg($userInfoMsg = null)
    {
        // validation for constraint: string
        if (!is_null($userInfoMsg) && !is_string($userInfoMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userInfoMsg, true), gettype($userInfoMsg)), __LINE__);
        }
        if (is_null($userInfoMsg) || (is_array($userInfoMsg) && empty($userInfoMsg))) {
            unset($this->UserInfoMsg);
        } else {
            $this->UserInfoMsg = $userInfoMsg;
        }
        return $this;
    }
}
