<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.GiftVoucher.VoucherInquiry.Response StructType
 * @subpackage Structs
 */
class BizAction_GiftVoucher_VoucherInquiry_Response extends AnyEntity
{
    /**
     * The Balance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Balance;
    /**
     * The ErrorMsg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMsg;
    /**
     * The ExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpiryDate;
    /**
     * The GiftVoucherItemRedeemTransactions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfGiftVoucher_GiftVoucherItemTransaction
     */
    public $GiftVoucherItemRedeemTransactions;
    /**
     * The OriginalRedemptionValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginalRedemptionValue;
    /**
     * The OriginalTransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalTransactionGuid;
    /**
     * The OriginalTransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginalTransactionNumber;
    /**
     * The PurchaseDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PurchaseDate;
    /**
     * The PurchaserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PurchaserId;
    /**
     * The PurchaserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PurchaserName;
    /**
     * The VoucherNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VoucherNumber;
    /**
     * Constructor method for BizAction.GiftVoucher.VoucherInquiry.Response
     * @uses BizAction_GiftVoucher_VoucherInquiry_Response::setBalance()
     * @uses BizAction_GiftVoucher_VoucherInquiry_Response::setErrorMsg()
     * @uses BizAction_GiftVoucher_VoucherInquiry_Response::setExpiryDate()
     * @uses BizAction_GiftVoucher_VoucherInquiry_Response::setGiftVoucherItemRedeemTransactions()
     * @uses BizAction_GiftVoucher_VoucherInquiry_Response::setOriginalRedemptionValue()
     * @uses BizAction_GiftVoucher_VoucherInquiry_Response::setOriginalTransactionGuid()
     * @uses BizAction_GiftVoucher_VoucherInquiry_Response::setOriginalTransactionNumber()
     * @uses BizAction_GiftVoucher_VoucherInquiry_Response::setPurchaseDate()
     * @uses BizAction_GiftVoucher_VoucherInquiry_Response::setPurchaserId()
     * @uses BizAction_GiftVoucher_VoucherInquiry_Response::setPurchaserName()
     * @uses BizAction_GiftVoucher_VoucherInquiry_Response::setVoucherNumber()
     * @param string $balance
     * @param string $errorMsg
     * @param string $expiryDate
     * @param \patest\StructType\RecordSetOfGiftVoucher_GiftVoucherItemTransaction $giftVoucherItemRedeemTransactions
     * @param string $originalRedemptionValue
     * @param string $originalTransactionGuid
     * @param string $originalTransactionNumber
     * @param string $purchaseDate
     * @param string $purchaserId
     * @param string $purchaserName
     * @param string $voucherNumber
     */
    public function __construct($balance = null, $errorMsg = null, $expiryDate = null, \patest\StructType\RecordSetOfGiftVoucher_GiftVoucherItemTransaction $giftVoucherItemRedeemTransactions = null, $originalRedemptionValue = null, $originalTransactionGuid = null, $originalTransactionNumber = null, $purchaseDate = null, $purchaserId = null, $purchaserName = null, $voucherNumber = null)
    {
        $this
            ->setBalance($balance)
            ->setErrorMsg($errorMsg)
            ->setExpiryDate($expiryDate)
            ->setGiftVoucherItemRedeemTransactions($giftVoucherItemRedeemTransactions)
            ->setOriginalRedemptionValue($originalRedemptionValue)
            ->setOriginalTransactionGuid($originalTransactionGuid)
            ->setOriginalTransactionNumber($originalTransactionNumber)
            ->setPurchaseDate($purchaseDate)
            ->setPurchaserId($purchaserId)
            ->setPurchaserName($purchaserName)
            ->setVoucherNumber($voucherNumber);
    }
    /**
     * Get Balance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBalance()
    {
        return isset($this->Balance) ? $this->Balance : null;
    }
    /**
     * Set Balance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $balance
     * @return \patest\StructType\BizAction_GiftVoucher_VoucherInquiry_Response
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: string
        if (!is_null($balance) && !is_string($balance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        if (is_null($balance) || (is_array($balance) && empty($balance))) {
            unset($this->Balance);
        } else {
            $this->Balance = $balance;
        }
        return $this;
    }
    /**
     * Get ErrorMsg value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMsg()
    {
        return isset($this->ErrorMsg) ? $this->ErrorMsg : null;
    }
    /**
     * Set ErrorMsg value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMsg
     * @return \patest\StructType\BizAction_GiftVoucher_VoucherInquiry_Response
     */
    public function setErrorMsg($errorMsg = null)
    {
        // validation for constraint: string
        if (!is_null($errorMsg) && !is_string($errorMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMsg, true), gettype($errorMsg)), __LINE__);
        }
        if (is_null($errorMsg) || (is_array($errorMsg) && empty($errorMsg))) {
            unset($this->ErrorMsg);
        } else {
            $this->ErrorMsg = $errorMsg;
        }
        return $this;
    }
    /**
     * Get ExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiryDate()
    {
        return isset($this->ExpiryDate) ? $this->ExpiryDate : null;
    }
    /**
     * Set ExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiryDate
     * @return \patest\StructType\BizAction_GiftVoucher_VoucherInquiry_Response
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDate, true), gettype($expiryDate)), __LINE__);
        }
        if (is_null($expiryDate) || (is_array($expiryDate) && empty($expiryDate))) {
            unset($this->ExpiryDate);
        } else {
            $this->ExpiryDate = $expiryDate;
        }
        return $this;
    }
    /**
     * Get GiftVoucherItemRedeemTransactions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfGiftVoucher_GiftVoucherItemTransaction|null
     */
    public function getGiftVoucherItemRedeemTransactions()
    {
        return isset($this->GiftVoucherItemRedeemTransactions) ? $this->GiftVoucherItemRedeemTransactions : null;
    }
    /**
     * Set GiftVoucherItemRedeemTransactions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfGiftVoucher_GiftVoucherItemTransaction $giftVoucherItemRedeemTransactions
     * @return \patest\StructType\BizAction_GiftVoucher_VoucherInquiry_Response
     */
    public function setGiftVoucherItemRedeemTransactions(\patest\StructType\RecordSetOfGiftVoucher_GiftVoucherItemTransaction $giftVoucherItemRedeemTransactions = null)
    {
        if (is_null($giftVoucherItemRedeemTransactions) || (is_array($giftVoucherItemRedeemTransactions) && empty($giftVoucherItemRedeemTransactions))) {
            unset($this->GiftVoucherItemRedeemTransactions);
        } else {
            $this->GiftVoucherItemRedeemTransactions = $giftVoucherItemRedeemTransactions;
        }
        return $this;
    }
    /**
     * Get OriginalRedemptionValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalRedemptionValue()
    {
        return isset($this->OriginalRedemptionValue) ? $this->OriginalRedemptionValue : null;
    }
    /**
     * Set OriginalRedemptionValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalRedemptionValue
     * @return \patest\StructType\BizAction_GiftVoucher_VoucherInquiry_Response
     */
    public function setOriginalRedemptionValue($originalRedemptionValue = null)
    {
        // validation for constraint: string
        if (!is_null($originalRedemptionValue) && !is_string($originalRedemptionValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalRedemptionValue, true), gettype($originalRedemptionValue)), __LINE__);
        }
        if (is_null($originalRedemptionValue) || (is_array($originalRedemptionValue) && empty($originalRedemptionValue))) {
            unset($this->OriginalRedemptionValue);
        } else {
            $this->OriginalRedemptionValue = $originalRedemptionValue;
        }
        return $this;
    }
    /**
     * Get OriginalTransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalTransactionGuid()
    {
        return isset($this->OriginalTransactionGuid) ? $this->OriginalTransactionGuid : null;
    }
    /**
     * Set OriginalTransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalTransactionGuid
     * @return \patest\StructType\BizAction_GiftVoucher_VoucherInquiry_Response
     */
    public function setOriginalTransactionGuid($originalTransactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($originalTransactionGuid) && !is_string($originalTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalTransactionGuid, true), gettype($originalTransactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalTransactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalTransactionGuid, true)), __LINE__);
        }
        if (is_null($originalTransactionGuid) || (is_array($originalTransactionGuid) && empty($originalTransactionGuid))) {
            unset($this->OriginalTransactionGuid);
        } else {
            $this->OriginalTransactionGuid = $originalTransactionGuid;
        }
        return $this;
    }
    /**
     * Get OriginalTransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalTransactionNumber()
    {
        return isset($this->OriginalTransactionNumber) ? $this->OriginalTransactionNumber : null;
    }
    /**
     * Set OriginalTransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalTransactionNumber
     * @return \patest\StructType\BizAction_GiftVoucher_VoucherInquiry_Response
     */
    public function setOriginalTransactionNumber($originalTransactionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($originalTransactionNumber) && !is_string($originalTransactionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalTransactionNumber, true), gettype($originalTransactionNumber)), __LINE__);
        }
        if (is_null($originalTransactionNumber) || (is_array($originalTransactionNumber) && empty($originalTransactionNumber))) {
            unset($this->OriginalTransactionNumber);
        } else {
            $this->OriginalTransactionNumber = $originalTransactionNumber;
        }
        return $this;
    }
    /**
     * Get PurchaseDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurchaseDate()
    {
        return isset($this->PurchaseDate) ? $this->PurchaseDate : null;
    }
    /**
     * Set PurchaseDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purchaseDate
     * @return \patest\StructType\BizAction_GiftVoucher_VoucherInquiry_Response
     */
    public function setPurchaseDate($purchaseDate = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseDate) && !is_string($purchaseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseDate, true), gettype($purchaseDate)), __LINE__);
        }
        if (is_null($purchaseDate) || (is_array($purchaseDate) && empty($purchaseDate))) {
            unset($this->PurchaseDate);
        } else {
            $this->PurchaseDate = $purchaseDate;
        }
        return $this;
    }
    /**
     * Get PurchaserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurchaserId()
    {
        return isset($this->PurchaserId) ? $this->PurchaserId : null;
    }
    /**
     * Set PurchaserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purchaserId
     * @return \patest\StructType\BizAction_GiftVoucher_VoucherInquiry_Response
     */
    public function setPurchaserId($purchaserId = null)
    {
        // validation for constraint: string
        if (!is_null($purchaserId) && !is_string($purchaserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaserId, true), gettype($purchaserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($purchaserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $purchaserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($purchaserId, true)), __LINE__);
        }
        if (is_null($purchaserId) || (is_array($purchaserId) && empty($purchaserId))) {
            unset($this->PurchaserId);
        } else {
            $this->PurchaserId = $purchaserId;
        }
        return $this;
    }
    /**
     * Get PurchaserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurchaserName()
    {
        return isset($this->PurchaserName) ? $this->PurchaserName : null;
    }
    /**
     * Set PurchaserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purchaserName
     * @return \patest\StructType\BizAction_GiftVoucher_VoucherInquiry_Response
     */
    public function setPurchaserName($purchaserName = null)
    {
        // validation for constraint: string
        if (!is_null($purchaserName) && !is_string($purchaserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaserName, true), gettype($purchaserName)), __LINE__);
        }
        if (is_null($purchaserName) || (is_array($purchaserName) && empty($purchaserName))) {
            unset($this->PurchaserName);
        } else {
            $this->PurchaserName = $purchaserName;
        }
        return $this;
    }
    /**
     * Get VoucherNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoucherNumber()
    {
        return isset($this->VoucherNumber) ? $this->VoucherNumber : null;
    }
    /**
     * Set VoucherNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voucherNumber
     * @return \patest\StructType\BizAction_GiftVoucher_VoucherInquiry_Response
     */
    public function setVoucherNumber($voucherNumber = null)
    {
        // validation for constraint: string
        if (!is_null($voucherNumber) && !is_string($voucherNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherNumber, true), gettype($voucherNumber)), __LINE__);
        }
        if (is_null($voucherNumber) || (is_array($voucherNumber) && empty($voucherNumber))) {
            unset($this->VoucherNumber);
        } else {
            $this->VoucherNumber = $voucherNumber;
        }
        return $this;
    }
}
