<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Foundation.DownloadBulkOperationData.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Foundation_DownloadBulkOperationData_Request extends BizAction_Foundation_BulkOperation_RequestBase
{
    /**
     * The DownloadOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DownloadOptions;
    /**
     * The IncludeExecutionResultsAndErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeExecutionResultsAndErrors;
    /**
     * Constructor method for BizAction.Foundation.DownloadBulkOperationData.Request
     * @uses BizAction_Foundation_DownloadBulkOperationData_Request::setDownloadOptions()
     * @uses BizAction_Foundation_DownloadBulkOperationData_Request::setIncludeExecutionResultsAndErrors()
     * @param string $downloadOptions
     * @param bool $includeExecutionResultsAndErrors
     */
    public function __construct($downloadOptions = null, $includeExecutionResultsAndErrors = null)
    {
        $this
            ->setDownloadOptions($downloadOptions)
            ->setIncludeExecutionResultsAndErrors($includeExecutionResultsAndErrors);
    }
    /**
     * Get DownloadOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDownloadOptions()
    {
        return isset($this->DownloadOptions) ? $this->DownloadOptions : null;
    }
    /**
     * Set DownloadOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BulkOperationDownloadFileOptions::valueIsValid()
     * @uses \patest\EnumType\BulkOperationDownloadFileOptions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $downloadOptions
     * @return \patest\StructType\BizAction_Foundation_DownloadBulkOperationData_Request
     */
    public function setDownloadOptions($downloadOptions = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BulkOperationDownloadFileOptions::valueIsValid($downloadOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BulkOperationDownloadFileOptions', is_array($downloadOptions) ? implode(', ', $downloadOptions) : var_export($downloadOptions, true), implode(', ', \patest\EnumType\BulkOperationDownloadFileOptions::getValidValues())), __LINE__);
        }
        if (is_null($downloadOptions) || (is_array($downloadOptions) && empty($downloadOptions))) {
            unset($this->DownloadOptions);
        } else {
            $this->DownloadOptions = $downloadOptions;
        }
        return $this;
    }
    /**
     * Get IncludeExecutionResultsAndErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeExecutionResultsAndErrors()
    {
        return isset($this->IncludeExecutionResultsAndErrors) ? $this->IncludeExecutionResultsAndErrors : null;
    }
    /**
     * Set IncludeExecutionResultsAndErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeExecutionResultsAndErrors
     * @return \patest\StructType\BizAction_Foundation_DownloadBulkOperationData_Request
     */
    public function setIncludeExecutionResultsAndErrors($includeExecutionResultsAndErrors = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeExecutionResultsAndErrors) && !is_bool($includeExecutionResultsAndErrors)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeExecutionResultsAndErrors, true), gettype($includeExecutionResultsAndErrors)), __LINE__);
        }
        if (is_null($includeExecutionResultsAndErrors) || (is_array($includeExecutionResultsAndErrors) && empty($includeExecutionResultsAndErrors))) {
            unset($this->IncludeExecutionResultsAndErrors);
        } else {
            $this->IncludeExecutionResultsAndErrors = $includeExecutionResultsAndErrors;
        }
        return $this;
    }
}
