<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Foundation.BulkOperation.RequestBase StructType
 * @subpackage Structs
 */
class BizAction_Foundation_BulkOperation_RequestBase extends AnyEntity
{
    /**
     * The OperationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OperationId;
    /**
     * Constructor method for BizAction.Foundation.BulkOperation.RequestBase
     * @uses BizAction_Foundation_BulkOperation_RequestBase::setOperationId()
     * @param string $operationId
     */
    public function __construct($operationId = null)
    {
        $this
            ->setOperationId($operationId);
    }
    /**
     * Get OperationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperationId()
    {
        return isset($this->OperationId) ? $this->OperationId : null;
    }
    /**
     * Set OperationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operationId
     * @return \patest\StructType\BizAction_Foundation_BulkOperation_RequestBase
     */
    public function setOperationId($operationId = null)
    {
        // validation for constraint: string
        if (!is_null($operationId) && !is_string($operationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationId, true), gettype($operationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($operationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $operationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($operationId, true)), __LINE__);
        }
        if (is_null($operationId) || (is_array($operationId) && empty($operationId))) {
            unset($this->OperationId);
        } else {
            $this->OperationId = $operationId;
        }
        return $this;
    }
}
