<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Donation.PerformTicketTurnback.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Donation_PerformTicketTurnback_Request extends AnyEntity
{
    /**
     * The DonatingClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DonatingClientId;
    /**
     * The FundId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FundId;
    /**
     * The Tickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfDonation_TicketTurnbackTicketRecord
     */
    public $Tickets;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for BizAction.Donation.PerformTicketTurnback.Request
     * @uses BizAction_Donation_PerformTicketTurnback_Request::setDonatingClientId()
     * @uses BizAction_Donation_PerformTicketTurnback_Request::setFundId()
     * @uses BizAction_Donation_PerformTicketTurnback_Request::setTickets()
     * @uses BizAction_Donation_PerformTicketTurnback_Request::setTransactionGuid()
     * @param string $donatingClientId
     * @param string $fundId
     * @param \patest\StructType\RecordSetOfDonation_TicketTurnbackTicketRecord $tickets
     * @param string $transactionGuid
     */
    public function __construct($donatingClientId = null, $fundId = null, \patest\StructType\RecordSetOfDonation_TicketTurnbackTicketRecord $tickets = null, $transactionGuid = null)
    {
        $this
            ->setDonatingClientId($donatingClientId)
            ->setFundId($fundId)
            ->setTickets($tickets)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get DonatingClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDonatingClientId()
    {
        return isset($this->DonatingClientId) ? $this->DonatingClientId : null;
    }
    /**
     * Set DonatingClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $donatingClientId
     * @return \patest\StructType\BizAction_Donation_PerformTicketTurnback_Request
     */
    public function setDonatingClientId($donatingClientId = null)
    {
        // validation for constraint: string
        if (!is_null($donatingClientId) && !is_string($donatingClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($donatingClientId, true), gettype($donatingClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($donatingClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $donatingClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($donatingClientId, true)), __LINE__);
        }
        if (is_null($donatingClientId) || (is_array($donatingClientId) && empty($donatingClientId))) {
            unset($this->DonatingClientId);
        } else {
            $this->DonatingClientId = $donatingClientId;
        }
        return $this;
    }
    /**
     * Get FundId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFundId()
    {
        return isset($this->FundId) ? $this->FundId : null;
    }
    /**
     * Set FundId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fundId
     * @return \patest\StructType\BizAction_Donation_PerformTicketTurnback_Request
     */
    public function setFundId($fundId = null)
    {
        // validation for constraint: string
        if (!is_null($fundId) && !is_string($fundId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fundId, true), gettype($fundId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($fundId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $fundId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($fundId, true)), __LINE__);
        }
        if (is_null($fundId) || (is_array($fundId) && empty($fundId))) {
            unset($this->FundId);
        } else {
            $this->FundId = $fundId;
        }
        return $this;
    }
    /**
     * Get Tickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfDonation_TicketTurnbackTicketRecord|null
     */
    public function getTickets()
    {
        return isset($this->Tickets) ? $this->Tickets : null;
    }
    /**
     * Set Tickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfDonation_TicketTurnbackTicketRecord $tickets
     * @return \patest\StructType\BizAction_Donation_PerformTicketTurnback_Request
     */
    public function setTickets(\patest\StructType\RecordSetOfDonation_TicketTurnbackTicketRecord $tickets = null)
    {
        if (is_null($tickets) || (is_array($tickets) && empty($tickets))) {
            unset($this->Tickets);
        } else {
            $this->Tickets = $tickets;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\BizAction_Donation_PerformTicketTurnback_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
}
