<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Crm.SubscriptionAutoRenewalEnrollments.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request extends AnyEntity
{
    /**
     * The CanUseExistingPlanDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanUseExistingPlanDetails;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The DirectDebitMandateId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DirectDebitMandateId;
    /**
     * The EnrolledSubscriptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizAction_Crm_AutoRenewalClientEnrollment
     */
    public $EnrolledSubscriptions;
    /**
     * The IsEnroll
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsEnroll;
    /**
     * The IsEnrollWithoutPaymentDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsEnrollWithoutPaymentDetails;
    /**
     * The IsOnlyNewEnrollments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsOnlyNewEnrollments;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentMethodType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodType;
    /**
     * The PaymentPlanPaymentDayOfMonth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PaymentPlanPaymentDayOfMonth;
    /**
     * The PaymentPlanPaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentPlanPaymentMethodId;
    /**
     * The PaymentPlanPaymentMethodType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentPlanPaymentMethodType;
    /**
     * The PaymentPlanPaymentTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentPlanPaymentTokenId;
    /**
     * The PaymentTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentTokenId;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The SeriesIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesIds;
    /**
     * The SeriesName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SeriesName;
    /**
     * The SubscriptionInstanceIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SubscriptionInstanceIds
     */
    public $SubscriptionInstanceIds;
    /**
     * The UseExistingPlanDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseExistingPlanDetails;
    /**
     * Constructor method for BizAction.Crm.SubscriptionAutoRenewalEnrollments.Request
     * @uses BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request::setCanUseExistingPlanDetails()
     * @uses BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request::setClientId()
     * @uses BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request::setDirectDebitMandateId()
     * @uses BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request::setEnrolledSubscriptions()
     * @uses BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request::setIsEnroll()
     * @uses BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request::setIsEnrollWithoutPaymentDetails()
     * @uses BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request::setIsOnlyNewEnrollments()
     * @uses BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request::setPaymentMethodId()
     * @uses BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request::setPaymentMethodType()
     * @uses BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request::setPaymentPlanPaymentDayOfMonth()
     * @uses BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request::setPaymentPlanPaymentMethodId()
     * @uses BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request::setPaymentPlanPaymentMethodType()
     * @uses BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request::setPaymentPlanPaymentTokenId()
     * @uses BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request::setPaymentTokenId()
     * @uses BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request::setSeriesId()
     * @uses BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request::setSeriesIds()
     * @uses BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request::setSeriesName()
     * @uses BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request::setSubscriptionInstanceIds()
     * @uses BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request::setUseExistingPlanDetails()
     * @param bool $canUseExistingPlanDetails
     * @param string $clientId
     * @param string $directDebitMandateId
     * @param \patest\StructType\RecordSetOfBizAction_Crm_AutoRenewalClientEnrollment $enrolledSubscriptions
     * @param bool $isEnroll
     * @param bool $isEnrollWithoutPaymentDetails
     * @param bool $isOnlyNewEnrollments
     * @param string $paymentMethodId
     * @param string $paymentMethodType
     * @param int $paymentPlanPaymentDayOfMonth
     * @param string $paymentPlanPaymentMethodId
     * @param string $paymentPlanPaymentMethodType
     * @param string $paymentPlanPaymentTokenId
     * @param string $paymentTokenId
     * @param string $seriesId
     * @param string $seriesIds
     * @param \patest\StructType\GlobalString $seriesName
     * @param \patest\StructType\SubscriptionInstanceIds $subscriptionInstanceIds
     * @param bool $useExistingPlanDetails
     */
    public function __construct($canUseExistingPlanDetails = null, $clientId = null, $directDebitMandateId = null, \patest\StructType\RecordSetOfBizAction_Crm_AutoRenewalClientEnrollment $enrolledSubscriptions = null, $isEnroll = null, $isEnrollWithoutPaymentDetails = null, $isOnlyNewEnrollments = null, $paymentMethodId = null, $paymentMethodType = null, $paymentPlanPaymentDayOfMonth = null, $paymentPlanPaymentMethodId = null, $paymentPlanPaymentMethodType = null, $paymentPlanPaymentTokenId = null, $paymentTokenId = null, $seriesId = null, $seriesIds = null, \patest\StructType\GlobalString $seriesName = null, \patest\StructType\SubscriptionInstanceIds $subscriptionInstanceIds = null, $useExistingPlanDetails = null)
    {
        $this
            ->setCanUseExistingPlanDetails($canUseExistingPlanDetails)
            ->setClientId($clientId)
            ->setDirectDebitMandateId($directDebitMandateId)
            ->setEnrolledSubscriptions($enrolledSubscriptions)
            ->setIsEnroll($isEnroll)
            ->setIsEnrollWithoutPaymentDetails($isEnrollWithoutPaymentDetails)
            ->setIsOnlyNewEnrollments($isOnlyNewEnrollments)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentMethodType($paymentMethodType)
            ->setPaymentPlanPaymentDayOfMonth($paymentPlanPaymentDayOfMonth)
            ->setPaymentPlanPaymentMethodId($paymentPlanPaymentMethodId)
            ->setPaymentPlanPaymentMethodType($paymentPlanPaymentMethodType)
            ->setPaymentPlanPaymentTokenId($paymentPlanPaymentTokenId)
            ->setPaymentTokenId($paymentTokenId)
            ->setSeriesId($seriesId)
            ->setSeriesIds($seriesIds)
            ->setSeriesName($seriesName)
            ->setSubscriptionInstanceIds($subscriptionInstanceIds)
            ->setUseExistingPlanDetails($useExistingPlanDetails);
    }
    /**
     * Get CanUseExistingPlanDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanUseExistingPlanDetails()
    {
        return isset($this->CanUseExistingPlanDetails) ? $this->CanUseExistingPlanDetails : null;
    }
    /**
     * Set CanUseExistingPlanDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canUseExistingPlanDetails
     * @return \patest\StructType\BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request
     */
    public function setCanUseExistingPlanDetails($canUseExistingPlanDetails = null)
    {
        // validation for constraint: boolean
        if (!is_null($canUseExistingPlanDetails) && !is_bool($canUseExistingPlanDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canUseExistingPlanDetails, true), gettype($canUseExistingPlanDetails)), __LINE__);
        }
        if (is_null($canUseExistingPlanDetails) || (is_array($canUseExistingPlanDetails) && empty($canUseExistingPlanDetails))) {
            unset($this->CanUseExistingPlanDetails);
        } else {
            $this->CanUseExistingPlanDetails = $canUseExistingPlanDetails;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get DirectDebitMandateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDirectDebitMandateId()
    {
        return isset($this->DirectDebitMandateId) ? $this->DirectDebitMandateId : null;
    }
    /**
     * Set DirectDebitMandateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $directDebitMandateId
     * @return \patest\StructType\BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request
     */
    public function setDirectDebitMandateId($directDebitMandateId = null)
    {
        // validation for constraint: string
        if (!is_null($directDebitMandateId) && !is_string($directDebitMandateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directDebitMandateId, true), gettype($directDebitMandateId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($directDebitMandateId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $directDebitMandateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($directDebitMandateId, true)), __LINE__);
        }
        if (is_null($directDebitMandateId) || (is_array($directDebitMandateId) && empty($directDebitMandateId))) {
            unset($this->DirectDebitMandateId);
        } else {
            $this->DirectDebitMandateId = $directDebitMandateId;
        }
        return $this;
    }
    /**
     * Get EnrolledSubscriptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizAction_Crm_AutoRenewalClientEnrollment|null
     */
    public function getEnrolledSubscriptions()
    {
        return isset($this->EnrolledSubscriptions) ? $this->EnrolledSubscriptions : null;
    }
    /**
     * Set EnrolledSubscriptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizAction_Crm_AutoRenewalClientEnrollment $enrolledSubscriptions
     * @return \patest\StructType\BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request
     */
    public function setEnrolledSubscriptions(\patest\StructType\RecordSetOfBizAction_Crm_AutoRenewalClientEnrollment $enrolledSubscriptions = null)
    {
        if (is_null($enrolledSubscriptions) || (is_array($enrolledSubscriptions) && empty($enrolledSubscriptions))) {
            unset($this->EnrolledSubscriptions);
        } else {
            $this->EnrolledSubscriptions = $enrolledSubscriptions;
        }
        return $this;
    }
    /**
     * Get IsEnroll value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsEnroll()
    {
        return isset($this->IsEnroll) ? $this->IsEnroll : null;
    }
    /**
     * Set IsEnroll value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isEnroll
     * @return \patest\StructType\BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request
     */
    public function setIsEnroll($isEnroll = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEnroll) && !is_bool($isEnroll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEnroll, true), gettype($isEnroll)), __LINE__);
        }
        if (is_null($isEnroll) || (is_array($isEnroll) && empty($isEnroll))) {
            unset($this->IsEnroll);
        } else {
            $this->IsEnroll = $isEnroll;
        }
        return $this;
    }
    /**
     * Get IsEnrollWithoutPaymentDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsEnrollWithoutPaymentDetails()
    {
        return isset($this->IsEnrollWithoutPaymentDetails) ? $this->IsEnrollWithoutPaymentDetails : null;
    }
    /**
     * Set IsEnrollWithoutPaymentDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isEnrollWithoutPaymentDetails
     * @return \patest\StructType\BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request
     */
    public function setIsEnrollWithoutPaymentDetails($isEnrollWithoutPaymentDetails = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEnrollWithoutPaymentDetails) && !is_bool($isEnrollWithoutPaymentDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEnrollWithoutPaymentDetails, true), gettype($isEnrollWithoutPaymentDetails)), __LINE__);
        }
        if (is_null($isEnrollWithoutPaymentDetails) || (is_array($isEnrollWithoutPaymentDetails) && empty($isEnrollWithoutPaymentDetails))) {
            unset($this->IsEnrollWithoutPaymentDetails);
        } else {
            $this->IsEnrollWithoutPaymentDetails = $isEnrollWithoutPaymentDetails;
        }
        return $this;
    }
    /**
     * Get IsOnlyNewEnrollments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsOnlyNewEnrollments()
    {
        return isset($this->IsOnlyNewEnrollments) ? $this->IsOnlyNewEnrollments : null;
    }
    /**
     * Set IsOnlyNewEnrollments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isOnlyNewEnrollments
     * @return \patest\StructType\BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request
     */
    public function setIsOnlyNewEnrollments($isOnlyNewEnrollments = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOnlyNewEnrollments) && !is_bool($isOnlyNewEnrollments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOnlyNewEnrollments, true), gettype($isOnlyNewEnrollments)), __LINE__);
        }
        if (is_null($isOnlyNewEnrollments) || (is_array($isOnlyNewEnrollments) && empty($isOnlyNewEnrollments))) {
            unset($this->IsOnlyNewEnrollments);
        } else {
            $this->IsOnlyNewEnrollments = $isOnlyNewEnrollments;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodType()
    {
        return isset($this->PaymentMethodType) ? $this->PaymentMethodType : null;
    }
    /**
     * Set PaymentMethodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentMethodType::valueIsValid()
     * @uses \patest\EnumType\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentMethodType
     * @return \patest\StructType\BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request
     */
    public function setPaymentMethodType($paymentMethodType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentMethodType::valueIsValid($paymentMethodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentMethodType', is_array($paymentMethodType) ? implode(', ', $paymentMethodType) : var_export($paymentMethodType, true), implode(', ', \patest\EnumType\PaymentMethodType::getValidValues())), __LINE__);
        }
        if (is_null($paymentMethodType) || (is_array($paymentMethodType) && empty($paymentMethodType))) {
            unset($this->PaymentMethodType);
        } else {
            $this->PaymentMethodType = $paymentMethodType;
        }
        return $this;
    }
    /**
     * Get PaymentPlanPaymentDayOfMonth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPaymentPlanPaymentDayOfMonth()
    {
        return isset($this->PaymentPlanPaymentDayOfMonth) ? $this->PaymentPlanPaymentDayOfMonth : null;
    }
    /**
     * Set PaymentPlanPaymentDayOfMonth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $paymentPlanPaymentDayOfMonth
     * @return \patest\StructType\BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request
     */
    public function setPaymentPlanPaymentDayOfMonth($paymentPlanPaymentDayOfMonth = null)
    {
        // validation for constraint: int
        if (!is_null($paymentPlanPaymentDayOfMonth) && !(is_int($paymentPlanPaymentDayOfMonth) || ctype_digit($paymentPlanPaymentDayOfMonth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentPlanPaymentDayOfMonth, true), gettype($paymentPlanPaymentDayOfMonth)), __LINE__);
        }
        if (is_null($paymentPlanPaymentDayOfMonth) || (is_array($paymentPlanPaymentDayOfMonth) && empty($paymentPlanPaymentDayOfMonth))) {
            unset($this->PaymentPlanPaymentDayOfMonth);
        } else {
            $this->PaymentPlanPaymentDayOfMonth = $paymentPlanPaymentDayOfMonth;
        }
        return $this;
    }
    /**
     * Get PaymentPlanPaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentPlanPaymentMethodId()
    {
        return isset($this->PaymentPlanPaymentMethodId) ? $this->PaymentPlanPaymentMethodId : null;
    }
    /**
     * Set PaymentPlanPaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentPlanPaymentMethodId
     * @return \patest\StructType\BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request
     */
    public function setPaymentPlanPaymentMethodId($paymentPlanPaymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentPlanPaymentMethodId) && !is_string($paymentPlanPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentPlanPaymentMethodId, true), gettype($paymentPlanPaymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentPlanPaymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentPlanPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentPlanPaymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentPlanPaymentMethodId) || (is_array($paymentPlanPaymentMethodId) && empty($paymentPlanPaymentMethodId))) {
            unset($this->PaymentPlanPaymentMethodId);
        } else {
            $this->PaymentPlanPaymentMethodId = $paymentPlanPaymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentPlanPaymentMethodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentPlanPaymentMethodType()
    {
        return isset($this->PaymentPlanPaymentMethodType) ? $this->PaymentPlanPaymentMethodType : null;
    }
    /**
     * Set PaymentPlanPaymentMethodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentMethodType::valueIsValid()
     * @uses \patest\EnumType\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentPlanPaymentMethodType
     * @return \patest\StructType\BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request
     */
    public function setPaymentPlanPaymentMethodType($paymentPlanPaymentMethodType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentMethodType::valueIsValid($paymentPlanPaymentMethodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentMethodType', is_array($paymentPlanPaymentMethodType) ? implode(', ', $paymentPlanPaymentMethodType) : var_export($paymentPlanPaymentMethodType, true), implode(', ', \patest\EnumType\PaymentMethodType::getValidValues())), __LINE__);
        }
        if (is_null($paymentPlanPaymentMethodType) || (is_array($paymentPlanPaymentMethodType) && empty($paymentPlanPaymentMethodType))) {
            unset($this->PaymentPlanPaymentMethodType);
        } else {
            $this->PaymentPlanPaymentMethodType = $paymentPlanPaymentMethodType;
        }
        return $this;
    }
    /**
     * Get PaymentPlanPaymentTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentPlanPaymentTokenId()
    {
        return isset($this->PaymentPlanPaymentTokenId) ? $this->PaymentPlanPaymentTokenId : null;
    }
    /**
     * Set PaymentPlanPaymentTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentPlanPaymentTokenId
     * @return \patest\StructType\BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request
     */
    public function setPaymentPlanPaymentTokenId($paymentPlanPaymentTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentPlanPaymentTokenId) && !is_string($paymentPlanPaymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentPlanPaymentTokenId, true), gettype($paymentPlanPaymentTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentPlanPaymentTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentPlanPaymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentPlanPaymentTokenId, true)), __LINE__);
        }
        if (is_null($paymentPlanPaymentTokenId) || (is_array($paymentPlanPaymentTokenId) && empty($paymentPlanPaymentTokenId))) {
            unset($this->PaymentPlanPaymentTokenId);
        } else {
            $this->PaymentPlanPaymentTokenId = $paymentPlanPaymentTokenId;
        }
        return $this;
    }
    /**
     * Get PaymentTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentTokenId()
    {
        return isset($this->PaymentTokenId) ? $this->PaymentTokenId : null;
    }
    /**
     * Set PaymentTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentTokenId
     * @return \patest\StructType\BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request
     */
    public function setPaymentTokenId($paymentTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTokenId) && !is_string($paymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTokenId, true), gettype($paymentTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentTokenId, true)), __LINE__);
        }
        if (is_null($paymentTokenId) || (is_array($paymentTokenId) && empty($paymentTokenId))) {
            unset($this->PaymentTokenId);
        } else {
            $this->PaymentTokenId = $paymentTokenId;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get SeriesIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesIds()
    {
        return isset($this->SeriesIds) ? $this->SeriesIds : null;
    }
    /**
     * Set SeriesIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesIds
     * @return \patest\StructType\BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request
     */
    public function setSeriesIds($seriesIds = null)
    {
        // validation for constraint: string
        if (!is_null($seriesIds) && !is_string($seriesIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesIds, true), gettype($seriesIds)), __LINE__);
        }
        if (is_null($seriesIds) || (is_array($seriesIds) && empty($seriesIds))) {
            unset($this->SeriesIds);
        } else {
            $this->SeriesIds = $seriesIds;
        }
        return $this;
    }
    /**
     * Get SeriesName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSeriesName()
    {
        return isset($this->SeriesName) ? $this->SeriesName : null;
    }
    /**
     * Set SeriesName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $seriesName
     * @return \patest\StructType\BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request
     */
    public function setSeriesName(\patest\StructType\GlobalString $seriesName = null)
    {
        if (is_null($seriesName) || (is_array($seriesName) && empty($seriesName))) {
            unset($this->SeriesName);
        } else {
            $this->SeriesName = $seriesName;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstanceIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SubscriptionInstanceIds|null
     */
    public function getSubscriptionInstanceIds()
    {
        return isset($this->SubscriptionInstanceIds) ? $this->SubscriptionInstanceIds : null;
    }
    /**
     * Set SubscriptionInstanceIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SubscriptionInstanceIds $subscriptionInstanceIds
     * @return \patest\StructType\BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request
     */
    public function setSubscriptionInstanceIds(\patest\StructType\SubscriptionInstanceIds $subscriptionInstanceIds = null)
    {
        if (is_null($subscriptionInstanceIds) || (is_array($subscriptionInstanceIds) && empty($subscriptionInstanceIds))) {
            unset($this->SubscriptionInstanceIds);
        } else {
            $this->SubscriptionInstanceIds = $subscriptionInstanceIds;
        }
        return $this;
    }
    /**
     * Get UseExistingPlanDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseExistingPlanDetails()
    {
        return isset($this->UseExistingPlanDetails) ? $this->UseExistingPlanDetails : null;
    }
    /**
     * Set UseExistingPlanDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useExistingPlanDetails
     * @return \patest\StructType\BizAction_Crm_SubscriptionAutoRenewalEnrollments_Request
     */
    public function setUseExistingPlanDetails($useExistingPlanDetails = null)
    {
        // validation for constraint: boolean
        if (!is_null($useExistingPlanDetails) && !is_bool($useExistingPlanDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useExistingPlanDetails, true), gettype($useExistingPlanDetails)), __LINE__);
        }
        if (is_null($useExistingPlanDetails) || (is_array($useExistingPlanDetails) && empty($useExistingPlanDetails))) {
            unset($this->UseExistingPlanDetails);
        } else {
            $this->UseExistingPlanDetails = $useExistingPlanDetails;
        }
        return $this;
    }
}
