<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Crm.ReassignGoalsBizAction.Request StructType
 * @subpackage Structs
 */
class BizAction_Crm_ReassignGoalsBizAction_Request extends AnyEntity
{
    /**
     * The Goals
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_SelectedSalesRepGoal
     */
    public $Goals;
    /**
     * The NewSalesRepId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewSalesRepId;
    /**
     * The SalesRepCategory
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalesRepCategory;
    /**
     * The SalesRepId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalesRepId;
    /**
     * The SalesRepType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalesRepType;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * Constructor method for BizAction.Crm.ReassignGoalsBizAction.Request
     * @uses BizAction_Crm_ReassignGoalsBizAction_Request::setGoals()
     * @uses BizAction_Crm_ReassignGoalsBizAction_Request::setNewSalesRepId()
     * @uses BizAction_Crm_ReassignGoalsBizAction_Request::setSalesRepCategory()
     * @uses BizAction_Crm_ReassignGoalsBizAction_Request::setSalesRepId()
     * @uses BizAction_Crm_ReassignGoalsBizAction_Request::setSalesRepType()
     * @uses BizAction_Crm_ReassignGoalsBizAction_Request::setType()
     * @param \patest\StructType\RecordSetOfCrm_SelectedSalesRepGoal $goals
     * @param string $newSalesRepId
     * @param string $salesRepCategory
     * @param string $salesRepId
     * @param string $salesRepType
     * @param string $type
     */
    public function __construct(\patest\StructType\RecordSetOfCrm_SelectedSalesRepGoal $goals = null, $newSalesRepId = null, $salesRepCategory = null, $salesRepId = null, $salesRepType = null, $type = null)
    {
        $this
            ->setGoals($goals)
            ->setNewSalesRepId($newSalesRepId)
            ->setSalesRepCategory($salesRepCategory)
            ->setSalesRepId($salesRepId)
            ->setSalesRepType($salesRepType)
            ->setType($type);
    }
    /**
     * Get Goals value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_SelectedSalesRepGoal|null
     */
    public function getGoals()
    {
        return isset($this->Goals) ? $this->Goals : null;
    }
    /**
     * Set Goals value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_SelectedSalesRepGoal $goals
     * @return \patest\StructType\BizAction_Crm_ReassignGoalsBizAction_Request
     */
    public function setGoals(\patest\StructType\RecordSetOfCrm_SelectedSalesRepGoal $goals = null)
    {
        if (is_null($goals) || (is_array($goals) && empty($goals))) {
            unset($this->Goals);
        } else {
            $this->Goals = $goals;
        }
        return $this;
    }
    /**
     * Get NewSalesRepId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewSalesRepId()
    {
        return isset($this->NewSalesRepId) ? $this->NewSalesRepId : null;
    }
    /**
     * Set NewSalesRepId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newSalesRepId
     * @return \patest\StructType\BizAction_Crm_ReassignGoalsBizAction_Request
     */
    public function setNewSalesRepId($newSalesRepId = null)
    {
        // validation for constraint: string
        if (!is_null($newSalesRepId) && !is_string($newSalesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newSalesRepId, true), gettype($newSalesRepId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newSalesRepId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newSalesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newSalesRepId, true)), __LINE__);
        }
        if (is_null($newSalesRepId) || (is_array($newSalesRepId) && empty($newSalesRepId))) {
            unset($this->NewSalesRepId);
        } else {
            $this->NewSalesRepId = $newSalesRepId;
        }
        return $this;
    }
    /**
     * Get SalesRepCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepCategory()
    {
        return isset($this->SalesRepCategory) ? $this->SalesRepCategory : null;
    }
    /**
     * Set SalesRepCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesRepCategory
     * @return \patest\StructType\BizAction_Crm_ReassignGoalsBizAction_Request
     */
    public function setSalesRepCategory($salesRepCategory = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepCategory) && !is_string($salesRepCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepCategory, true), gettype($salesRepCategory)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salesRepCategory) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salesRepCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salesRepCategory, true)), __LINE__);
        }
        if (is_null($salesRepCategory) || (is_array($salesRepCategory) && empty($salesRepCategory))) {
            unset($this->SalesRepCategory);
        } else {
            $this->SalesRepCategory = $salesRepCategory;
        }
        return $this;
    }
    /**
     * Get SalesRepId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepId()
    {
        return isset($this->SalesRepId) ? $this->SalesRepId : null;
    }
    /**
     * Set SalesRepId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesRepId
     * @return \patest\StructType\BizAction_Crm_ReassignGoalsBizAction_Request
     */
    public function setSalesRepId($salesRepId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepId) && !is_string($salesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepId, true), gettype($salesRepId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salesRepId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salesRepId, true)), __LINE__);
        }
        if (is_null($salesRepId) || (is_array($salesRepId) && empty($salesRepId))) {
            unset($this->SalesRepId);
        } else {
            $this->SalesRepId = $salesRepId;
        }
        return $this;
    }
    /**
     * Get SalesRepType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepType()
    {
        return isset($this->SalesRepType) ? $this->SalesRepType : null;
    }
    /**
     * Set SalesRepType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SalesRepType::valueIsValid()
     * @uses \patest\EnumType\SalesRepType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $salesRepType
     * @return \patest\StructType\BizAction_Crm_ReassignGoalsBizAction_Request
     */
    public function setSalesRepType($salesRepType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SalesRepType::valueIsValid($salesRepType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SalesRepType', is_array($salesRepType) ? implode(', ', $salesRepType) : var_export($salesRepType, true), implode(', ', \patest\EnumType\SalesRepType::getValidValues())), __LINE__);
        }
        if (is_null($salesRepType) || (is_array($salesRepType) && empty($salesRepType))) {
            unset($this->SalesRepType);
        } else {
            $this->SalesRepType = $salesRepType;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SalesRepType::valueIsValid()
     * @uses \patest\EnumType\SalesRepType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \patest\StructType\BizAction_Crm_ReassignGoalsBizAction_Request
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SalesRepType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SalesRepType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \patest\EnumType\SalesRepType::getValidValues())), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
}
