<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.BizResource.SendDocuments.DocumentItem
 * StructType
 * @subpackage Structs
 */
class BizAction_BizResource_SendDocuments_DocumentItem extends AnyEntity
{
    /**
     * The ActivityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ActivityId;
    /**
     * The ActivityScheduleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ActivityScheduleId;
    /**
     * The DocumentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DocumentId;
    /**
     * The IsQuotation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsQuotation;
    /**
     * The IsSelected
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSelected;
    /**
     * The OrderId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrderId;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Title;
    /**
     * The VisitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VisitId;
    /**
     * Constructor method for BizAction.BizResource.SendDocuments.DocumentItem
     * @uses BizAction_BizResource_SendDocuments_DocumentItem::setActivityId()
     * @uses BizAction_BizResource_SendDocuments_DocumentItem::setActivityScheduleId()
     * @uses BizAction_BizResource_SendDocuments_DocumentItem::setDocumentId()
     * @uses BizAction_BizResource_SendDocuments_DocumentItem::setIsQuotation()
     * @uses BizAction_BizResource_SendDocuments_DocumentItem::setIsSelected()
     * @uses BizAction_BizResource_SendDocuments_DocumentItem::setOrderId()
     * @uses BizAction_BizResource_SendDocuments_DocumentItem::setTitle()
     * @uses BizAction_BizResource_SendDocuments_DocumentItem::setVisitId()
     * @param string $activityId
     * @param string $activityScheduleId
     * @param string $documentId
     * @param bool $isQuotation
     * @param bool $isSelected
     * @param string $orderId
     * @param string $title
     * @param string $visitId
     */
    public function __construct($activityId = null, $activityScheduleId = null, $documentId = null, $isQuotation = null, $isSelected = null, $orderId = null, $title = null, $visitId = null)
    {
        $this
            ->setActivityId($activityId)
            ->setActivityScheduleId($activityScheduleId)
            ->setDocumentId($documentId)
            ->setIsQuotation($isQuotation)
            ->setIsSelected($isSelected)
            ->setOrderId($orderId)
            ->setTitle($title)
            ->setVisitId($visitId);
    }
    /**
     * Get ActivityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivityId()
    {
        return isset($this->ActivityId) ? $this->ActivityId : null;
    }
    /**
     * Set ActivityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activityId
     * @return \patest\StructType\BizAction_BizResource_SendDocuments_DocumentItem
     */
    public function setActivityId($activityId = null)
    {
        // validation for constraint: string
        if (!is_null($activityId) && !is_string($activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityId, true), gettype($activityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($activityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($activityId, true)), __LINE__);
        }
        if (is_null($activityId) || (is_array($activityId) && empty($activityId))) {
            unset($this->ActivityId);
        } else {
            $this->ActivityId = $activityId;
        }
        return $this;
    }
    /**
     * Get ActivityScheduleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivityScheduleId()
    {
        return isset($this->ActivityScheduleId) ? $this->ActivityScheduleId : null;
    }
    /**
     * Set ActivityScheduleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activityScheduleId
     * @return \patest\StructType\BizAction_BizResource_SendDocuments_DocumentItem
     */
    public function setActivityScheduleId($activityScheduleId = null)
    {
        // validation for constraint: string
        if (!is_null($activityScheduleId) && !is_string($activityScheduleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityScheduleId, true), gettype($activityScheduleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($activityScheduleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $activityScheduleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($activityScheduleId, true)), __LINE__);
        }
        if (is_null($activityScheduleId) || (is_array($activityScheduleId) && empty($activityScheduleId))) {
            unset($this->ActivityScheduleId);
        } else {
            $this->ActivityScheduleId = $activityScheduleId;
        }
        return $this;
    }
    /**
     * Get DocumentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentId()
    {
        return isset($this->DocumentId) ? $this->DocumentId : null;
    }
    /**
     * Set DocumentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentId
     * @return \patest\StructType\BizAction_BizResource_SendDocuments_DocumentItem
     */
    public function setDocumentId($documentId = null)
    {
        // validation for constraint: string
        if (!is_null($documentId) && !is_string($documentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentId, true), gettype($documentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($documentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $documentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($documentId, true)), __LINE__);
        }
        if (is_null($documentId) || (is_array($documentId) && empty($documentId))) {
            unset($this->DocumentId);
        } else {
            $this->DocumentId = $documentId;
        }
        return $this;
    }
    /**
     * Get IsQuotation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsQuotation()
    {
        return isset($this->IsQuotation) ? $this->IsQuotation : null;
    }
    /**
     * Set IsQuotation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isQuotation
     * @return \patest\StructType\BizAction_BizResource_SendDocuments_DocumentItem
     */
    public function setIsQuotation($isQuotation = null)
    {
        // validation for constraint: boolean
        if (!is_null($isQuotation) && !is_bool($isQuotation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isQuotation, true), gettype($isQuotation)), __LINE__);
        }
        if (is_null($isQuotation) || (is_array($isQuotation) && empty($isQuotation))) {
            unset($this->IsQuotation);
        } else {
            $this->IsQuotation = $isQuotation;
        }
        return $this;
    }
    /**
     * Get IsSelected value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSelected()
    {
        return isset($this->IsSelected) ? $this->IsSelected : null;
    }
    /**
     * Set IsSelected value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSelected
     * @return \patest\StructType\BizAction_BizResource_SendDocuments_DocumentItem
     */
    public function setIsSelected($isSelected = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSelected) && !is_bool($isSelected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSelected, true), gettype($isSelected)), __LINE__);
        }
        if (is_null($isSelected) || (is_array($isSelected) && empty($isSelected))) {
            unset($this->IsSelected);
        } else {
            $this->IsSelected = $isSelected;
        }
        return $this;
    }
    /**
     * Get OrderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderId()
    {
        return isset($this->OrderId) ? $this->OrderId : null;
    }
    /**
     * Set OrderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderId
     * @return \patest\StructType\BizAction_BizResource_SendDocuments_DocumentItem
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orderId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orderId, true)), __LINE__);
        }
        if (is_null($orderId) || (is_array($orderId) && empty($orderId))) {
            unset($this->OrderId);
        } else {
            $this->OrderId = $orderId;
        }
        return $this;
    }
    /**
     * Get Title value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitle()
    {
        return isset($this->Title) ? $this->Title : null;
    }
    /**
     * Set Title value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $title
     * @return \patest\StructType\BizAction_BizResource_SendDocuments_DocumentItem
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        if (is_null($title) || (is_array($title) && empty($title))) {
            unset($this->Title);
        } else {
            $this->Title = $title;
        }
        return $this;
    }
    /**
     * Get VisitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitId()
    {
        return isset($this->VisitId) ? $this->VisitId : null;
    }
    /**
     * Set VisitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitId
     * @return \patest\StructType\BizAction_BizResource_SendDocuments_DocumentItem
     */
    public function setVisitId($visitId = null)
    {
        // validation for constraint: string
        if (!is_null($visitId) && !is_string($visitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitId, true), gettype($visitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($visitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $visitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($visitId, true)), __LINE__);
        }
        if (is_null($visitId) || (is_array($visitId) && empty($visitId))) {
            unset($this->VisitId);
        } else {
            $this->VisitId = $visitId;
        }
        return $this;
    }
}
