<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.BizResource.CancelOrder.Request StructType
 * @subpackage Structs
 */
class BizAction_BizResource_CancelOrder_Request extends AnyEntity
{
    /**
     * The BillingItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizResource_BillingItem
     */
    public $BillingItems;
    /**
     * The GroupByVisit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $GroupByVisit;
    /**
     * The OrderId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrderId;
    /**
     * The OrderVisitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrderVisitId;
    /**
     * The PayerAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PayerAccountId;
    /**
     * The UIBillingItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizResource_UIBillingItem
     */
    public $UIBillingItems;
    /**
     * Constructor method for BizAction.BizResource.CancelOrder.Request
     * @uses BizAction_BizResource_CancelOrder_Request::setBillingItems()
     * @uses BizAction_BizResource_CancelOrder_Request::setGroupByVisit()
     * @uses BizAction_BizResource_CancelOrder_Request::setOrderId()
     * @uses BizAction_BizResource_CancelOrder_Request::setOrderVisitId()
     * @uses BizAction_BizResource_CancelOrder_Request::setPayerAccountId()
     * @uses BizAction_BizResource_CancelOrder_Request::setUIBillingItems()
     * @param \patest\StructType\RecordSetOfBizResource_BillingItem $billingItems
     * @param bool $groupByVisit
     * @param string $orderId
     * @param string $orderVisitId
     * @param string $payerAccountId
     * @param \patest\StructType\RecordSetOfBizResource_UIBillingItem $uIBillingItems
     */
    public function __construct(\patest\StructType\RecordSetOfBizResource_BillingItem $billingItems = null, $groupByVisit = null, $orderId = null, $orderVisitId = null, $payerAccountId = null, \patest\StructType\RecordSetOfBizResource_UIBillingItem $uIBillingItems = null)
    {
        $this
            ->setBillingItems($billingItems)
            ->setGroupByVisit($groupByVisit)
            ->setOrderId($orderId)
            ->setOrderVisitId($orderVisitId)
            ->setPayerAccountId($payerAccountId)
            ->setUIBillingItems($uIBillingItems);
    }
    /**
     * Get BillingItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizResource_BillingItem|null
     */
    public function getBillingItems()
    {
        return isset($this->BillingItems) ? $this->BillingItems : null;
    }
    /**
     * Set BillingItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizResource_BillingItem $billingItems
     * @return \patest\StructType\BizAction_BizResource_CancelOrder_Request
     */
    public function setBillingItems(\patest\StructType\RecordSetOfBizResource_BillingItem $billingItems = null)
    {
        if (is_null($billingItems) || (is_array($billingItems) && empty($billingItems))) {
            unset($this->BillingItems);
        } else {
            $this->BillingItems = $billingItems;
        }
        return $this;
    }
    /**
     * Get GroupByVisit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getGroupByVisit()
    {
        return isset($this->GroupByVisit) ? $this->GroupByVisit : null;
    }
    /**
     * Set GroupByVisit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $groupByVisit
     * @return \patest\StructType\BizAction_BizResource_CancelOrder_Request
     */
    public function setGroupByVisit($groupByVisit = null)
    {
        // validation for constraint: boolean
        if (!is_null($groupByVisit) && !is_bool($groupByVisit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($groupByVisit, true), gettype($groupByVisit)), __LINE__);
        }
        if (is_null($groupByVisit) || (is_array($groupByVisit) && empty($groupByVisit))) {
            unset($this->GroupByVisit);
        } else {
            $this->GroupByVisit = $groupByVisit;
        }
        return $this;
    }
    /**
     * Get OrderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderId()
    {
        return isset($this->OrderId) ? $this->OrderId : null;
    }
    /**
     * Set OrderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderId
     * @return \patest\StructType\BizAction_BizResource_CancelOrder_Request
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orderId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orderId, true)), __LINE__);
        }
        if (is_null($orderId) || (is_array($orderId) && empty($orderId))) {
            unset($this->OrderId);
        } else {
            $this->OrderId = $orderId;
        }
        return $this;
    }
    /**
     * Get OrderVisitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderVisitId()
    {
        return isset($this->OrderVisitId) ? $this->OrderVisitId : null;
    }
    /**
     * Set OrderVisitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderVisitId
     * @return \patest\StructType\BizAction_BizResource_CancelOrder_Request
     */
    public function setOrderVisitId($orderVisitId = null)
    {
        // validation for constraint: string
        if (!is_null($orderVisitId) && !is_string($orderVisitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderVisitId, true), gettype($orderVisitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orderVisitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orderVisitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orderVisitId, true)), __LINE__);
        }
        if (is_null($orderVisitId) || (is_array($orderVisitId) && empty($orderVisitId))) {
            unset($this->OrderVisitId);
        } else {
            $this->OrderVisitId = $orderVisitId;
        }
        return $this;
    }
    /**
     * Get PayerAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayerAccountId()
    {
        return isset($this->PayerAccountId) ? $this->PayerAccountId : null;
    }
    /**
     * Set PayerAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payerAccountId
     * @return \patest\StructType\BizAction_BizResource_CancelOrder_Request
     */
    public function setPayerAccountId($payerAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($payerAccountId) && !is_string($payerAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerAccountId, true), gettype($payerAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($payerAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $payerAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($payerAccountId, true)), __LINE__);
        }
        if (is_null($payerAccountId) || (is_array($payerAccountId) && empty($payerAccountId))) {
            unset($this->PayerAccountId);
        } else {
            $this->PayerAccountId = $payerAccountId;
        }
        return $this;
    }
    /**
     * Get UIBillingItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizResource_UIBillingItem|null
     */
    public function getUIBillingItems()
    {
        return isset($this->UIBillingItems) ? $this->UIBillingItems : null;
    }
    /**
     * Set UIBillingItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizResource_UIBillingItem $uIBillingItems
     * @return \patest\StructType\BizAction_BizResource_CancelOrder_Request
     */
    public function setUIBillingItems(\patest\StructType\RecordSetOfBizResource_UIBillingItem $uIBillingItems = null)
    {
        if (is_null($uIBillingItems) || (is_array($uIBillingItems) && empty($uIBillingItems))) {
            unset($this->UIBillingItems);
        } else {
            $this->UIBillingItems = $uIBillingItems;
        }
        return $this;
    }
}
