<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Bacade.BuidProductEntryBatchFromFileData.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Bacade_BuidProductEntryBatchFromFileData_Request extends AnyEntity
{
    /**
     * The UploadedDataId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UploadedDataId;
    /**
     * Constructor method for
     * BizAction.Bacade.BuidProductEntryBatchFromFileData.Request
     * @uses BizAction_Bacade_BuidProductEntryBatchFromFileData_Request::setUploadedDataId()
     * @param string $uploadedDataId
     */
    public function __construct($uploadedDataId = null)
    {
        $this
            ->setUploadedDataId($uploadedDataId);
    }
    /**
     * Get UploadedDataId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUploadedDataId()
    {
        return isset($this->UploadedDataId) ? $this->UploadedDataId : null;
    }
    /**
     * Set UploadedDataId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uploadedDataId
     * @return \patest\StructType\BizAction_Bacade_BuidProductEntryBatchFromFileData_Request
     */
    public function setUploadedDataId($uploadedDataId = null)
    {
        // validation for constraint: string
        if (!is_null($uploadedDataId) && !is_string($uploadedDataId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uploadedDataId, true), gettype($uploadedDataId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($uploadedDataId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $uploadedDataId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($uploadedDataId, true)), __LINE__);
        }
        if (is_null($uploadedDataId) || (is_array($uploadedDataId) && empty($uploadedDataId))) {
            unset($this->UploadedDataId);
        } else {
            $this->UploadedDataId = $uploadedDataId;
        }
        return $this;
    }
}
