<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.AccessControl.MigrateToShowtime.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_AccessControl_MigrateToShowtime_Request extends AnyEntity
{
    /**
     * The AccessControlSystemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlSystemId;
    /**
     * The ShowtimeAcSystemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowtimeAcSystemId;
    /**
     * The SyncActiveBarcodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SyncActiveBarcodes;
    /**
     * The SyncActiveBarcodesStatus
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - type: tns:ShowtimeMigrationStatus
     * @var string
     */
    public $SyncActiveBarcodesStatus;
    /**
     * The SyncEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SyncEvents;
    /**
     * The SyncEventsStatus
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - type: tns:ShowtimeMigrationStatus
     * @var string
     */
    public $SyncEventsStatus;
    /**
     * The SyncVenue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SyncVenue;
    /**
     * The SyncVenueStatus
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - type: tns:ShowtimeMigrationStatus
     * @var string
     */
    public $SyncVenueStatus;
    /**
     * Constructor method for BizAction.AccessControl.MigrateToShowtime.Request
     * @uses BizAction_AccessControl_MigrateToShowtime_Request::setAccessControlSystemId()
     * @uses BizAction_AccessControl_MigrateToShowtime_Request::setShowtimeAcSystemId()
     * @uses BizAction_AccessControl_MigrateToShowtime_Request::setSyncActiveBarcodes()
     * @uses BizAction_AccessControl_MigrateToShowtime_Request::setSyncActiveBarcodesStatus()
     * @uses BizAction_AccessControl_MigrateToShowtime_Request::setSyncEvents()
     * @uses BizAction_AccessControl_MigrateToShowtime_Request::setSyncEventsStatus()
     * @uses BizAction_AccessControl_MigrateToShowtime_Request::setSyncVenue()
     * @uses BizAction_AccessControl_MigrateToShowtime_Request::setSyncVenueStatus()
     * @param string $accessControlSystemId
     * @param string $showtimeAcSystemId
     * @param bool $syncActiveBarcodes
     * @param string $syncActiveBarcodesStatus
     * @param bool $syncEvents
     * @param string $syncEventsStatus
     * @param bool $syncVenue
     * @param string $syncVenueStatus
     */
    public function __construct($accessControlSystemId = null, $showtimeAcSystemId = null, $syncActiveBarcodes = null, $syncActiveBarcodesStatus = null, $syncEvents = null, $syncEventsStatus = null, $syncVenue = null, $syncVenueStatus = null)
    {
        $this
            ->setAccessControlSystemId($accessControlSystemId)
            ->setShowtimeAcSystemId($showtimeAcSystemId)
            ->setSyncActiveBarcodes($syncActiveBarcodes)
            ->setSyncActiveBarcodesStatus($syncActiveBarcodesStatus)
            ->setSyncEvents($syncEvents)
            ->setSyncEventsStatus($syncEventsStatus)
            ->setSyncVenue($syncVenue)
            ->setSyncVenueStatus($syncVenueStatus);
    }
    /**
     * Get AccessControlSystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemId()
    {
        return isset($this->AccessControlSystemId) ? $this->AccessControlSystemId : null;
    }
    /**
     * Set AccessControlSystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemId
     * @return \patest\StructType\BizAction_AccessControl_MigrateToShowtime_Request
     */
    public function setAccessControlSystemId($accessControlSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemId) && !is_string($accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemId, true), gettype($accessControlSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlSystemId, true)), __LINE__);
        }
        if (is_null($accessControlSystemId) || (is_array($accessControlSystemId) && empty($accessControlSystemId))) {
            unset($this->AccessControlSystemId);
        } else {
            $this->AccessControlSystemId = $accessControlSystemId;
        }
        return $this;
    }
    /**
     * Get ShowtimeAcSystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowtimeAcSystemId()
    {
        return isset($this->ShowtimeAcSystemId) ? $this->ShowtimeAcSystemId : null;
    }
    /**
     * Set ShowtimeAcSystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showtimeAcSystemId
     * @return \patest\StructType\BizAction_AccessControl_MigrateToShowtime_Request
     */
    public function setShowtimeAcSystemId($showtimeAcSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($showtimeAcSystemId) && !is_string($showtimeAcSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showtimeAcSystemId, true), gettype($showtimeAcSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showtimeAcSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showtimeAcSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showtimeAcSystemId, true)), __LINE__);
        }
        if (is_null($showtimeAcSystemId) || (is_array($showtimeAcSystemId) && empty($showtimeAcSystemId))) {
            unset($this->ShowtimeAcSystemId);
        } else {
            $this->ShowtimeAcSystemId = $showtimeAcSystemId;
        }
        return $this;
    }
    /**
     * Get SyncActiveBarcodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSyncActiveBarcodes()
    {
        return isset($this->SyncActiveBarcodes) ? $this->SyncActiveBarcodes : null;
    }
    /**
     * Set SyncActiveBarcodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $syncActiveBarcodes
     * @return \patest\StructType\BizAction_AccessControl_MigrateToShowtime_Request
     */
    public function setSyncActiveBarcodes($syncActiveBarcodes = null)
    {
        // validation for constraint: boolean
        if (!is_null($syncActiveBarcodes) && !is_bool($syncActiveBarcodes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($syncActiveBarcodes, true), gettype($syncActiveBarcodes)), __LINE__);
        }
        if (is_null($syncActiveBarcodes) || (is_array($syncActiveBarcodes) && empty($syncActiveBarcodes))) {
            unset($this->SyncActiveBarcodes);
        } else {
            $this->SyncActiveBarcodes = $syncActiveBarcodes;
        }
        return $this;
    }
    /**
     * Get SyncActiveBarcodesStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSyncActiveBarcodesStatus()
    {
        return isset($this->SyncActiveBarcodesStatus) ? $this->SyncActiveBarcodesStatus : null;
    }
    /**
     * Set SyncActiveBarcodesStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $syncActiveBarcodesStatus
     * @return \patest\StructType\BizAction_AccessControl_MigrateToShowtime_Request
     */
    public function setSyncActiveBarcodesStatus($syncActiveBarcodesStatus = null)
    {
        // validation for constraint: string
        if (!is_null($syncActiveBarcodesStatus) && !is_string($syncActiveBarcodesStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($syncActiveBarcodesStatus, true), gettype($syncActiveBarcodesStatus)), __LINE__);
        }
        if (is_null($syncActiveBarcodesStatus) || (is_array($syncActiveBarcodesStatus) && empty($syncActiveBarcodesStatus))) {
            unset($this->SyncActiveBarcodesStatus);
        } else {
            $this->SyncActiveBarcodesStatus = $syncActiveBarcodesStatus;
        }
        return $this;
    }
    /**
     * Get SyncEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSyncEvents()
    {
        return isset($this->SyncEvents) ? $this->SyncEvents : null;
    }
    /**
     * Set SyncEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $syncEvents
     * @return \patest\StructType\BizAction_AccessControl_MigrateToShowtime_Request
     */
    public function setSyncEvents($syncEvents = null)
    {
        // validation for constraint: boolean
        if (!is_null($syncEvents) && !is_bool($syncEvents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($syncEvents, true), gettype($syncEvents)), __LINE__);
        }
        if (is_null($syncEvents) || (is_array($syncEvents) && empty($syncEvents))) {
            unset($this->SyncEvents);
        } else {
            $this->SyncEvents = $syncEvents;
        }
        return $this;
    }
    /**
     * Get SyncEventsStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSyncEventsStatus()
    {
        return isset($this->SyncEventsStatus) ? $this->SyncEventsStatus : null;
    }
    /**
     * Set SyncEventsStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $syncEventsStatus
     * @return \patest\StructType\BizAction_AccessControl_MigrateToShowtime_Request
     */
    public function setSyncEventsStatus($syncEventsStatus = null)
    {
        // validation for constraint: string
        if (!is_null($syncEventsStatus) && !is_string($syncEventsStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($syncEventsStatus, true), gettype($syncEventsStatus)), __LINE__);
        }
        if (is_null($syncEventsStatus) || (is_array($syncEventsStatus) && empty($syncEventsStatus))) {
            unset($this->SyncEventsStatus);
        } else {
            $this->SyncEventsStatus = $syncEventsStatus;
        }
        return $this;
    }
    /**
     * Get SyncVenue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSyncVenue()
    {
        return isset($this->SyncVenue) ? $this->SyncVenue : null;
    }
    /**
     * Set SyncVenue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $syncVenue
     * @return \patest\StructType\BizAction_AccessControl_MigrateToShowtime_Request
     */
    public function setSyncVenue($syncVenue = null)
    {
        // validation for constraint: boolean
        if (!is_null($syncVenue) && !is_bool($syncVenue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($syncVenue, true), gettype($syncVenue)), __LINE__);
        }
        if (is_null($syncVenue) || (is_array($syncVenue) && empty($syncVenue))) {
            unset($this->SyncVenue);
        } else {
            $this->SyncVenue = $syncVenue;
        }
        return $this;
    }
    /**
     * Get SyncVenueStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSyncVenueStatus()
    {
        return isset($this->SyncVenueStatus) ? $this->SyncVenueStatus : null;
    }
    /**
     * Set SyncVenueStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $syncVenueStatus
     * @return \patest\StructType\BizAction_AccessControl_MigrateToShowtime_Request
     */
    public function setSyncVenueStatus($syncVenueStatus = null)
    {
        // validation for constraint: string
        if (!is_null($syncVenueStatus) && !is_string($syncVenueStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($syncVenueStatus, true), gettype($syncVenueStatus)), __LINE__);
        }
        if (is_null($syncVenueStatus) || (is_array($syncVenueStatus) && empty($syncVenueStatus))) {
            unset($this->SyncVenueStatus);
        } else {
            $this->SyncVenueStatus = $syncVenueStatus;
        }
        return $this;
    }
}
