<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizActionLogics.QueryBuilder.PrintCustomerLabelsRequest
 * StructType
 * @subpackage Structs
 */
class BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest extends AnyEntity
{
    /**
     * The CalculateQueryResultsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CalculateQueryResultsCount;
    /**
     * The DataRetrieved
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DataRetrieved;
    /**
     * The DataSentToPrint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DataSentToPrint;
    /**
     * The FromPage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FromPage;
    /**
     * The FromRecord
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FromRecord;
    /**
     * The IgnoreCustomersWithoutAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IgnoreCustomersWithoutAddress;
    /**
     * The MessageToShow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MessageToShow;
    /**
     * The OrderBy1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderBy1;
    /**
     * The OrderBy1Desc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OrderBy1Desc;
    /**
     * The OrderBy2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderBy2;
    /**
     * The OrderBy2Desc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OrderBy2Desc;
    /**
     * The OrderBy3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderBy3;
    /**
     * The OrderBy3Desc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OrderBy3Desc;
    /**
     * The PrintTestPage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PrintTestPage;
    /**
     * The PrintUsingCultureId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PrintUsingCultureId;
    /**
     * The QueryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $QueryId;
    /**
     * The QueryName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $QueryName;
    /**
     * The QueryResultsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $QueryResultsCount;
    /**
     * The RequestContext
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RequestContext;
    /**
     * The TargetDocumentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetDocumentId;
    /**
     * The TargetPrinterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetPrinterId;
    /**
     * The ToPage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ToPage;
    /**
     * The ToRecord
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ToRecord;
    /**
     * Constructor method for BizActionLogics.QueryBuilder.PrintCustomerLabelsRequest
     * @uses BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest::setCalculateQueryResultsCount()
     * @uses BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest::setDataRetrieved()
     * @uses BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest::setDataSentToPrint()
     * @uses BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest::setFromPage()
     * @uses BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest::setFromRecord()
     * @uses BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest::setIgnoreCustomersWithoutAddress()
     * @uses BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest::setMessageToShow()
     * @uses BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest::setOrderBy1()
     * @uses BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest::setOrderBy1Desc()
     * @uses BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest::setOrderBy2()
     * @uses BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest::setOrderBy2Desc()
     * @uses BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest::setOrderBy3()
     * @uses BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest::setOrderBy3Desc()
     * @uses BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest::setPrintTestPage()
     * @uses BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest::setPrintUsingCultureId()
     * @uses BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest::setQueryId()
     * @uses BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest::setQueryName()
     * @uses BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest::setQueryResultsCount()
     * @uses BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest::setRequestContext()
     * @uses BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest::setTargetDocumentId()
     * @uses BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest::setTargetPrinterId()
     * @uses BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest::setToPage()
     * @uses BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest::setToRecord()
     * @param bool $calculateQueryResultsCount
     * @param bool $dataRetrieved
     * @param bool $dataSentToPrint
     * @param int $fromPage
     * @param int $fromRecord
     * @param bool $ignoreCustomersWithoutAddress
     * @param string $messageToShow
     * @param string $orderBy1
     * @param bool $orderBy1Desc
     * @param string $orderBy2
     * @param bool $orderBy2Desc
     * @param string $orderBy3
     * @param bool $orderBy3Desc
     * @param bool $printTestPage
     * @param string $printUsingCultureId
     * @param string $queryId
     * @param string $queryName
     * @param string $queryResultsCount
     * @param string $requestContext
     * @param string $targetDocumentId
     * @param string $targetPrinterId
     * @param int $toPage
     * @param int $toRecord
     */
    public function __construct($calculateQueryResultsCount = null, $dataRetrieved = null, $dataSentToPrint = null, $fromPage = null, $fromRecord = null, $ignoreCustomersWithoutAddress = null, $messageToShow = null, $orderBy1 = null, $orderBy1Desc = null, $orderBy2 = null, $orderBy2Desc = null, $orderBy3 = null, $orderBy3Desc = null, $printTestPage = null, $printUsingCultureId = null, $queryId = null, $queryName = null, $queryResultsCount = null, $requestContext = null, $targetDocumentId = null, $targetPrinterId = null, $toPage = null, $toRecord = null)
    {
        $this
            ->setCalculateQueryResultsCount($calculateQueryResultsCount)
            ->setDataRetrieved($dataRetrieved)
            ->setDataSentToPrint($dataSentToPrint)
            ->setFromPage($fromPage)
            ->setFromRecord($fromRecord)
            ->setIgnoreCustomersWithoutAddress($ignoreCustomersWithoutAddress)
            ->setMessageToShow($messageToShow)
            ->setOrderBy1($orderBy1)
            ->setOrderBy1Desc($orderBy1Desc)
            ->setOrderBy2($orderBy2)
            ->setOrderBy2Desc($orderBy2Desc)
            ->setOrderBy3($orderBy3)
            ->setOrderBy3Desc($orderBy3Desc)
            ->setPrintTestPage($printTestPage)
            ->setPrintUsingCultureId($printUsingCultureId)
            ->setQueryId($queryId)
            ->setQueryName($queryName)
            ->setQueryResultsCount($queryResultsCount)
            ->setRequestContext($requestContext)
            ->setTargetDocumentId($targetDocumentId)
            ->setTargetPrinterId($targetPrinterId)
            ->setToPage($toPage)
            ->setToRecord($toRecord);
    }
    /**
     * Get CalculateQueryResultsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCalculateQueryResultsCount()
    {
        return isset($this->CalculateQueryResultsCount) ? $this->CalculateQueryResultsCount : null;
    }
    /**
     * Set CalculateQueryResultsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $calculateQueryResultsCount
     * @return \patest\StructType\BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest
     */
    public function setCalculateQueryResultsCount($calculateQueryResultsCount = null)
    {
        // validation for constraint: boolean
        if (!is_null($calculateQueryResultsCount) && !is_bool($calculateQueryResultsCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($calculateQueryResultsCount, true), gettype($calculateQueryResultsCount)), __LINE__);
        }
        if (is_null($calculateQueryResultsCount) || (is_array($calculateQueryResultsCount) && empty($calculateQueryResultsCount))) {
            unset($this->CalculateQueryResultsCount);
        } else {
            $this->CalculateQueryResultsCount = $calculateQueryResultsCount;
        }
        return $this;
    }
    /**
     * Get DataRetrieved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDataRetrieved()
    {
        return isset($this->DataRetrieved) ? $this->DataRetrieved : null;
    }
    /**
     * Set DataRetrieved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $dataRetrieved
     * @return \patest\StructType\BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest
     */
    public function setDataRetrieved($dataRetrieved = null)
    {
        // validation for constraint: boolean
        if (!is_null($dataRetrieved) && !is_bool($dataRetrieved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dataRetrieved, true), gettype($dataRetrieved)), __LINE__);
        }
        if (is_null($dataRetrieved) || (is_array($dataRetrieved) && empty($dataRetrieved))) {
            unset($this->DataRetrieved);
        } else {
            $this->DataRetrieved = $dataRetrieved;
        }
        return $this;
    }
    /**
     * Get DataSentToPrint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDataSentToPrint()
    {
        return isset($this->DataSentToPrint) ? $this->DataSentToPrint : null;
    }
    /**
     * Set DataSentToPrint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $dataSentToPrint
     * @return \patest\StructType\BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest
     */
    public function setDataSentToPrint($dataSentToPrint = null)
    {
        // validation for constraint: boolean
        if (!is_null($dataSentToPrint) && !is_bool($dataSentToPrint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dataSentToPrint, true), gettype($dataSentToPrint)), __LINE__);
        }
        if (is_null($dataSentToPrint) || (is_array($dataSentToPrint) && empty($dataSentToPrint))) {
            unset($this->DataSentToPrint);
        } else {
            $this->DataSentToPrint = $dataSentToPrint;
        }
        return $this;
    }
    /**
     * Get FromPage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFromPage()
    {
        return isset($this->FromPage) ? $this->FromPage : null;
    }
    /**
     * Set FromPage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $fromPage
     * @return \patest\StructType\BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest
     */
    public function setFromPage($fromPage = null)
    {
        // validation for constraint: int
        if (!is_null($fromPage) && !(is_int($fromPage) || ctype_digit($fromPage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fromPage, true), gettype($fromPage)), __LINE__);
        }
        if (is_null($fromPage) || (is_array($fromPage) && empty($fromPage))) {
            unset($this->FromPage);
        } else {
            $this->FromPage = $fromPage;
        }
        return $this;
    }
    /**
     * Get FromRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFromRecord()
    {
        return isset($this->FromRecord) ? $this->FromRecord : null;
    }
    /**
     * Set FromRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $fromRecord
     * @return \patest\StructType\BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest
     */
    public function setFromRecord($fromRecord = null)
    {
        // validation for constraint: int
        if (!is_null($fromRecord) && !(is_int($fromRecord) || ctype_digit($fromRecord))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fromRecord, true), gettype($fromRecord)), __LINE__);
        }
        if (is_null($fromRecord) || (is_array($fromRecord) && empty($fromRecord))) {
            unset($this->FromRecord);
        } else {
            $this->FromRecord = $fromRecord;
        }
        return $this;
    }
    /**
     * Get IgnoreCustomersWithoutAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIgnoreCustomersWithoutAddress()
    {
        return isset($this->IgnoreCustomersWithoutAddress) ? $this->IgnoreCustomersWithoutAddress : null;
    }
    /**
     * Set IgnoreCustomersWithoutAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $ignoreCustomersWithoutAddress
     * @return \patest\StructType\BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest
     */
    public function setIgnoreCustomersWithoutAddress($ignoreCustomersWithoutAddress = null)
    {
        // validation for constraint: boolean
        if (!is_null($ignoreCustomersWithoutAddress) && !is_bool($ignoreCustomersWithoutAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ignoreCustomersWithoutAddress, true), gettype($ignoreCustomersWithoutAddress)), __LINE__);
        }
        if (is_null($ignoreCustomersWithoutAddress) || (is_array($ignoreCustomersWithoutAddress) && empty($ignoreCustomersWithoutAddress))) {
            unset($this->IgnoreCustomersWithoutAddress);
        } else {
            $this->IgnoreCustomersWithoutAddress = $ignoreCustomersWithoutAddress;
        }
        return $this;
    }
    /**
     * Get MessageToShow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessageToShow()
    {
        return isset($this->MessageToShow) ? $this->MessageToShow : null;
    }
    /**
     * Set MessageToShow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $messageToShow
     * @return \patest\StructType\BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest
     */
    public function setMessageToShow($messageToShow = null)
    {
        // validation for constraint: string
        if (!is_null($messageToShow) && !is_string($messageToShow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageToShow, true), gettype($messageToShow)), __LINE__);
        }
        if (is_null($messageToShow) || (is_array($messageToShow) && empty($messageToShow))) {
            unset($this->MessageToShow);
        } else {
            $this->MessageToShow = $messageToShow;
        }
        return $this;
    }
    /**
     * Get OrderBy1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderBy1()
    {
        return isset($this->OrderBy1) ? $this->OrderBy1 : null;
    }
    /**
     * Set OrderBy1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderBy1
     * @return \patest\StructType\BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest
     */
    public function setOrderBy1($orderBy1 = null)
    {
        // validation for constraint: string
        if (!is_null($orderBy1) && !is_string($orderBy1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderBy1, true), gettype($orderBy1)), __LINE__);
        }
        if (is_null($orderBy1) || (is_array($orderBy1) && empty($orderBy1))) {
            unset($this->OrderBy1);
        } else {
            $this->OrderBy1 = $orderBy1;
        }
        return $this;
    }
    /**
     * Get OrderBy1Desc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOrderBy1Desc()
    {
        return isset($this->OrderBy1Desc) ? $this->OrderBy1Desc : null;
    }
    /**
     * Set OrderBy1Desc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $orderBy1Desc
     * @return \patest\StructType\BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest
     */
    public function setOrderBy1Desc($orderBy1Desc = null)
    {
        // validation for constraint: boolean
        if (!is_null($orderBy1Desc) && !is_bool($orderBy1Desc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($orderBy1Desc, true), gettype($orderBy1Desc)), __LINE__);
        }
        if (is_null($orderBy1Desc) || (is_array($orderBy1Desc) && empty($orderBy1Desc))) {
            unset($this->OrderBy1Desc);
        } else {
            $this->OrderBy1Desc = $orderBy1Desc;
        }
        return $this;
    }
    /**
     * Get OrderBy2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderBy2()
    {
        return isset($this->OrderBy2) ? $this->OrderBy2 : null;
    }
    /**
     * Set OrderBy2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderBy2
     * @return \patest\StructType\BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest
     */
    public function setOrderBy2($orderBy2 = null)
    {
        // validation for constraint: string
        if (!is_null($orderBy2) && !is_string($orderBy2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderBy2, true), gettype($orderBy2)), __LINE__);
        }
        if (is_null($orderBy2) || (is_array($orderBy2) && empty($orderBy2))) {
            unset($this->OrderBy2);
        } else {
            $this->OrderBy2 = $orderBy2;
        }
        return $this;
    }
    /**
     * Get OrderBy2Desc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOrderBy2Desc()
    {
        return isset($this->OrderBy2Desc) ? $this->OrderBy2Desc : null;
    }
    /**
     * Set OrderBy2Desc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $orderBy2Desc
     * @return \patest\StructType\BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest
     */
    public function setOrderBy2Desc($orderBy2Desc = null)
    {
        // validation for constraint: boolean
        if (!is_null($orderBy2Desc) && !is_bool($orderBy2Desc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($orderBy2Desc, true), gettype($orderBy2Desc)), __LINE__);
        }
        if (is_null($orderBy2Desc) || (is_array($orderBy2Desc) && empty($orderBy2Desc))) {
            unset($this->OrderBy2Desc);
        } else {
            $this->OrderBy2Desc = $orderBy2Desc;
        }
        return $this;
    }
    /**
     * Get OrderBy3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderBy3()
    {
        return isset($this->OrderBy3) ? $this->OrderBy3 : null;
    }
    /**
     * Set OrderBy3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderBy3
     * @return \patest\StructType\BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest
     */
    public function setOrderBy3($orderBy3 = null)
    {
        // validation for constraint: string
        if (!is_null($orderBy3) && !is_string($orderBy3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderBy3, true), gettype($orderBy3)), __LINE__);
        }
        if (is_null($orderBy3) || (is_array($orderBy3) && empty($orderBy3))) {
            unset($this->OrderBy3);
        } else {
            $this->OrderBy3 = $orderBy3;
        }
        return $this;
    }
    /**
     * Get OrderBy3Desc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOrderBy3Desc()
    {
        return isset($this->OrderBy3Desc) ? $this->OrderBy3Desc : null;
    }
    /**
     * Set OrderBy3Desc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $orderBy3Desc
     * @return \patest\StructType\BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest
     */
    public function setOrderBy3Desc($orderBy3Desc = null)
    {
        // validation for constraint: boolean
        if (!is_null($orderBy3Desc) && !is_bool($orderBy3Desc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($orderBy3Desc, true), gettype($orderBy3Desc)), __LINE__);
        }
        if (is_null($orderBy3Desc) || (is_array($orderBy3Desc) && empty($orderBy3Desc))) {
            unset($this->OrderBy3Desc);
        } else {
            $this->OrderBy3Desc = $orderBy3Desc;
        }
        return $this;
    }
    /**
     * Get PrintTestPage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPrintTestPage()
    {
        return isset($this->PrintTestPage) ? $this->PrintTestPage : null;
    }
    /**
     * Set PrintTestPage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $printTestPage
     * @return \patest\StructType\BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest
     */
    public function setPrintTestPage($printTestPage = null)
    {
        // validation for constraint: boolean
        if (!is_null($printTestPage) && !is_bool($printTestPage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printTestPage, true), gettype($printTestPage)), __LINE__);
        }
        if (is_null($printTestPage) || (is_array($printTestPage) && empty($printTestPage))) {
            unset($this->PrintTestPage);
        } else {
            $this->PrintTestPage = $printTestPage;
        }
        return $this;
    }
    /**
     * Get PrintUsingCultureId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintUsingCultureId()
    {
        return isset($this->PrintUsingCultureId) ? $this->PrintUsingCultureId : null;
    }
    /**
     * Set PrintUsingCultureId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printUsingCultureId
     * @return \patest\StructType\BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest
     */
    public function setPrintUsingCultureId($printUsingCultureId = null)
    {
        // validation for constraint: string
        if (!is_null($printUsingCultureId) && !is_string($printUsingCultureId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printUsingCultureId, true), gettype($printUsingCultureId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($printUsingCultureId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $printUsingCultureId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($printUsingCultureId, true)), __LINE__);
        }
        if (is_null($printUsingCultureId) || (is_array($printUsingCultureId) && empty($printUsingCultureId))) {
            unset($this->PrintUsingCultureId);
        } else {
            $this->PrintUsingCultureId = $printUsingCultureId;
        }
        return $this;
    }
    /**
     * Get QueryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQueryId()
    {
        return isset($this->QueryId) ? $this->QueryId : null;
    }
    /**
     * Set QueryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $queryId
     * @return \patest\StructType\BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest
     */
    public function setQueryId($queryId = null)
    {
        // validation for constraint: string
        if (!is_null($queryId) && !is_string($queryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queryId, true), gettype($queryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($queryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $queryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($queryId, true)), __LINE__);
        }
        if (is_null($queryId) || (is_array($queryId) && empty($queryId))) {
            unset($this->QueryId);
        } else {
            $this->QueryId = $queryId;
        }
        return $this;
    }
    /**
     * Get QueryName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQueryName()
    {
        return isset($this->QueryName) ? $this->QueryName : null;
    }
    /**
     * Set QueryName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $queryName
     * @return \patest\StructType\BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest
     */
    public function setQueryName($queryName = null)
    {
        // validation for constraint: string
        if (!is_null($queryName) && !is_string($queryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queryName, true), gettype($queryName)), __LINE__);
        }
        if (is_null($queryName) || (is_array($queryName) && empty($queryName))) {
            unset($this->QueryName);
        } else {
            $this->QueryName = $queryName;
        }
        return $this;
    }
    /**
     * Get QueryResultsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQueryResultsCount()
    {
        return isset($this->QueryResultsCount) ? $this->QueryResultsCount : null;
    }
    /**
     * Set QueryResultsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $queryResultsCount
     * @return \patest\StructType\BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest
     */
    public function setQueryResultsCount($queryResultsCount = null)
    {
        // validation for constraint: string
        if (!is_null($queryResultsCount) && !is_string($queryResultsCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queryResultsCount, true), gettype($queryResultsCount)), __LINE__);
        }
        if (is_null($queryResultsCount) || (is_array($queryResultsCount) && empty($queryResultsCount))) {
            unset($this->QueryResultsCount);
        } else {
            $this->QueryResultsCount = $queryResultsCount;
        }
        return $this;
    }
    /**
     * Get RequestContext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestContext()
    {
        return isset($this->RequestContext) ? $this->RequestContext : null;
    }
    /**
     * Set RequestContext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestContext
     * @return \patest\StructType\BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest
     */
    public function setRequestContext($requestContext = null)
    {
        // validation for constraint: string
        if (!is_null($requestContext) && !is_string($requestContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestContext, true), gettype($requestContext)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($requestContext) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $requestContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($requestContext, true)), __LINE__);
        }
        if (is_null($requestContext) || (is_array($requestContext) && empty($requestContext))) {
            unset($this->RequestContext);
        } else {
            $this->RequestContext = $requestContext;
        }
        return $this;
    }
    /**
     * Get TargetDocumentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetDocumentId()
    {
        return isset($this->TargetDocumentId) ? $this->TargetDocumentId : null;
    }
    /**
     * Set TargetDocumentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetDocumentId
     * @return \patest\StructType\BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest
     */
    public function setTargetDocumentId($targetDocumentId = null)
    {
        // validation for constraint: string
        if (!is_null($targetDocumentId) && !is_string($targetDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetDocumentId, true), gettype($targetDocumentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetDocumentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetDocumentId, true)), __LINE__);
        }
        if (is_null($targetDocumentId) || (is_array($targetDocumentId) && empty($targetDocumentId))) {
            unset($this->TargetDocumentId);
        } else {
            $this->TargetDocumentId = $targetDocumentId;
        }
        return $this;
    }
    /**
     * Get TargetPrinterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetPrinterId()
    {
        return isset($this->TargetPrinterId) ? $this->TargetPrinterId : null;
    }
    /**
     * Set TargetPrinterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetPrinterId
     * @return \patest\StructType\BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest
     */
    public function setTargetPrinterId($targetPrinterId = null)
    {
        // validation for constraint: string
        if (!is_null($targetPrinterId) && !is_string($targetPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetPrinterId, true), gettype($targetPrinterId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetPrinterId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetPrinterId, true)), __LINE__);
        }
        if (is_null($targetPrinterId) || (is_array($targetPrinterId) && empty($targetPrinterId))) {
            unset($this->TargetPrinterId);
        } else {
            $this->TargetPrinterId = $targetPrinterId;
        }
        return $this;
    }
    /**
     * Get ToPage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getToPage()
    {
        return isset($this->ToPage) ? $this->ToPage : null;
    }
    /**
     * Set ToPage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $toPage
     * @return \patest\StructType\BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest
     */
    public function setToPage($toPage = null)
    {
        // validation for constraint: int
        if (!is_null($toPage) && !(is_int($toPage) || ctype_digit($toPage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($toPage, true), gettype($toPage)), __LINE__);
        }
        if (is_null($toPage) || (is_array($toPage) && empty($toPage))) {
            unset($this->ToPage);
        } else {
            $this->ToPage = $toPage;
        }
        return $this;
    }
    /**
     * Get ToRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getToRecord()
    {
        return isset($this->ToRecord) ? $this->ToRecord : null;
    }
    /**
     * Set ToRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $toRecord
     * @return \patest\StructType\BizActionLogics_QueryBuilder_PrintCustomerLabelsRequest
     */
    public function setToRecord($toRecord = null)
    {
        // validation for constraint: int
        if (!is_null($toRecord) && !(is_int($toRecord) || ctype_digit($toRecord))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($toRecord, true), gettype($toRecord)), __LINE__);
        }
        if (is_null($toRecord) || (is_array($toRecord) && empty($toRecord))) {
            unset($this->ToRecord);
        } else {
            $this->ToRecord = $toRecord;
        }
        return $this;
    }
}
