<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BatchPrintingTransactionItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BatchPrintingTransactionItem
 * @subpackage Structs
 */
class BatchPrintingTransactionItem extends AbstractStructBase
{
    /**
     * The BasketItemServiceSpecificId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BasketItemServiceSpecificId;
    /**
     * The BasketItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BasketItemType;
    /**
     * The IsPrinted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsPrinted;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ItemId;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ItemType;
    /**
     * The SubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionInstanceId;
    /**
     * The TicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketId;
    /**
     * Constructor method for BatchPrintingTransactionItem
     * @uses BatchPrintingTransactionItem::setBasketItemServiceSpecificId()
     * @uses BatchPrintingTransactionItem::setBasketItemType()
     * @uses BatchPrintingTransactionItem::setIsPrinted()
     * @uses BatchPrintingTransactionItem::setItemId()
     * @uses BatchPrintingTransactionItem::setItemType()
     * @uses BatchPrintingTransactionItem::setSubscriptionInstanceId()
     * @uses BatchPrintingTransactionItem::setTicketId()
     * @param string $basketItemServiceSpecificId
     * @param int $basketItemType
     * @param bool $isPrinted
     * @param string $itemId
     * @param string $itemType
     * @param string $subscriptionInstanceId
     * @param string $ticketId
     */
    public function __construct($basketItemServiceSpecificId = null, $basketItemType = null, $isPrinted = null, $itemId = null, $itemType = null, $subscriptionInstanceId = null, $ticketId = null)
    {
        $this
            ->setBasketItemServiceSpecificId($basketItemServiceSpecificId)
            ->setBasketItemType($basketItemType)
            ->setIsPrinted($isPrinted)
            ->setItemId($itemId)
            ->setItemType($itemType)
            ->setSubscriptionInstanceId($subscriptionInstanceId)
            ->setTicketId($ticketId);
    }
    /**
     * Get BasketItemServiceSpecificId value
     * @return string|null
     */
    public function getBasketItemServiceSpecificId()
    {
        return $this->BasketItemServiceSpecificId;
    }
    /**
     * Set BasketItemServiceSpecificId value
     * @param string $basketItemServiceSpecificId
     * @return \patest\StructType\BatchPrintingTransactionItem
     */
    public function setBasketItemServiceSpecificId($basketItemServiceSpecificId = null)
    {
        // validation for constraint: string
        if (!is_null($basketItemServiceSpecificId) && !is_string($basketItemServiceSpecificId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($basketItemServiceSpecificId, true), gettype($basketItemServiceSpecificId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($basketItemServiceSpecificId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $basketItemServiceSpecificId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($basketItemServiceSpecificId, true)), __LINE__);
        }
        $this->BasketItemServiceSpecificId = $basketItemServiceSpecificId;
        return $this;
    }
    /**
     * Get BasketItemType value
     * @return int|null
     */
    public function getBasketItemType()
    {
        return $this->BasketItemType;
    }
    /**
     * Set BasketItemType value
     * @param int $basketItemType
     * @return \patest\StructType\BatchPrintingTransactionItem
     */
    public function setBasketItemType($basketItemType = null)
    {
        // validation for constraint: int
        if (!is_null($basketItemType) && !(is_int($basketItemType) || ctype_digit($basketItemType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($basketItemType, true), gettype($basketItemType)), __LINE__);
        }
        $this->BasketItemType = $basketItemType;
        return $this;
    }
    /**
     * Get IsPrinted value
     * @return bool|null
     */
    public function getIsPrinted()
    {
        return $this->IsPrinted;
    }
    /**
     * Set IsPrinted value
     * @param bool $isPrinted
     * @return \patest\StructType\BatchPrintingTransactionItem
     */
    public function setIsPrinted($isPrinted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrinted) && !is_bool($isPrinted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrinted, true), gettype($isPrinted)), __LINE__);
        }
        $this->IsPrinted = $isPrinted;
        return $this;
    }
    /**
     * Get ItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemId()
    {
        return isset($this->ItemId) ? $this->ItemId : null;
    }
    /**
     * Set ItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemId
     * @return \patest\StructType\BatchPrintingTransactionItem
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($itemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($itemId, true)), __LINE__);
        }
        if (is_null($itemId) || (is_array($itemId) && empty($itemId))) {
            unset($this->ItemId);
        } else {
            $this->ItemId = $itemId;
        }
        return $this;
    }
    /**
     * Get ItemType value
     * @return string|null
     */
    public function getItemType()
    {
        return $this->ItemType;
    }
    /**
     * Set ItemType value
     * @uses \patest\EnumType\BatchPrintingTransactionItemType::valueIsValid()
     * @uses \patest\EnumType\BatchPrintingTransactionItemType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $itemType
     * @return \patest\StructType\BatchPrintingTransactionItem
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintingTransactionItemType::valueIsValid($itemType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintingTransactionItemType', is_array($itemType) ? implode(', ', $itemType) : var_export($itemType, true), implode(', ', \patest\EnumType\BatchPrintingTransactionItemType::getValidValues())), __LINE__);
        }
        $this->ItemType = $itemType;
        return $this;
    }
    /**
     * Get SubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionInstanceId()
    {
        return isset($this->SubscriptionInstanceId) ? $this->SubscriptionInstanceId : null;
    }
    /**
     * Set SubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionInstanceId
     * @return \patest\StructType\BatchPrintingTransactionItem
     */
    public function setSubscriptionInstanceId($subscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionInstanceId) && !is_string($subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionInstanceId, true), gettype($subscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($subscriptionInstanceId) || (is_array($subscriptionInstanceId) && empty($subscriptionInstanceId))) {
            unset($this->SubscriptionInstanceId);
        } else {
            $this->SubscriptionInstanceId = $subscriptionInstanceId;
        }
        return $this;
    }
    /**
     * Get TicketId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketId()
    {
        return isset($this->TicketId) ? $this->TicketId : null;
    }
    /**
     * Set TicketId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketId
     * @return \patest\StructType\BatchPrintingTransactionItem
     */
    public function setTicketId($ticketId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketId) && !is_string($ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketId, true), gettype($ticketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketId, true)), __LINE__);
        }
        if (is_null($ticketId) || (is_array($ticketId) && empty($ticketId))) {
            unset($this->TicketId);
        } else {
            $this->TicketId = $ticketId;
        }
        return $this;
    }
}
