<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BatchPrintResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BatchPrintResponse
 * @subpackage Structs
 */
class BatchPrintResponse extends AbstractStructBase
{
    /**
     * The LegacyErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $LegacyErrors;
    /**
     * The NoData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $NoData;
    /**
     * The Transactions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfBatchPrintingTransaction
     */
    public $Transactions;
    /**
     * Constructor method for BatchPrintResponse
     * @uses BatchPrintResponse::setLegacyErrors()
     * @uses BatchPrintResponse::setNoData()
     * @uses BatchPrintResponse::setTransactions()
     * @param \patest\ArrayType\ArrayOfstring $legacyErrors
     * @param bool $noData
     * @param \patest\ArrayType\ArrayOfBatchPrintingTransaction $transactions
     */
    public function __construct(\patest\ArrayType\ArrayOfstring $legacyErrors = null, $noData = null, \patest\ArrayType\ArrayOfBatchPrintingTransaction $transactions = null)
    {
        $this
            ->setLegacyErrors($legacyErrors)
            ->setNoData($noData)
            ->setTransactions($transactions);
    }
    /**
     * Get LegacyErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getLegacyErrors()
    {
        return isset($this->LegacyErrors) ? $this->LegacyErrors : null;
    }
    /**
     * Set LegacyErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $legacyErrors
     * @return \patest\StructType\BatchPrintResponse
     */
    public function setLegacyErrors(\patest\ArrayType\ArrayOfstring $legacyErrors = null)
    {
        if (is_null($legacyErrors) || (is_array($legacyErrors) && empty($legacyErrors))) {
            unset($this->LegacyErrors);
        } else {
            $this->LegacyErrors = $legacyErrors;
        }
        return $this;
    }
    /**
     * Get NoData value
     * @return bool|null
     */
    public function getNoData()
    {
        return $this->NoData;
    }
    /**
     * Set NoData value
     * @param bool $noData
     * @return \patest\StructType\BatchPrintResponse
     */
    public function setNoData($noData = null)
    {
        // validation for constraint: boolean
        if (!is_null($noData) && !is_bool($noData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($noData, true), gettype($noData)), __LINE__);
        }
        $this->NoData = $noData;
        return $this;
    }
    /**
     * Get Transactions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfBatchPrintingTransaction|null
     */
    public function getTransactions()
    {
        return isset($this->Transactions) ? $this->Transactions : null;
    }
    /**
     * Set Transactions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfBatchPrintingTransaction $transactions
     * @return \patest\StructType\BatchPrintResponse
     */
    public function setTransactions(\patest\ArrayType\ArrayOfBatchPrintingTransaction $transactions = null)
    {
        if (is_null($transactions) || (is_array($transactions) && empty($transactions))) {
            unset($this->Transactions);
        } else {
            $this->Transactions = $transactions;
        }
        return $this;
    }
}
