<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BasketSnapshot StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BasketSnapshot
 * @subpackage Structs
 */
class BasketSnapshot extends AbstractStructBase
{
    /**
     * The Balance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $Balance;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfAbstractItem
     */
    public $Items;
    /**
     * The PriceModifiers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfAbstractPriceModifier
     */
    public $PriceModifiers;
    /**
     * The TotalPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $TotalPayment;
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $TotalPrice;
    /**
     * The TotalActualPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $TotalActualPayment;
    /**
     * The AdjustedBalance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $AdjustedBalance;
    /**
     * The AdjustedTotalPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $AdjustedTotalPrice;
    /**
     * Constructor method for BasketSnapshot
     * @uses BasketSnapshot::setBalance()
     * @uses BasketSnapshot::setItems()
     * @uses BasketSnapshot::setPriceModifiers()
     * @uses BasketSnapshot::setTotalPayment()
     * @uses BasketSnapshot::setTotalPrice()
     * @uses BasketSnapshot::setTotalActualPayment()
     * @uses BasketSnapshot::setAdjustedBalance()
     * @uses BasketSnapshot::setAdjustedTotalPrice()
     * @param \patest\StructType\Money $balance
     * @param \patest\ArrayType\ArrayOfAbstractItem $items
     * @param \patest\ArrayType\ArrayOfAbstractPriceModifier $priceModifiers
     * @param \patest\StructType\Money $totalPayment
     * @param \patest\StructType\Money $totalPrice
     * @param \patest\StructType\Money $totalActualPayment
     * @param \patest\StructType\Money $adjustedBalance
     * @param \patest\StructType\Money $adjustedTotalPrice
     */
    public function __construct(\patest\StructType\Money $balance = null, \patest\ArrayType\ArrayOfAbstractItem $items = null, \patest\ArrayType\ArrayOfAbstractPriceModifier $priceModifiers = null, \patest\StructType\Money $totalPayment = null, \patest\StructType\Money $totalPrice = null, \patest\StructType\Money $totalActualPayment = null, \patest\StructType\Money $adjustedBalance = null, \patest\StructType\Money $adjustedTotalPrice = null)
    {
        $this
            ->setBalance($balance)
            ->setItems($items)
            ->setPriceModifiers($priceModifiers)
            ->setTotalPayment($totalPayment)
            ->setTotalPrice($totalPrice)
            ->setTotalActualPayment($totalActualPayment)
            ->setAdjustedBalance($adjustedBalance)
            ->setAdjustedTotalPrice($adjustedTotalPrice);
    }
    /**
     * Get Balance value
     * @return \patest\StructType\Money|null
     */
    public function getBalance()
    {
        return $this->Balance;
    }
    /**
     * Set Balance value
     * @param \patest\StructType\Money $balance
     * @return \patest\StructType\BasketSnapshot
     */
    public function setBalance(\patest\StructType\Money $balance = null)
    {
        $this->Balance = $balance;
        return $this;
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfAbstractItem|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfAbstractItem $items
     * @return \patest\StructType\BasketSnapshot
     */
    public function setItems(\patest\ArrayType\ArrayOfAbstractItem $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
    /**
     * Get PriceModifiers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfAbstractPriceModifier|null
     */
    public function getPriceModifiers()
    {
        return isset($this->PriceModifiers) ? $this->PriceModifiers : null;
    }
    /**
     * Set PriceModifiers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfAbstractPriceModifier $priceModifiers
     * @return \patest\StructType\BasketSnapshot
     */
    public function setPriceModifiers(\patest\ArrayType\ArrayOfAbstractPriceModifier $priceModifiers = null)
    {
        if (is_null($priceModifiers) || (is_array($priceModifiers) && empty($priceModifiers))) {
            unset($this->PriceModifiers);
        } else {
            $this->PriceModifiers = $priceModifiers;
        }
        return $this;
    }
    /**
     * Get TotalPayment value
     * @return \patest\StructType\Money|null
     */
    public function getTotalPayment()
    {
        return $this->TotalPayment;
    }
    /**
     * Set TotalPayment value
     * @param \patest\StructType\Money $totalPayment
     * @return \patest\StructType\BasketSnapshot
     */
    public function setTotalPayment(\patest\StructType\Money $totalPayment = null)
    {
        $this->TotalPayment = $totalPayment;
        return $this;
    }
    /**
     * Get TotalPrice value
     * @return \patest\StructType\Money|null
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param \patest\StructType\Money $totalPrice
     * @return \patest\StructType\BasketSnapshot
     */
    public function setTotalPrice(\patest\StructType\Money $totalPrice = null)
    {
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get TotalActualPayment value
     * @return \patest\StructType\Money|null
     */
    public function getTotalActualPayment()
    {
        return $this->TotalActualPayment;
    }
    /**
     * Set TotalActualPayment value
     * @param \patest\StructType\Money $totalActualPayment
     * @return \patest\StructType\BasketSnapshot
     */
    public function setTotalActualPayment(\patest\StructType\Money $totalActualPayment = null)
    {
        $this->TotalActualPayment = $totalActualPayment;
        return $this;
    }
    /**
     * Get AdjustedBalance value
     * @return \patest\StructType\Money|null
     */
    public function getAdjustedBalance()
    {
        return $this->AdjustedBalance;
    }
    /**
     * Set AdjustedBalance value
     * @param \patest\StructType\Money $adjustedBalance
     * @return \patest\StructType\BasketSnapshot
     */
    public function setAdjustedBalance(\patest\StructType\Money $adjustedBalance = null)
    {
        $this->AdjustedBalance = $adjustedBalance;
        return $this;
    }
    /**
     * Get AdjustedTotalPrice value
     * @return \patest\StructType\Money|null
     */
    public function getAdjustedTotalPrice()
    {
        return $this->AdjustedTotalPrice;
    }
    /**
     * Set AdjustedTotalPrice value
     * @param \patest\StructType\Money $adjustedTotalPrice
     * @return \patest\StructType\BasketSnapshot
     */
    public function setAdjustedTotalPrice(\patest\StructType\Money $adjustedTotalPrice = null)
    {
        $this->AdjustedTotalPrice = $adjustedTotalPrice;
        return $this;
    }
}
