<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BasicFault StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BasicFault
 * @subpackage Structs
 */
class BasicFault extends AbstractStructBase
{
    /**
     * The CaseId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CaseId;
    /**
     * The LocalizedText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LocalizedText;
    /**
     * Constructor method for BasicFault
     * @uses BasicFault::setCaseId()
     * @uses BasicFault::setLocalizedText()
     * @param string $caseId
     * @param string $localizedText
     */
    public function __construct($caseId = null, $localizedText = null)
    {
        $this
            ->setCaseId($caseId)
            ->setLocalizedText($localizedText);
    }
    /**
     * Get CaseId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCaseId()
    {
        return isset($this->CaseId) ? $this->CaseId : null;
    }
    /**
     * Set CaseId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $caseId
     * @return \patest\StructType\BasicFault
     */
    public function setCaseId($caseId = null)
    {
        // validation for constraint: string
        if (!is_null($caseId) && !is_string($caseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($caseId, true), gettype($caseId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($caseId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $caseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($caseId, true)), __LINE__);
        }
        if (is_null($caseId) || (is_array($caseId) && empty($caseId))) {
            unset($this->CaseId);
        } else {
            $this->CaseId = $caseId;
        }
        return $this;
    }
    /**
     * Get LocalizedText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocalizedText()
    {
        return isset($this->LocalizedText) ? $this->LocalizedText : null;
    }
    /**
     * Set LocalizedText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $localizedText
     * @return \patest\StructType\BasicFault
     */
    public function setLocalizedText($localizedText = null)
    {
        // validation for constraint: string
        if (!is_null($localizedText) && !is_string($localizedText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localizedText, true), gettype($localizedText)), __LINE__);
        }
        if (is_null($localizedText) || (is_array($localizedText) && empty($localizedText))) {
            unset($this->LocalizedText);
        } else {
            $this->LocalizedText = $localizedText;
        }
        return $this;
    }
}
