<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bSRO.Sales.LockTypeSelection StructType
 * @subpackage Structs
 */
class BSRO_Sales_LockTypeSelection extends AnyEntity
{
    /**
     * The ContainGAAreas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ContainGAAreas;
    /**
     * The LockTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LockTypeId;
    /**
     * The SeatsQty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatsQty;
    /**
     * Constructor method for bSRO.Sales.LockTypeSelection
     * @uses BSRO_Sales_LockTypeSelection::setContainGAAreas()
     * @uses BSRO_Sales_LockTypeSelection::setLockTypeId()
     * @uses BSRO_Sales_LockTypeSelection::setSeatsQty()
     * @param bool $containGAAreas
     * @param string $lockTypeId
     * @param int $seatsQty
     */
    public function __construct($containGAAreas = null, $lockTypeId = null, $seatsQty = null)
    {
        $this
            ->setContainGAAreas($containGAAreas)
            ->setLockTypeId($lockTypeId)
            ->setSeatsQty($seatsQty);
    }
    /**
     * Get ContainGAAreas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getContainGAAreas()
    {
        return isset($this->ContainGAAreas) ? $this->ContainGAAreas : null;
    }
    /**
     * Set ContainGAAreas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $containGAAreas
     * @return \patest\StructType\BSRO_Sales_LockTypeSelection
     */
    public function setContainGAAreas($containGAAreas = null)
    {
        // validation for constraint: boolean
        if (!is_null($containGAAreas) && !is_bool($containGAAreas)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($containGAAreas, true), gettype($containGAAreas)), __LINE__);
        }
        if (is_null($containGAAreas) || (is_array($containGAAreas) && empty($containGAAreas))) {
            unset($this->ContainGAAreas);
        } else {
            $this->ContainGAAreas = $containGAAreas;
        }
        return $this;
    }
    /**
     * Get LockTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLockTypeId()
    {
        return isset($this->LockTypeId) ? $this->LockTypeId : null;
    }
    /**
     * Set LockTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lockTypeId
     * @return \patest\StructType\BSRO_Sales_LockTypeSelection
     */
    public function setLockTypeId($lockTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($lockTypeId) && !is_string($lockTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lockTypeId, true), gettype($lockTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($lockTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lockTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($lockTypeId, true)), __LINE__);
        }
        if (is_null($lockTypeId) || (is_array($lockTypeId) && empty($lockTypeId))) {
            unset($this->LockTypeId);
        } else {
            $this->LockTypeId = $lockTypeId;
        }
        return $this;
    }
    /**
     * Get SeatsQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatsQty()
    {
        return isset($this->SeatsQty) ? $this->SeatsQty : null;
    }
    /**
     * Set SeatsQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatsQty
     * @return \patest\StructType\BSRO_Sales_LockTypeSelection
     */
    public function setSeatsQty($seatsQty = null)
    {
        // validation for constraint: int
        if (!is_null($seatsQty) && !(is_int($seatsQty) || ctype_digit($seatsQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatsQty, true), gettype($seatsQty)), __LINE__);
        }
        if (is_null($seatsQty) || (is_array($seatsQty) && empty($seatsQty))) {
            unset($this->SeatsQty);
        } else {
            $this->SeatsQty = $seatsQty;
        }
        return $this;
    }
}
