<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Authentication.OAuth20Data StructType
 * @subpackage Structs
 */
class Authentication_OAuth20Data extends Authentication_ExternalAuthenticationData
{
    /**
     * The AccessToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessToken;
    /**
     * The Expires
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Expires;
    /**
     * Constructor method for Authentication.OAuth20Data
     * @uses Authentication_OAuth20Data::setAccessToken()
     * @uses Authentication_OAuth20Data::setExpires()
     * @param string $accessToken
     * @param string $expires
     */
    public function __construct($accessToken = null, $expires = null)
    {
        $this
            ->setAccessToken($accessToken)
            ->setExpires($expires);
    }
    /**
     * Get AccessToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessToken()
    {
        return isset($this->AccessToken) ? $this->AccessToken : null;
    }
    /**
     * Set AccessToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessToken
     * @return \patest\StructType\Authentication_OAuth20Data
     */
    public function setAccessToken($accessToken = null)
    {
        // validation for constraint: string
        if (!is_null($accessToken) && !is_string($accessToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessToken, true), gettype($accessToken)), __LINE__);
        }
        if (is_null($accessToken) || (is_array($accessToken) && empty($accessToken))) {
            unset($this->AccessToken);
        } else {
            $this->AccessToken = $accessToken;
        }
        return $this;
    }
    /**
     * Get Expires value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpires()
    {
        return isset($this->Expires) ? $this->Expires : null;
    }
    /**
     * Set Expires value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expires
     * @return \patest\StructType\Authentication_OAuth20Data
     */
    public function setExpires($expires = null)
    {
        // validation for constraint: string
        if (!is_null($expires) && !is_string($expires)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expires, true), gettype($expires)), __LINE__);
        }
        if (is_null($expires) || (is_array($expires) && empty($expires))) {
            unset($this->Expires);
        } else {
            $this->Expires = $expires;
        }
        return $this;
    }
}
