<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AreBasePricesMandatoryForPriceListRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AreBasePricesMandatoryForPriceListRequest
 * @subpackage Structs
 */
class AreBasePricesMandatoryForPriceListRequest extends ExtensibleDataContract
{
    /**
     * The AdditionalPriceTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $AdditionalPriceTypeIds;
    /**
     * The ExcludePriceTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $ExcludePriceTypes;
    /**
     * The PriceListId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceListId;
    /**
     * Constructor method for AreBasePricesMandatoryForPriceListRequest
     * @uses AreBasePricesMandatoryForPriceListRequest::setAdditionalPriceTypeIds()
     * @uses AreBasePricesMandatoryForPriceListRequest::setExcludePriceTypes()
     * @uses AreBasePricesMandatoryForPriceListRequest::setPriceListId()
     * @param \patest\ArrayType\ArrayOfguid $additionalPriceTypeIds
     * @param \patest\ArrayType\ArrayOfguid $excludePriceTypes
     * @param string $priceListId
     */
    public function __construct(\patest\ArrayType\ArrayOfguid $additionalPriceTypeIds = null, \patest\ArrayType\ArrayOfguid $excludePriceTypes = null, $priceListId = null)
    {
        $this
            ->setAdditionalPriceTypeIds($additionalPriceTypeIds)
            ->setExcludePriceTypes($excludePriceTypes)
            ->setPriceListId($priceListId);
    }
    /**
     * Get AdditionalPriceTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getAdditionalPriceTypeIds()
    {
        return isset($this->AdditionalPriceTypeIds) ? $this->AdditionalPriceTypeIds : null;
    }
    /**
     * Set AdditionalPriceTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $additionalPriceTypeIds
     * @return \patest\StructType\AreBasePricesMandatoryForPriceListRequest
     */
    public function setAdditionalPriceTypeIds(\patest\ArrayType\ArrayOfguid $additionalPriceTypeIds = null)
    {
        if (is_null($additionalPriceTypeIds) || (is_array($additionalPriceTypeIds) && empty($additionalPriceTypeIds))) {
            unset($this->AdditionalPriceTypeIds);
        } else {
            $this->AdditionalPriceTypeIds = $additionalPriceTypeIds;
        }
        return $this;
    }
    /**
     * Get ExcludePriceTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getExcludePriceTypes()
    {
        return isset($this->ExcludePriceTypes) ? $this->ExcludePriceTypes : null;
    }
    /**
     * Set ExcludePriceTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $excludePriceTypes
     * @return \patest\StructType\AreBasePricesMandatoryForPriceListRequest
     */
    public function setExcludePriceTypes(\patest\ArrayType\ArrayOfguid $excludePriceTypes = null)
    {
        if (is_null($excludePriceTypes) || (is_array($excludePriceTypes) && empty($excludePriceTypes))) {
            unset($this->ExcludePriceTypes);
        } else {
            $this->ExcludePriceTypes = $excludePriceTypes;
        }
        return $this;
    }
    /**
     * Get PriceListId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceListId()
    {
        return isset($this->PriceListId) ? $this->PriceListId : null;
    }
    /**
     * Set PriceListId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceListId
     * @return \patest\StructType\AreBasePricesMandatoryForPriceListRequest
     */
    public function setPriceListId($priceListId = null)
    {
        // validation for constraint: string
        if (!is_null($priceListId) && !is_string($priceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceListId, true), gettype($priceListId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceListId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceListId, true)), __LINE__);
        }
        if (is_null($priceListId) || (is_array($priceListId) && empty($priceListId))) {
            unset($this->PriceListId);
        } else {
            $this->PriceListId = $priceListId;
        }
        return $this;
    }
}
