<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplyChangeToPaymentPlanInstallments-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ApplyChangeToPaymentPlanInstallments-Request
 * @subpackage Structs
 */
class ApplyChangeToPaymentPlanInstallments_Request extends AbstractStructBase
{
    /**
     * The AmountAdjustmentOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AmountAdjustmentOption;
    /**
     * The ChangeKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $ChangeKind;
    /**
     * The InstallmentItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfInstallmentItem
     */
    public $InstallmentItems;
    /**
     * The NewAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $NewAmount;
    /**
     * The NewCustomInstallmentDates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfdateTime
     */
    public $NewCustomInstallmentDates;
    /**
     * The NewDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NewDate;
    /**
     * The NewDateOfFirstInstallment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NewDateOfFirstInstallment;
    /**
     * The NewNotes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NewNotes;
    /**
     * The NewNumberOfInstallments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NewNumberOfInstallments;
    /**
     * The NewPaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewPaymentMethodId;
    /**
     * The NewPaymentProviderSpecificTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewPaymentProviderSpecificTokenId;
    /**
     * The NewScheduleKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NewScheduleKind;
    /**
     * The OrderOfInstallmentToChange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OrderOfInstallmentToChange;
    /**
     * The TotlaAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotlaAmount;
    /**
     * Constructor method for ApplyChangeToPaymentPlanInstallments-Request
     * @uses ApplyChangeToPaymentPlanInstallments_Request::setAmountAdjustmentOption()
     * @uses ApplyChangeToPaymentPlanInstallments_Request::setChangeKind()
     * @uses ApplyChangeToPaymentPlanInstallments_Request::setInstallmentItems()
     * @uses ApplyChangeToPaymentPlanInstallments_Request::setNewAmount()
     * @uses ApplyChangeToPaymentPlanInstallments_Request::setNewCustomInstallmentDates()
     * @uses ApplyChangeToPaymentPlanInstallments_Request::setNewDate()
     * @uses ApplyChangeToPaymentPlanInstallments_Request::setNewDateOfFirstInstallment()
     * @uses ApplyChangeToPaymentPlanInstallments_Request::setNewNotes()
     * @uses ApplyChangeToPaymentPlanInstallments_Request::setNewNumberOfInstallments()
     * @uses ApplyChangeToPaymentPlanInstallments_Request::setNewPaymentMethodId()
     * @uses ApplyChangeToPaymentPlanInstallments_Request::setNewPaymentProviderSpecificTokenId()
     * @uses ApplyChangeToPaymentPlanInstallments_Request::setNewScheduleKind()
     * @uses ApplyChangeToPaymentPlanInstallments_Request::setOrderOfInstallmentToChange()
     * @uses ApplyChangeToPaymentPlanInstallments_Request::setTotlaAmount()
     * @param string $amountAdjustmentOption
     * @param string[] $changeKind
     * @param \patest\ArrayType\ArrayOfInstallmentItem $installmentItems
     * @param \patest\StructType\Money $newAmount
     * @param \patest\ArrayType\ArrayOfdateTime $newCustomInstallmentDates
     * @param string $newDate
     * @param string $newDateOfFirstInstallment
     * @param string $newNotes
     * @param int $newNumberOfInstallments
     * @param string $newPaymentMethodId
     * @param string $newPaymentProviderSpecificTokenId
     * @param string $newScheduleKind
     * @param int $orderOfInstallmentToChange
     * @param \patest\StructType\Money $totlaAmount
     */
    public function __construct($amountAdjustmentOption = null, array $changeKind = array(), \patest\ArrayType\ArrayOfInstallmentItem $installmentItems = null, \patest\StructType\Money $newAmount = null, \patest\ArrayType\ArrayOfdateTime $newCustomInstallmentDates = null, $newDate = null, $newDateOfFirstInstallment = null, $newNotes = null, $newNumberOfInstallments = null, $newPaymentMethodId = null, $newPaymentProviderSpecificTokenId = null, $newScheduleKind = null, $orderOfInstallmentToChange = null, \patest\StructType\Money $totlaAmount = null)
    {
        $this
            ->setAmountAdjustmentOption($amountAdjustmentOption)
            ->setChangeKind($changeKind)
            ->setInstallmentItems($installmentItems)
            ->setNewAmount($newAmount)
            ->setNewCustomInstallmentDates($newCustomInstallmentDates)
            ->setNewDate($newDate)
            ->setNewDateOfFirstInstallment($newDateOfFirstInstallment)
            ->setNewNotes($newNotes)
            ->setNewNumberOfInstallments($newNumberOfInstallments)
            ->setNewPaymentMethodId($newPaymentMethodId)
            ->setNewPaymentProviderSpecificTokenId($newPaymentProviderSpecificTokenId)
            ->setNewScheduleKind($newScheduleKind)
            ->setOrderOfInstallmentToChange($orderOfInstallmentToChange)
            ->setTotlaAmount($totlaAmount);
    }
    /**
     * Get AmountAdjustmentOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmountAdjustmentOption()
    {
        return isset($this->AmountAdjustmentOption) ? $this->AmountAdjustmentOption : null;
    }
    /**
     * Set AmountAdjustmentOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\InstallmentsAmountAdjustmentOption::valueIsValid()
     * @uses \patest\EnumType\InstallmentsAmountAdjustmentOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $amountAdjustmentOption
     * @return \patest\StructType\ApplyChangeToPaymentPlanInstallments_Request
     */
    public function setAmountAdjustmentOption($amountAdjustmentOption = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\InstallmentsAmountAdjustmentOption::valueIsValid($amountAdjustmentOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\InstallmentsAmountAdjustmentOption', is_array($amountAdjustmentOption) ? implode(', ', $amountAdjustmentOption) : var_export($amountAdjustmentOption, true), implode(', ', \patest\EnumType\InstallmentsAmountAdjustmentOption::getValidValues())), __LINE__);
        }
        if (is_null($amountAdjustmentOption) || (is_array($amountAdjustmentOption) && empty($amountAdjustmentOption))) {
            unset($this->AmountAdjustmentOption);
        } else {
            $this->AmountAdjustmentOption = $amountAdjustmentOption;
        }
        return $this;
    }
    /**
     * Get ChangeKind value
     * @return string[]|null
     */
    public function getChangeKind()
    {
        return $this->ChangeKind;
    }
    /**
     * This method is responsible for validating the values passed to the setChangeKind method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChangeKind method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChangeKindForArrayConstraintsFromSetChangeKind(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $applyChangeToPaymentPlanInstallments_RequestChangeKindItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\PaymentPlanInstallmentsChangeEnum::valueIsValid($applyChangeToPaymentPlanInstallments_RequestChangeKindItem)) {
                $invalidValues[] = is_object($applyChangeToPaymentPlanInstallments_RequestChangeKindItem) ? get_class($applyChangeToPaymentPlanInstallments_RequestChangeKindItem) : sprintf('%s(%s)', gettype($applyChangeToPaymentPlanInstallments_RequestChangeKindItem), var_export($applyChangeToPaymentPlanInstallments_RequestChangeKindItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentPlanInstallmentsChangeEnum', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\PaymentPlanInstallmentsChangeEnum::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ChangeKind value
     * @uses \patest\EnumType\PaymentPlanInstallmentsChangeEnum::valueIsValid()
     * @uses \patest\EnumType\PaymentPlanInstallmentsChangeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $changeKind
     * @return \patest\StructType\ApplyChangeToPaymentPlanInstallments_Request
     */
    public function setChangeKind(array $changeKind = array())
    {
        // validation for constraint: list
        if ('' !== ($changeKindArrayErrorMessage = self::validateChangeKindForArrayConstraintsFromSetChangeKind($changeKind))) {
            throw new \InvalidArgumentException($changeKindArrayErrorMessage, __LINE__);
        }
        $this->ChangeKind = is_array($changeKind) ? implode(' ', $changeKind) : null;
        return $this;
    }
    /**
     * Get InstallmentItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfInstallmentItem|null
     */
    public function getInstallmentItems()
    {
        return isset($this->InstallmentItems) ? $this->InstallmentItems : null;
    }
    /**
     * Set InstallmentItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfInstallmentItem $installmentItems
     * @return \patest\StructType\ApplyChangeToPaymentPlanInstallments_Request
     */
    public function setInstallmentItems(\patest\ArrayType\ArrayOfInstallmentItem $installmentItems = null)
    {
        if (is_null($installmentItems) || (is_array($installmentItems) && empty($installmentItems))) {
            unset($this->InstallmentItems);
        } else {
            $this->InstallmentItems = $installmentItems;
        }
        return $this;
    }
    /**
     * Get NewAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getNewAmount()
    {
        return isset($this->NewAmount) ? $this->NewAmount : null;
    }
    /**
     * Set NewAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $newAmount
     * @return \patest\StructType\ApplyChangeToPaymentPlanInstallments_Request
     */
    public function setNewAmount(\patest\StructType\Money $newAmount = null)
    {
        if (is_null($newAmount) || (is_array($newAmount) && empty($newAmount))) {
            unset($this->NewAmount);
        } else {
            $this->NewAmount = $newAmount;
        }
        return $this;
    }
    /**
     * Get NewCustomInstallmentDates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfdateTime|null
     */
    public function getNewCustomInstallmentDates()
    {
        return isset($this->NewCustomInstallmentDates) ? $this->NewCustomInstallmentDates : null;
    }
    /**
     * Set NewCustomInstallmentDates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfdateTime $newCustomInstallmentDates
     * @return \patest\StructType\ApplyChangeToPaymentPlanInstallments_Request
     */
    public function setNewCustomInstallmentDates(\patest\ArrayType\ArrayOfdateTime $newCustomInstallmentDates = null)
    {
        if (is_null($newCustomInstallmentDates) || (is_array($newCustomInstallmentDates) && empty($newCustomInstallmentDates))) {
            unset($this->NewCustomInstallmentDates);
        } else {
            $this->NewCustomInstallmentDates = $newCustomInstallmentDates;
        }
        return $this;
    }
    /**
     * Get NewDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewDate()
    {
        return isset($this->NewDate) ? $this->NewDate : null;
    }
    /**
     * Set NewDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newDate
     * @return \patest\StructType\ApplyChangeToPaymentPlanInstallments_Request
     */
    public function setNewDate($newDate = null)
    {
        // validation for constraint: string
        if (!is_null($newDate) && !is_string($newDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newDate, true), gettype($newDate)), __LINE__);
        }
        if (is_null($newDate) || (is_array($newDate) && empty($newDate))) {
            unset($this->NewDate);
        } else {
            $this->NewDate = $newDate;
        }
        return $this;
    }
    /**
     * Get NewDateOfFirstInstallment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewDateOfFirstInstallment()
    {
        return isset($this->NewDateOfFirstInstallment) ? $this->NewDateOfFirstInstallment : null;
    }
    /**
     * Set NewDateOfFirstInstallment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newDateOfFirstInstallment
     * @return \patest\StructType\ApplyChangeToPaymentPlanInstallments_Request
     */
    public function setNewDateOfFirstInstallment($newDateOfFirstInstallment = null)
    {
        // validation for constraint: string
        if (!is_null($newDateOfFirstInstallment) && !is_string($newDateOfFirstInstallment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newDateOfFirstInstallment, true), gettype($newDateOfFirstInstallment)), __LINE__);
        }
        if (is_null($newDateOfFirstInstallment) || (is_array($newDateOfFirstInstallment) && empty($newDateOfFirstInstallment))) {
            unset($this->NewDateOfFirstInstallment);
        } else {
            $this->NewDateOfFirstInstallment = $newDateOfFirstInstallment;
        }
        return $this;
    }
    /**
     * Get NewNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewNotes()
    {
        return isset($this->NewNotes) ? $this->NewNotes : null;
    }
    /**
     * Set NewNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newNotes
     * @return \patest\StructType\ApplyChangeToPaymentPlanInstallments_Request
     */
    public function setNewNotes($newNotes = null)
    {
        // validation for constraint: string
        if (!is_null($newNotes) && !is_string($newNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newNotes, true), gettype($newNotes)), __LINE__);
        }
        if (is_null($newNotes) || (is_array($newNotes) && empty($newNotes))) {
            unset($this->NewNotes);
        } else {
            $this->NewNotes = $newNotes;
        }
        return $this;
    }
    /**
     * Get NewNumberOfInstallments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNewNumberOfInstallments()
    {
        return isset($this->NewNumberOfInstallments) ? $this->NewNumberOfInstallments : null;
    }
    /**
     * Set NewNumberOfInstallments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $newNumberOfInstallments
     * @return \patest\StructType\ApplyChangeToPaymentPlanInstallments_Request
     */
    public function setNewNumberOfInstallments($newNumberOfInstallments = null)
    {
        // validation for constraint: int
        if (!is_null($newNumberOfInstallments) && !(is_int($newNumberOfInstallments) || ctype_digit($newNumberOfInstallments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($newNumberOfInstallments, true), gettype($newNumberOfInstallments)), __LINE__);
        }
        if (is_null($newNumberOfInstallments) || (is_array($newNumberOfInstallments) && empty($newNumberOfInstallments))) {
            unset($this->NewNumberOfInstallments);
        } else {
            $this->NewNumberOfInstallments = $newNumberOfInstallments;
        }
        return $this;
    }
    /**
     * Get NewPaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewPaymentMethodId()
    {
        return isset($this->NewPaymentMethodId) ? $this->NewPaymentMethodId : null;
    }
    /**
     * Set NewPaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newPaymentMethodId
     * @return \patest\StructType\ApplyChangeToPaymentPlanInstallments_Request
     */
    public function setNewPaymentMethodId($newPaymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($newPaymentMethodId) && !is_string($newPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newPaymentMethodId, true), gettype($newPaymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newPaymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newPaymentMethodId, true)), __LINE__);
        }
        if (is_null($newPaymentMethodId) || (is_array($newPaymentMethodId) && empty($newPaymentMethodId))) {
            unset($this->NewPaymentMethodId);
        } else {
            $this->NewPaymentMethodId = $newPaymentMethodId;
        }
        return $this;
    }
    /**
     * Get NewPaymentProviderSpecificTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewPaymentProviderSpecificTokenId()
    {
        return isset($this->NewPaymentProviderSpecificTokenId) ? $this->NewPaymentProviderSpecificTokenId : null;
    }
    /**
     * Set NewPaymentProviderSpecificTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newPaymentProviderSpecificTokenId
     * @return \patest\StructType\ApplyChangeToPaymentPlanInstallments_Request
     */
    public function setNewPaymentProviderSpecificTokenId($newPaymentProviderSpecificTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($newPaymentProviderSpecificTokenId) && !is_string($newPaymentProviderSpecificTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newPaymentProviderSpecificTokenId, true), gettype($newPaymentProviderSpecificTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newPaymentProviderSpecificTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newPaymentProviderSpecificTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newPaymentProviderSpecificTokenId, true)), __LINE__);
        }
        if (is_null($newPaymentProviderSpecificTokenId) || (is_array($newPaymentProviderSpecificTokenId) && empty($newPaymentProviderSpecificTokenId))) {
            unset($this->NewPaymentProviderSpecificTokenId);
        } else {
            $this->NewPaymentProviderSpecificTokenId = $newPaymentProviderSpecificTokenId;
        }
        return $this;
    }
    /**
     * Get NewScheduleKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewScheduleKind()
    {
        return isset($this->NewScheduleKind) ? $this->NewScheduleKind : null;
    }
    /**
     * Set NewScheduleKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\InstallmentScheduleKind::valueIsValid()
     * @uses \patest\EnumType\InstallmentScheduleKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $newScheduleKind
     * @return \patest\StructType\ApplyChangeToPaymentPlanInstallments_Request
     */
    public function setNewScheduleKind($newScheduleKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\InstallmentScheduleKind::valueIsValid($newScheduleKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\InstallmentScheduleKind', is_array($newScheduleKind) ? implode(', ', $newScheduleKind) : var_export($newScheduleKind, true), implode(', ', \patest\EnumType\InstallmentScheduleKind::getValidValues())), __LINE__);
        }
        if (is_null($newScheduleKind) || (is_array($newScheduleKind) && empty($newScheduleKind))) {
            unset($this->NewScheduleKind);
        } else {
            $this->NewScheduleKind = $newScheduleKind;
        }
        return $this;
    }
    /**
     * Get OrderOfInstallmentToChange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrderOfInstallmentToChange()
    {
        return isset($this->OrderOfInstallmentToChange) ? $this->OrderOfInstallmentToChange : null;
    }
    /**
     * Set OrderOfInstallmentToChange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $orderOfInstallmentToChange
     * @return \patest\StructType\ApplyChangeToPaymentPlanInstallments_Request
     */
    public function setOrderOfInstallmentToChange($orderOfInstallmentToChange = null)
    {
        // validation for constraint: int
        if (!is_null($orderOfInstallmentToChange) && !(is_int($orderOfInstallmentToChange) || ctype_digit($orderOfInstallmentToChange))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderOfInstallmentToChange, true), gettype($orderOfInstallmentToChange)), __LINE__);
        }
        if (is_null($orderOfInstallmentToChange) || (is_array($orderOfInstallmentToChange) && empty($orderOfInstallmentToChange))) {
            unset($this->OrderOfInstallmentToChange);
        } else {
            $this->OrderOfInstallmentToChange = $orderOfInstallmentToChange;
        }
        return $this;
    }
    /**
     * Get TotlaAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotlaAmount()
    {
        return isset($this->TotlaAmount) ? $this->TotlaAmount : null;
    }
    /**
     * Set TotlaAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totlaAmount
     * @return \patest\StructType\ApplyChangeToPaymentPlanInstallments_Request
     */
    public function setTotlaAmount(\patest\StructType\Money $totlaAmount = null)
    {
        if (is_null($totlaAmount) || (is_array($totlaAmount) && empty($totlaAmount))) {
            unset($this->TotlaAmount);
        } else {
            $this->TotlaAmount = $totlaAmount;
        }
        return $this;
    }
}
