<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Any.BaseMassEnrollmentLog StructType
 * @subpackage Structs
 */
class Any_BaseMassEnrollmentLog extends PersistableEntity
{
    /**
     * The AlreadyEnrolled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AlreadyEnrolled;
    /**
     * The ClientTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientTypes;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Date;
    /**
     * The IsUndone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUndone;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Operation;
    /**
     * The Population
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Population;
    /**
     * The Processed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Processed;
    /**
     * The Summary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Summary;
    /**
     * The User
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $User;
    /**
     * Constructor method for Any.BaseMassEnrollmentLog
     * @uses Any_BaseMassEnrollmentLog::setAlreadyEnrolled()
     * @uses Any_BaseMassEnrollmentLog::setClientTypes()
     * @uses Any_BaseMassEnrollmentLog::setDate()
     * @uses Any_BaseMassEnrollmentLog::setIsUndone()
     * @uses Any_BaseMassEnrollmentLog::setOperation()
     * @uses Any_BaseMassEnrollmentLog::setPopulation()
     * @uses Any_BaseMassEnrollmentLog::setProcessed()
     * @uses Any_BaseMassEnrollmentLog::setSummary()
     * @uses Any_BaseMassEnrollmentLog::setUser()
     * @param int $alreadyEnrolled
     * @param string $clientTypes
     * @param string $date
     * @param bool $isUndone
     * @param string $operation
     * @param int $population
     * @param int $processed
     * @param string $summary
     * @param string $user
     */
    public function __construct($alreadyEnrolled = null, $clientTypes = null, $date = null, $isUndone = null, $operation = null, $population = null, $processed = null, $summary = null, $user = null)
    {
        $this
            ->setAlreadyEnrolled($alreadyEnrolled)
            ->setClientTypes($clientTypes)
            ->setDate($date)
            ->setIsUndone($isUndone)
            ->setOperation($operation)
            ->setPopulation($population)
            ->setProcessed($processed)
            ->setSummary($summary)
            ->setUser($user);
    }
    /**
     * Get AlreadyEnrolled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAlreadyEnrolled()
    {
        return isset($this->AlreadyEnrolled) ? $this->AlreadyEnrolled : null;
    }
    /**
     * Set AlreadyEnrolled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $alreadyEnrolled
     * @return \patest\StructType\Any_BaseMassEnrollmentLog
     */
    public function setAlreadyEnrolled($alreadyEnrolled = null)
    {
        // validation for constraint: int
        if (!is_null($alreadyEnrolled) && !(is_int($alreadyEnrolled) || ctype_digit($alreadyEnrolled))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alreadyEnrolled, true), gettype($alreadyEnrolled)), __LINE__);
        }
        if (is_null($alreadyEnrolled) || (is_array($alreadyEnrolled) && empty($alreadyEnrolled))) {
            unset($this->AlreadyEnrolled);
        } else {
            $this->AlreadyEnrolled = $alreadyEnrolled;
        }
        return $this;
    }
    /**
     * Get ClientTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientTypes()
    {
        return isset($this->ClientTypes) ? $this->ClientTypes : null;
    }
    /**
     * Set ClientTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientTypes
     * @return \patest\StructType\Any_BaseMassEnrollmentLog
     */
    public function setClientTypes($clientTypes = null)
    {
        // validation for constraint: string
        if (!is_null($clientTypes) && !is_string($clientTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientTypes, true), gettype($clientTypes)), __LINE__);
        }
        if (is_null($clientTypes) || (is_array($clientTypes) && empty($clientTypes))) {
            unset($this->ClientTypes);
        } else {
            $this->ClientTypes = $clientTypes;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $date
     * @return \patest\StructType\Any_BaseMassEnrollmentLog
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get IsUndone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUndone()
    {
        return isset($this->IsUndone) ? $this->IsUndone : null;
    }
    /**
     * Set IsUndone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUndone
     * @return \patest\StructType\Any_BaseMassEnrollmentLog
     */
    public function setIsUndone($isUndone = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUndone) && !is_bool($isUndone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUndone, true), gettype($isUndone)), __LINE__);
        }
        if (is_null($isUndone) || (is_array($isUndone) && empty($isUndone))) {
            unset($this->IsUndone);
        } else {
            $this->IsUndone = $isUndone;
        }
        return $this;
    }
    /**
     * Get Operation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperation()
    {
        return isset($this->Operation) ? $this->Operation : null;
    }
    /**
     * Set Operation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\MassEnrollmentOperation::valueIsValid()
     * @uses \patest\EnumType\MassEnrollmentOperation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \patest\StructType\Any_BaseMassEnrollmentLog
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MassEnrollmentOperation::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MassEnrollmentOperation', is_array($operation) ? implode(', ', $operation) : var_export($operation, true), implode(', ', \patest\EnumType\MassEnrollmentOperation::getValidValues())), __LINE__);
        }
        if (is_null($operation) || (is_array($operation) && empty($operation))) {
            unset($this->Operation);
        } else {
            $this->Operation = $operation;
        }
        return $this;
    }
    /**
     * Get Population value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPopulation()
    {
        return isset($this->Population) ? $this->Population : null;
    }
    /**
     * Set Population value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $population
     * @return \patest\StructType\Any_BaseMassEnrollmentLog
     */
    public function setPopulation($population = null)
    {
        // validation for constraint: int
        if (!is_null($population) && !(is_int($population) || ctype_digit($population))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($population, true), gettype($population)), __LINE__);
        }
        if (is_null($population) || (is_array($population) && empty($population))) {
            unset($this->Population);
        } else {
            $this->Population = $population;
        }
        return $this;
    }
    /**
     * Get Processed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProcessed()
    {
        return isset($this->Processed) ? $this->Processed : null;
    }
    /**
     * Set Processed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $processed
     * @return \patest\StructType\Any_BaseMassEnrollmentLog
     */
    public function setProcessed($processed = null)
    {
        // validation for constraint: int
        if (!is_null($processed) && !(is_int($processed) || ctype_digit($processed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($processed, true), gettype($processed)), __LINE__);
        }
        if (is_null($processed) || (is_array($processed) && empty($processed))) {
            unset($this->Processed);
        } else {
            $this->Processed = $processed;
        }
        return $this;
    }
    /**
     * Get Summary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSummary()
    {
        return isset($this->Summary) ? $this->Summary : null;
    }
    /**
     * Set Summary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $summary
     * @return \patest\StructType\Any_BaseMassEnrollmentLog
     */
    public function setSummary($summary = null)
    {
        // validation for constraint: string
        if (!is_null($summary) && !is_string($summary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($summary, true), gettype($summary)), __LINE__);
        }
        if (is_null($summary) || (is_array($summary) && empty($summary))) {
            unset($this->Summary);
        } else {
            $this->Summary = $summary;
        }
        return $this;
    }
    /**
     * Get User value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUser()
    {
        return isset($this->User) ? $this->User : null;
    }
    /**
     * Set User value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $user
     * @return \patest\StructType\Any_BaseMassEnrollmentLog
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($user) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($user, true)), __LINE__);
        }
        if (is_null($user) || (is_array($user) && empty($user))) {
            unset($this->User);
        } else {
            $this->User = $user;
        }
        return $this;
    }
}
