<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddResaleTicketsToBasket-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddResaleTicketsToBasket-Request
 * @subpackage Structs
 */
class AddResaleTicketsToBasket_Request extends ExtensibleDataContract
{
    /**
     * The ExistingResaleRequestIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $ExistingResaleRequestIds;
    /**
     * The NewResaleRequestDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfResaleRequestDetails
     */
    public $NewResaleRequestDetails;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * Constructor method for AddResaleTicketsToBasket-Request
     * @uses AddResaleTicketsToBasket_Request::setExistingResaleRequestIds()
     * @uses AddResaleTicketsToBasket_Request::setNewResaleRequestDetails()
     * @uses AddResaleTicketsToBasket_Request::setTransactionGuid()
     * @uses AddResaleTicketsToBasket_Request::setTransactionSnapshotType()
     * @param \patest\ArrayType\ArrayOfguid $existingResaleRequestIds
     * @param \patest\ArrayType\ArrayOfResaleRequestDetails $newResaleRequestDetails
     * @param string $transactionGuid
     * @param string $transactionSnapshotType
     */
    public function __construct(\patest\ArrayType\ArrayOfguid $existingResaleRequestIds = null, \patest\ArrayType\ArrayOfResaleRequestDetails $newResaleRequestDetails = null, $transactionGuid = null, $transactionSnapshotType = null)
    {
        $this
            ->setExistingResaleRequestIds($existingResaleRequestIds)
            ->setNewResaleRequestDetails($newResaleRequestDetails)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionSnapshotType($transactionSnapshotType);
    }
    /**
     * Get ExistingResaleRequestIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getExistingResaleRequestIds()
    {
        return isset($this->ExistingResaleRequestIds) ? $this->ExistingResaleRequestIds : null;
    }
    /**
     * Set ExistingResaleRequestIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $existingResaleRequestIds
     * @return \patest\StructType\AddResaleTicketsToBasket_Request
     */
    public function setExistingResaleRequestIds(\patest\ArrayType\ArrayOfguid $existingResaleRequestIds = null)
    {
        if (is_null($existingResaleRequestIds) || (is_array($existingResaleRequestIds) && empty($existingResaleRequestIds))) {
            unset($this->ExistingResaleRequestIds);
        } else {
            $this->ExistingResaleRequestIds = $existingResaleRequestIds;
        }
        return $this;
    }
    /**
     * Get NewResaleRequestDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfResaleRequestDetails|null
     */
    public function getNewResaleRequestDetails()
    {
        return isset($this->NewResaleRequestDetails) ? $this->NewResaleRequestDetails : null;
    }
    /**
     * Set NewResaleRequestDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfResaleRequestDetails $newResaleRequestDetails
     * @return \patest\StructType\AddResaleTicketsToBasket_Request
     */
    public function setNewResaleRequestDetails(\patest\ArrayType\ArrayOfResaleRequestDetails $newResaleRequestDetails = null)
    {
        if (is_null($newResaleRequestDetails) || (is_array($newResaleRequestDetails) && empty($newResaleRequestDetails))) {
            unset($this->NewResaleRequestDetails);
        } else {
            $this->NewResaleRequestDetails = $newResaleRequestDetails;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\AddResaleTicketsToBasket_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\AddResaleTicketsToBasket_Request
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
}
