<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddPriceListRuleToEvent-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddPriceListRuleToEvent-Request
 * @subpackage Structs
 */
class AddPriceListRuleToEvent_Request extends ExtensibleDataContract
{
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The Override
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Override;
    /**
     * The PriceListId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceListId;
    /**
     * Constructor method for AddPriceListRuleToEvent-Request
     * @uses AddPriceListRuleToEvent_Request::setEventId()
     * @uses AddPriceListRuleToEvent_Request::setOverride()
     * @uses AddPriceListRuleToEvent_Request::setPriceListId()
     * @param string $eventId
     * @param bool $override
     * @param string $priceListId
     */
    public function __construct($eventId = null, $override = null, $priceListId = null)
    {
        $this
            ->setEventId($eventId)
            ->setOverride($override)
            ->setPriceListId($priceListId);
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \patest\StructType\AddPriceListRuleToEvent_Request
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get Override value
     * @return bool|null
     */
    public function getOverride()
    {
        return $this->Override;
    }
    /**
     * Set Override value
     * @param bool $override
     * @return \patest\StructType\AddPriceListRuleToEvent_Request
     */
    public function setOverride($override = null)
    {
        // validation for constraint: boolean
        if (!is_null($override) && !is_bool($override)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($override, true), gettype($override)), __LINE__);
        }
        $this->Override = $override;
        return $this;
    }
    /**
     * Get PriceListId value
     * @return string|null
     */
    public function getPriceListId()
    {
        return $this->PriceListId;
    }
    /**
     * Set PriceListId value
     * @param string $priceListId
     * @return \patest\StructType\AddPriceListRuleToEvent_Request
     */
    public function setPriceListId($priceListId = null)
    {
        // validation for constraint: string
        if (!is_null($priceListId) && !is_string($priceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceListId, true), gettype($priceListId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceListId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceListId, true)), __LINE__);
        }
        $this->PriceListId = $priceListId;
        return $this;
    }
}
