<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddAccessCodesToPresale-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddAccessCodesToPresale-Request
 * @subpackage Structs
 */
class AddAccessCodesToPresale_Request extends ExtensibleDataContract
{
    /**
     * The AccessCodeTexts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $AccessCodeTexts;
    /**
     * The PresaleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PresaleId;
    /**
     * The UseBestEffort
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseBestEffort;
    /**
     * Constructor method for AddAccessCodesToPresale-Request
     * @uses AddAccessCodesToPresale_Request::setAccessCodeTexts()
     * @uses AddAccessCodesToPresale_Request::setPresaleId()
     * @uses AddAccessCodesToPresale_Request::setUseBestEffort()
     * @param \patest\ArrayType\ArrayOfstring $accessCodeTexts
     * @param string $presaleId
     * @param bool $useBestEffort
     */
    public function __construct(\patest\ArrayType\ArrayOfstring $accessCodeTexts = null, $presaleId = null, $useBestEffort = null)
    {
        $this
            ->setAccessCodeTexts($accessCodeTexts)
            ->setPresaleId($presaleId)
            ->setUseBestEffort($useBestEffort);
    }
    /**
     * Get AccessCodeTexts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getAccessCodeTexts()
    {
        return isset($this->AccessCodeTexts) ? $this->AccessCodeTexts : null;
    }
    /**
     * Set AccessCodeTexts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $accessCodeTexts
     * @return \patest\StructType\AddAccessCodesToPresale_Request
     */
    public function setAccessCodeTexts(\patest\ArrayType\ArrayOfstring $accessCodeTexts = null)
    {
        if (is_null($accessCodeTexts) || (is_array($accessCodeTexts) && empty($accessCodeTexts))) {
            unset($this->AccessCodeTexts);
        } else {
            $this->AccessCodeTexts = $accessCodeTexts;
        }
        return $this;
    }
    /**
     * Get PresaleId value
     * @return string|null
     */
    public function getPresaleId()
    {
        return $this->PresaleId;
    }
    /**
     * Set PresaleId value
     * @param string $presaleId
     * @return \patest\StructType\AddAccessCodesToPresale_Request
     */
    public function setPresaleId($presaleId = null)
    {
        // validation for constraint: string
        if (!is_null($presaleId) && !is_string($presaleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($presaleId, true), gettype($presaleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($presaleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $presaleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($presaleId, true)), __LINE__);
        }
        $this->PresaleId = $presaleId;
        return $this;
    }
    /**
     * Get UseBestEffort value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseBestEffort()
    {
        return isset($this->UseBestEffort) ? $this->UseBestEffort : null;
    }
    /**
     * Set UseBestEffort value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useBestEffort
     * @return \patest\StructType\AddAccessCodesToPresale_Request
     */
    public function setUseBestEffort($useBestEffort = null)
    {
        // validation for constraint: boolean
        if (!is_null($useBestEffort) && !is_bool($useBestEffort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useBestEffort, true), gettype($useBestEffort)), __LINE__);
        }
        if (is_null($useBestEffort) || (is_array($useBestEffort) && empty($useBestEffort))) {
            unset($this->UseBestEffort);
        } else {
            $this->UseBestEffort = $useBestEffort;
        }
        return $this;
    }
}
