<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.MobileAppJournalEntry StructType
 * @subpackage Structs
 */
class AccessControl_MobileAppJournalEntry extends VolatileEntity
{
    /**
     * The AccessCardId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessCardId;
    /**
     * The AccessControlSystemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlSystemId;
    /**
     * The ActivityTimestamp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActivityTimestamp;
    /**
     * The ApplicationChannelName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationChannelName;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The BarcodeRefEntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BarcodeRefEntityId;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * The CardRefEntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CardRefEntityId;
    /**
     * The ConnectionAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ConnectionAuditId;
    /**
     * The CorrelationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CorrelationId;
    /**
     * The DateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateTime;
    /**
     * The ErrorDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorDescription;
    /**
     * The EventDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDescription;
    /**
     * The EventSystemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventSystemName;
    /**
     * The EventType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventType;
    /**
     * The Importance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Importance;
    /**
     * The JournalSystemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JournalSystemName;
    /**
     * The MobileApplicationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MobileApplicationId;
    /**
     * The MobileAppProvider
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MobileAppProvider;
    /**
     * The NotificationError
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NotificationError;
    /**
     * The NotificationRequestSummary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NotificationRequestSummary;
    /**
     * The NotificationSentSuccessfully
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NotificationSentSuccessfully;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The SalePointName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalePointName;
    /**
     * The SecurityTokenName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SecurityTokenName;
    /**
     * The SiteName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiteName;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Type;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserId;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * Constructor method for AccessControl.MobileAppJournalEntry
     * @uses AccessControl_MobileAppJournalEntry::setAccessCardId()
     * @uses AccessControl_MobileAppJournalEntry::setAccessControlSystemId()
     * @uses AccessControl_MobileAppJournalEntry::setActivityTimestamp()
     * @uses AccessControl_MobileAppJournalEntry::setApplicationChannelName()
     * @uses AccessControl_MobileAppJournalEntry::setBarcode()
     * @uses AccessControl_MobileAppJournalEntry::setBarcodeRefEntityId()
     * @uses AccessControl_MobileAppJournalEntry::setCardNumber()
     * @uses AccessControl_MobileAppJournalEntry::setCardRefEntityId()
     * @uses AccessControl_MobileAppJournalEntry::setConnectionAuditId()
     * @uses AccessControl_MobileAppJournalEntry::setCorrelationId()
     * @uses AccessControl_MobileAppJournalEntry::setDateTime()
     * @uses AccessControl_MobileAppJournalEntry::setErrorDescription()
     * @uses AccessControl_MobileAppJournalEntry::setEventDescription()
     * @uses AccessControl_MobileAppJournalEntry::setEventSystemName()
     * @uses AccessControl_MobileAppJournalEntry::setEventType()
     * @uses AccessControl_MobileAppJournalEntry::setImportance()
     * @uses AccessControl_MobileAppJournalEntry::setJournalSystemName()
     * @uses AccessControl_MobileAppJournalEntry::setMobileApplicationId()
     * @uses AccessControl_MobileAppJournalEntry::setMobileAppProvider()
     * @uses AccessControl_MobileAppJournalEntry::setNotificationError()
     * @uses AccessControl_MobileAppJournalEntry::setNotificationRequestSummary()
     * @uses AccessControl_MobileAppJournalEntry::setNotificationSentSuccessfully()
     * @uses AccessControl_MobileAppJournalEntry::setOrganizationUnitId()
     * @uses AccessControl_MobileAppJournalEntry::setSalePointName()
     * @uses AccessControl_MobileAppJournalEntry::setSecurityTokenName()
     * @uses AccessControl_MobileAppJournalEntry::setSiteName()
     * @uses AccessControl_MobileAppJournalEntry::setType()
     * @uses AccessControl_MobileAppJournalEntry::setUserId()
     * @uses AccessControl_MobileAppJournalEntry::setUserName()
     * @param string $accessCardId
     * @param string $accessControlSystemId
     * @param string $activityTimestamp
     * @param string $applicationChannelName
     * @param string $barcode
     * @param string $barcodeRefEntityId
     * @param string $cardNumber
     * @param string $cardRefEntityId
     * @param int $connectionAuditId
     * @param string $correlationId
     * @param string $dateTime
     * @param string $errorDescription
     * @param string $eventDescription
     * @param string $eventSystemName
     * @param string $eventType
     * @param string $importance
     * @param string $journalSystemName
     * @param string $mobileApplicationId
     * @param string $mobileAppProvider
     * @param string $notificationError
     * @param string $notificationRequestSummary
     * @param bool $notificationSentSuccessfully
     * @param string $organizationUnitId
     * @param string $salePointName
     * @param string $securityTokenName
     * @param string $siteName
     * @param int $type
     * @param string $userId
     * @param string $userName
     */
    public function __construct($accessCardId = null, $accessControlSystemId = null, $activityTimestamp = null, $applicationChannelName = null, $barcode = null, $barcodeRefEntityId = null, $cardNumber = null, $cardRefEntityId = null, $connectionAuditId = null, $correlationId = null, $dateTime = null, $errorDescription = null, $eventDescription = null, $eventSystemName = null, $eventType = null, $importance = null, $journalSystemName = null, $mobileApplicationId = null, $mobileAppProvider = null, $notificationError = null, $notificationRequestSummary = null, $notificationSentSuccessfully = null, $organizationUnitId = null, $salePointName = null, $securityTokenName = null, $siteName = null, $type = null, $userId = null, $userName = null)
    {
        $this
            ->setAccessCardId($accessCardId)
            ->setAccessControlSystemId($accessControlSystemId)
            ->setActivityTimestamp($activityTimestamp)
            ->setApplicationChannelName($applicationChannelName)
            ->setBarcode($barcode)
            ->setBarcodeRefEntityId($barcodeRefEntityId)
            ->setCardNumber($cardNumber)
            ->setCardRefEntityId($cardRefEntityId)
            ->setConnectionAuditId($connectionAuditId)
            ->setCorrelationId($correlationId)
            ->setDateTime($dateTime)
            ->setErrorDescription($errorDescription)
            ->setEventDescription($eventDescription)
            ->setEventSystemName($eventSystemName)
            ->setEventType($eventType)
            ->setImportance($importance)
            ->setJournalSystemName($journalSystemName)
            ->setMobileApplicationId($mobileApplicationId)
            ->setMobileAppProvider($mobileAppProvider)
            ->setNotificationError($notificationError)
            ->setNotificationRequestSummary($notificationRequestSummary)
            ->setNotificationSentSuccessfully($notificationSentSuccessfully)
            ->setOrganizationUnitId($organizationUnitId)
            ->setSalePointName($salePointName)
            ->setSecurityTokenName($securityTokenName)
            ->setSiteName($siteName)
            ->setType($type)
            ->setUserId($userId)
            ->setUserName($userName);
    }
    /**
     * Get AccessCardId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessCardId()
    {
        return isset($this->AccessCardId) ? $this->AccessCardId : null;
    }
    /**
     * Set AccessCardId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessCardId
     * @return \patest\StructType\AccessControl_MobileAppJournalEntry
     */
    public function setAccessCardId($accessCardId = null)
    {
        // validation for constraint: string
        if (!is_null($accessCardId) && !is_string($accessCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessCardId, true), gettype($accessCardId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessCardId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessCardId, true)), __LINE__);
        }
        if (is_null($accessCardId) || (is_array($accessCardId) && empty($accessCardId))) {
            unset($this->AccessCardId);
        } else {
            $this->AccessCardId = $accessCardId;
        }
        return $this;
    }
    /**
     * Get AccessControlSystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemId()
    {
        return isset($this->AccessControlSystemId) ? $this->AccessControlSystemId : null;
    }
    /**
     * Set AccessControlSystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemId
     * @return \patest\StructType\AccessControl_MobileAppJournalEntry
     */
    public function setAccessControlSystemId($accessControlSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemId) && !is_string($accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemId, true), gettype($accessControlSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlSystemId, true)), __LINE__);
        }
        if (is_null($accessControlSystemId) || (is_array($accessControlSystemId) && empty($accessControlSystemId))) {
            unset($this->AccessControlSystemId);
        } else {
            $this->AccessControlSystemId = $accessControlSystemId;
        }
        return $this;
    }
    /**
     * Get ActivityTimestamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivityTimestamp()
    {
        return isset($this->ActivityTimestamp) ? $this->ActivityTimestamp : null;
    }
    /**
     * Set ActivityTimestamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activityTimestamp
     * @return \patest\StructType\AccessControl_MobileAppJournalEntry
     */
    public function setActivityTimestamp($activityTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($activityTimestamp) && !is_string($activityTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityTimestamp, true), gettype($activityTimestamp)), __LINE__);
        }
        if (is_null($activityTimestamp) || (is_array($activityTimestamp) && empty($activityTimestamp))) {
            unset($this->ActivityTimestamp);
        } else {
            $this->ActivityTimestamp = $activityTimestamp;
        }
        return $this;
    }
    /**
     * Get ApplicationChannelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannelName()
    {
        return isset($this->ApplicationChannelName) ? $this->ApplicationChannelName : null;
    }
    /**
     * Set ApplicationChannelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannelName
     * @return \patest\StructType\AccessControl_MobileAppJournalEntry
     */
    public function setApplicationChannelName($applicationChannelName = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannelName) && !is_string($applicationChannelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannelName, true), gettype($applicationChannelName)), __LINE__);
        }
        if (is_null($applicationChannelName) || (is_array($applicationChannelName) && empty($applicationChannelName))) {
            unset($this->ApplicationChannelName);
        } else {
            $this->ApplicationChannelName = $applicationChannelName;
        }
        return $this;
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\AccessControl_MobileAppJournalEntry
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get BarcodeRefEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcodeRefEntityId()
    {
        return isset($this->BarcodeRefEntityId) ? $this->BarcodeRefEntityId : null;
    }
    /**
     * Set BarcodeRefEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcodeRefEntityId
     * @return \patest\StructType\AccessControl_MobileAppJournalEntry
     */
    public function setBarcodeRefEntityId($barcodeRefEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeRefEntityId) && !is_string($barcodeRefEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeRefEntityId, true), gettype($barcodeRefEntityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($barcodeRefEntityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $barcodeRefEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($barcodeRefEntityId, true)), __LINE__);
        }
        if (is_null($barcodeRefEntityId) || (is_array($barcodeRefEntityId) && empty($barcodeRefEntityId))) {
            unset($this->BarcodeRefEntityId);
        } else {
            $this->BarcodeRefEntityId = $barcodeRefEntityId;
        }
        return $this;
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \patest\StructType\AccessControl_MobileAppJournalEntry
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get CardRefEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardRefEntityId()
    {
        return isset($this->CardRefEntityId) ? $this->CardRefEntityId : null;
    }
    /**
     * Set CardRefEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardRefEntityId
     * @return \patest\StructType\AccessControl_MobileAppJournalEntry
     */
    public function setCardRefEntityId($cardRefEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($cardRefEntityId) && !is_string($cardRefEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardRefEntityId, true), gettype($cardRefEntityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($cardRefEntityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $cardRefEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($cardRefEntityId, true)), __LINE__);
        }
        if (is_null($cardRefEntityId) || (is_array($cardRefEntityId) && empty($cardRefEntityId))) {
            unset($this->CardRefEntityId);
        } else {
            $this->CardRefEntityId = $cardRefEntityId;
        }
        return $this;
    }
    /**
     * Get ConnectionAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getConnectionAuditId()
    {
        return isset($this->ConnectionAuditId) ? $this->ConnectionAuditId : null;
    }
    /**
     * Set ConnectionAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $connectionAuditId
     * @return \patest\StructType\AccessControl_MobileAppJournalEntry
     */
    public function setConnectionAuditId($connectionAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($connectionAuditId) && !(is_int($connectionAuditId) || ctype_digit($connectionAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($connectionAuditId, true), gettype($connectionAuditId)), __LINE__);
        }
        if (is_null($connectionAuditId) || (is_array($connectionAuditId) && empty($connectionAuditId))) {
            unset($this->ConnectionAuditId);
        } else {
            $this->ConnectionAuditId = $connectionAuditId;
        }
        return $this;
    }
    /**
     * Get CorrelationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCorrelationId()
    {
        return isset($this->CorrelationId) ? $this->CorrelationId : null;
    }
    /**
     * Set CorrelationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $correlationId
     * @return \patest\StructType\AccessControl_MobileAppJournalEntry
     */
    public function setCorrelationId($correlationId = null)
    {
        // validation for constraint: string
        if (!is_null($correlationId) && !is_string($correlationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($correlationId, true), gettype($correlationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($correlationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $correlationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($correlationId, true)), __LINE__);
        }
        if (is_null($correlationId) || (is_array($correlationId) && empty($correlationId))) {
            unset($this->CorrelationId);
        } else {
            $this->CorrelationId = $correlationId;
        }
        return $this;
    }
    /**
     * Get DateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateTime()
    {
        return isset($this->DateTime) ? $this->DateTime : null;
    }
    /**
     * Set DateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateTime
     * @return \patest\StructType\AccessControl_MobileAppJournalEntry
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        if (is_null($dateTime) || (is_array($dateTime) && empty($dateTime))) {
            unset($this->DateTime);
        } else {
            $this->DateTime = $dateTime;
        }
        return $this;
    }
    /**
     * Get ErrorDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorDescription()
    {
        return isset($this->ErrorDescription) ? $this->ErrorDescription : null;
    }
    /**
     * Set ErrorDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorDescription
     * @return \patest\StructType\AccessControl_MobileAppJournalEntry
     */
    public function setErrorDescription($errorDescription = null)
    {
        // validation for constraint: string
        if (!is_null($errorDescription) && !is_string($errorDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorDescription, true), gettype($errorDescription)), __LINE__);
        }
        if (is_null($errorDescription) || (is_array($errorDescription) && empty($errorDescription))) {
            unset($this->ErrorDescription);
        } else {
            $this->ErrorDescription = $errorDescription;
        }
        return $this;
    }
    /**
     * Get EventDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDescription()
    {
        return isset($this->EventDescription) ? $this->EventDescription : null;
    }
    /**
     * Set EventDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDescription
     * @return \patest\StructType\AccessControl_MobileAppJournalEntry
     */
    public function setEventDescription($eventDescription = null)
    {
        // validation for constraint: string
        if (!is_null($eventDescription) && !is_string($eventDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDescription, true), gettype($eventDescription)), __LINE__);
        }
        if (is_null($eventDescription) || (is_array($eventDescription) && empty($eventDescription))) {
            unset($this->EventDescription);
        } else {
            $this->EventDescription = $eventDescription;
        }
        return $this;
    }
    /**
     * Get EventSystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventSystemName()
    {
        return isset($this->EventSystemName) ? $this->EventSystemName : null;
    }
    /**
     * Set EventSystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventSystemName
     * @return \patest\StructType\AccessControl_MobileAppJournalEntry
     */
    public function setEventSystemName($eventSystemName = null)
    {
        // validation for constraint: string
        if (!is_null($eventSystemName) && !is_string($eventSystemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventSystemName, true), gettype($eventSystemName)), __LINE__);
        }
        if (is_null($eventSystemName) || (is_array($eventSystemName) && empty($eventSystemName))) {
            unset($this->EventSystemName);
        } else {
            $this->EventSystemName = $eventSystemName;
        }
        return $this;
    }
    /**
     * Get EventType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType()
    {
        return isset($this->EventType) ? $this->EventType : null;
    }
    /**
     * Set EventType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\JournalEventType::valueIsValid()
     * @uses \patest\EnumType\JournalEventType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eventType
     * @return \patest\StructType\AccessControl_MobileAppJournalEntry
     */
    public function setEventType($eventType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\JournalEventType::valueIsValid($eventType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\JournalEventType', is_array($eventType) ? implode(', ', $eventType) : var_export($eventType, true), implode(', ', \patest\EnumType\JournalEventType::getValidValues())), __LINE__);
        }
        if (is_null($eventType) || (is_array($eventType) && empty($eventType))) {
            unset($this->EventType);
        } else {
            $this->EventType = $eventType;
        }
        return $this;
    }
    /**
     * Get Importance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImportance()
    {
        return isset($this->Importance) ? $this->Importance : null;
    }
    /**
     * Set Importance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\JournalEntryImportance::valueIsValid()
     * @uses \patest\EnumType\JournalEntryImportance::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $importance
     * @return \patest\StructType\AccessControl_MobileAppJournalEntry
     */
    public function setImportance($importance = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\JournalEntryImportance::valueIsValid($importance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\JournalEntryImportance', is_array($importance) ? implode(', ', $importance) : var_export($importance, true), implode(', ', \patest\EnumType\JournalEntryImportance::getValidValues())), __LINE__);
        }
        if (is_null($importance) || (is_array($importance) && empty($importance))) {
            unset($this->Importance);
        } else {
            $this->Importance = $importance;
        }
        return $this;
    }
    /**
     * Get JournalSystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJournalSystemName()
    {
        return isset($this->JournalSystemName) ? $this->JournalSystemName : null;
    }
    /**
     * Set JournalSystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $journalSystemName
     * @return \patest\StructType\AccessControl_MobileAppJournalEntry
     */
    public function setJournalSystemName($journalSystemName = null)
    {
        // validation for constraint: string
        if (!is_null($journalSystemName) && !is_string($journalSystemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($journalSystemName, true), gettype($journalSystemName)), __LINE__);
        }
        if (is_null($journalSystemName) || (is_array($journalSystemName) && empty($journalSystemName))) {
            unset($this->JournalSystemName);
        } else {
            $this->JournalSystemName = $journalSystemName;
        }
        return $this;
    }
    /**
     * Get MobileApplicationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobileApplicationId()
    {
        return isset($this->MobileApplicationId) ? $this->MobileApplicationId : null;
    }
    /**
     * Set MobileApplicationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobileApplicationId
     * @return \patest\StructType\AccessControl_MobileAppJournalEntry
     */
    public function setMobileApplicationId($mobileApplicationId = null)
    {
        // validation for constraint: string
        if (!is_null($mobileApplicationId) && !is_string($mobileApplicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileApplicationId, true), gettype($mobileApplicationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($mobileApplicationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $mobileApplicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($mobileApplicationId, true)), __LINE__);
        }
        if (is_null($mobileApplicationId) || (is_array($mobileApplicationId) && empty($mobileApplicationId))) {
            unset($this->MobileApplicationId);
        } else {
            $this->MobileApplicationId = $mobileApplicationId;
        }
        return $this;
    }
    /**
     * Get MobileAppProvider value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobileAppProvider()
    {
        return isset($this->MobileAppProvider) ? $this->MobileAppProvider : null;
    }
    /**
     * Set MobileAppProvider value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobileAppProvider
     * @return \patest\StructType\AccessControl_MobileAppJournalEntry
     */
    public function setMobileAppProvider($mobileAppProvider = null)
    {
        // validation for constraint: string
        if (!is_null($mobileAppProvider) && !is_string($mobileAppProvider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileAppProvider, true), gettype($mobileAppProvider)), __LINE__);
        }
        if (is_null($mobileAppProvider) || (is_array($mobileAppProvider) && empty($mobileAppProvider))) {
            unset($this->MobileAppProvider);
        } else {
            $this->MobileAppProvider = $mobileAppProvider;
        }
        return $this;
    }
    /**
     * Get NotificationError value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotificationError()
    {
        return isset($this->NotificationError) ? $this->NotificationError : null;
    }
    /**
     * Set NotificationError value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notificationError
     * @return \patest\StructType\AccessControl_MobileAppJournalEntry
     */
    public function setNotificationError($notificationError = null)
    {
        // validation for constraint: string
        if (!is_null($notificationError) && !is_string($notificationError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notificationError, true), gettype($notificationError)), __LINE__);
        }
        if (is_null($notificationError) || (is_array($notificationError) && empty($notificationError))) {
            unset($this->NotificationError);
        } else {
            $this->NotificationError = $notificationError;
        }
        return $this;
    }
    /**
     * Get NotificationRequestSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotificationRequestSummary()
    {
        return isset($this->NotificationRequestSummary) ? $this->NotificationRequestSummary : null;
    }
    /**
     * Set NotificationRequestSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notificationRequestSummary
     * @return \patest\StructType\AccessControl_MobileAppJournalEntry
     */
    public function setNotificationRequestSummary($notificationRequestSummary = null)
    {
        // validation for constraint: string
        if (!is_null($notificationRequestSummary) && !is_string($notificationRequestSummary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notificationRequestSummary, true), gettype($notificationRequestSummary)), __LINE__);
        }
        if (is_null($notificationRequestSummary) || (is_array($notificationRequestSummary) && empty($notificationRequestSummary))) {
            unset($this->NotificationRequestSummary);
        } else {
            $this->NotificationRequestSummary = $notificationRequestSummary;
        }
        return $this;
    }
    /**
     * Get NotificationSentSuccessfully value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNotificationSentSuccessfully()
    {
        return isset($this->NotificationSentSuccessfully) ? $this->NotificationSentSuccessfully : null;
    }
    /**
     * Set NotificationSentSuccessfully value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $notificationSentSuccessfully
     * @return \patest\StructType\AccessControl_MobileAppJournalEntry
     */
    public function setNotificationSentSuccessfully($notificationSentSuccessfully = null)
    {
        // validation for constraint: boolean
        if (!is_null($notificationSentSuccessfully) && !is_bool($notificationSentSuccessfully)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($notificationSentSuccessfully, true), gettype($notificationSentSuccessfully)), __LINE__);
        }
        if (is_null($notificationSentSuccessfully) || (is_array($notificationSentSuccessfully) && empty($notificationSentSuccessfully))) {
            unset($this->NotificationSentSuccessfully);
        } else {
            $this->NotificationSentSuccessfully = $notificationSentSuccessfully;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\AccessControl_MobileAppJournalEntry
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get SalePointName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalePointName()
    {
        return isset($this->SalePointName) ? $this->SalePointName : null;
    }
    /**
     * Set SalePointName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salePointName
     * @return \patest\StructType\AccessControl_MobileAppJournalEntry
     */
    public function setSalePointName($salePointName = null)
    {
        // validation for constraint: string
        if (!is_null($salePointName) && !is_string($salePointName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salePointName, true), gettype($salePointName)), __LINE__);
        }
        if (is_null($salePointName) || (is_array($salePointName) && empty($salePointName))) {
            unset($this->SalePointName);
        } else {
            $this->SalePointName = $salePointName;
        }
        return $this;
    }
    /**
     * Get SecurityTokenName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityTokenName()
    {
        return isset($this->SecurityTokenName) ? $this->SecurityTokenName : null;
    }
    /**
     * Set SecurityTokenName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $securityTokenName
     * @return \patest\StructType\AccessControl_MobileAppJournalEntry
     */
    public function setSecurityTokenName($securityTokenName = null)
    {
        // validation for constraint: string
        if (!is_null($securityTokenName) && !is_string($securityTokenName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityTokenName, true), gettype($securityTokenName)), __LINE__);
        }
        if (is_null($securityTokenName) || (is_array($securityTokenName) && empty($securityTokenName))) {
            unset($this->SecurityTokenName);
        } else {
            $this->SecurityTokenName = $securityTokenName;
        }
        return $this;
    }
    /**
     * Get SiteName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiteName()
    {
        return isset($this->SiteName) ? $this->SiteName : null;
    }
    /**
     * Set SiteName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siteName
     * @return \patest\StructType\AccessControl_MobileAppJournalEntry
     */
    public function setSiteName($siteName = null)
    {
        // validation for constraint: string
        if (!is_null($siteName) && !is_string($siteName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteName, true), gettype($siteName)), __LINE__);
        }
        if (is_null($siteName) || (is_array($siteName) && empty($siteName))) {
            unset($this->SiteName);
        } else {
            $this->SiteName = $siteName;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $type
     * @return \patest\StructType\AccessControl_MobileAppJournalEntry
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !(is_int($type) || ctype_digit($type))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \patest\StructType\AccessControl_MobileAppJournalEntry
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Get UserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserName()
    {
        return isset($this->UserName) ? $this->UserName : null;
    }
    /**
     * Set UserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userName
     * @return \patest\StructType\AccessControl_MobileAppJournalEntry
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        if (is_null($userName) || (is_array($userName) && empty($userName))) {
            unset($this->UserName);
        } else {
            $this->UserName = $userName;
        }
        return $this;
    }
}
