<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.MobileAppEvent StructType
 * @subpackage Structs
 */
class AccessControl_MobileAppEvent extends AnyEntity
{
    /**
     * The AccessControlSystemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlSystemId;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The BarcodeRefEntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BarcodeRefEntityId;
    /**
     * The CardData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AccessControl_CardDataToMobileApp
     */
    public $CardData;
    /**
     * The MobileApplicationEvent
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - type: tns:MobileApplicationEvent
     * @var string
     */
    public $MobileApplicationEvent;
    /**
     * The TimestampUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TimestampUtc;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Type;
    /**
     * Constructor method for AccessControl.MobileAppEvent
     * @uses AccessControl_MobileAppEvent::setAccessControlSystemId()
     * @uses AccessControl_MobileAppEvent::setBarcode()
     * @uses AccessControl_MobileAppEvent::setBarcodeRefEntityId()
     * @uses AccessControl_MobileAppEvent::setCardData()
     * @uses AccessControl_MobileAppEvent::setMobileApplicationEvent()
     * @uses AccessControl_MobileAppEvent::setTimestampUtc()
     * @uses AccessControl_MobileAppEvent::setType()
     * @param string $accessControlSystemId
     * @param string $barcode
     * @param string $barcodeRefEntityId
     * @param \patest\StructType\AccessControl_CardDataToMobileApp $cardData
     * @param string $mobileApplicationEvent
     * @param string $timestampUtc
     * @param int $type
     */
    public function __construct($accessControlSystemId = null, $barcode = null, $barcodeRefEntityId = null, \patest\StructType\AccessControl_CardDataToMobileApp $cardData = null, $mobileApplicationEvent = null, $timestampUtc = null, $type = null)
    {
        $this
            ->setAccessControlSystemId($accessControlSystemId)
            ->setBarcode($barcode)
            ->setBarcodeRefEntityId($barcodeRefEntityId)
            ->setCardData($cardData)
            ->setMobileApplicationEvent($mobileApplicationEvent)
            ->setTimestampUtc($timestampUtc)
            ->setType($type);
    }
    /**
     * Get AccessControlSystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemId()
    {
        return isset($this->AccessControlSystemId) ? $this->AccessControlSystemId : null;
    }
    /**
     * Set AccessControlSystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemId
     * @return \patest\StructType\AccessControl_MobileAppEvent
     */
    public function setAccessControlSystemId($accessControlSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemId) && !is_string($accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemId, true), gettype($accessControlSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlSystemId, true)), __LINE__);
        }
        if (is_null($accessControlSystemId) || (is_array($accessControlSystemId) && empty($accessControlSystemId))) {
            unset($this->AccessControlSystemId);
        } else {
            $this->AccessControlSystemId = $accessControlSystemId;
        }
        return $this;
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\AccessControl_MobileAppEvent
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get BarcodeRefEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcodeRefEntityId()
    {
        return isset($this->BarcodeRefEntityId) ? $this->BarcodeRefEntityId : null;
    }
    /**
     * Set BarcodeRefEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcodeRefEntityId
     * @return \patest\StructType\AccessControl_MobileAppEvent
     */
    public function setBarcodeRefEntityId($barcodeRefEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeRefEntityId) && !is_string($barcodeRefEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeRefEntityId, true), gettype($barcodeRefEntityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($barcodeRefEntityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $barcodeRefEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($barcodeRefEntityId, true)), __LINE__);
        }
        if (is_null($barcodeRefEntityId) || (is_array($barcodeRefEntityId) && empty($barcodeRefEntityId))) {
            unset($this->BarcodeRefEntityId);
        } else {
            $this->BarcodeRefEntityId = $barcodeRefEntityId;
        }
        return $this;
    }
    /**
     * Get CardData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AccessControl_CardDataToMobileApp|null
     */
    public function getCardData()
    {
        return isset($this->CardData) ? $this->CardData : null;
    }
    /**
     * Set CardData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AccessControl_CardDataToMobileApp $cardData
     * @return \patest\StructType\AccessControl_MobileAppEvent
     */
    public function setCardData(\patest\StructType\AccessControl_CardDataToMobileApp $cardData = null)
    {
        if (is_null($cardData) || (is_array($cardData) && empty($cardData))) {
            unset($this->CardData);
        } else {
            $this->CardData = $cardData;
        }
        return $this;
    }
    /**
     * Get MobileApplicationEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobileApplicationEvent()
    {
        return isset($this->MobileApplicationEvent) ? $this->MobileApplicationEvent : null;
    }
    /**
     * Set MobileApplicationEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobileApplicationEvent
     * @return \patest\StructType\AccessControl_MobileAppEvent
     */
    public function setMobileApplicationEvent($mobileApplicationEvent = null)
    {
        // validation for constraint: string
        if (!is_null($mobileApplicationEvent) && !is_string($mobileApplicationEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileApplicationEvent, true), gettype($mobileApplicationEvent)), __LINE__);
        }
        if (is_null($mobileApplicationEvent) || (is_array($mobileApplicationEvent) && empty($mobileApplicationEvent))) {
            unset($this->MobileApplicationEvent);
        } else {
            $this->MobileApplicationEvent = $mobileApplicationEvent;
        }
        return $this;
    }
    /**
     * Get TimestampUtc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimestampUtc()
    {
        return isset($this->TimestampUtc) ? $this->TimestampUtc : null;
    }
    /**
     * Set TimestampUtc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timestampUtc
     * @return \patest\StructType\AccessControl_MobileAppEvent
     */
    public function setTimestampUtc($timestampUtc = null)
    {
        // validation for constraint: string
        if (!is_null($timestampUtc) && !is_string($timestampUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestampUtc, true), gettype($timestampUtc)), __LINE__);
        }
        if (is_null($timestampUtc) || (is_array($timestampUtc) && empty($timestampUtc))) {
            unset($this->TimestampUtc);
        } else {
            $this->TimestampUtc = $timestampUtc;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $type
     * @return \patest\StructType\AccessControl_MobileAppEvent
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !(is_int($type) || ctype_digit($type))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
}
