<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.ExternalAccessControlTrafficLogFilter
 * StructType
 * @subpackage Structs
 */
class AccessControl_ExternalAccessControlTrafficLogFilter extends FilterEntity
{
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Action;
    /**
     * The ApiCallName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApiCallName;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Duration;
    /**
     * The IsConnectionError
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsConnectionError;
    /**
     * The IsError
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsError;
    /**
     * The RequestDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestDateFrom;
    /**
     * The RequestDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestDateTo;
    /**
     * Constructor method for AccessControl.ExternalAccessControlTrafficLogFilter
     * @uses AccessControl_ExternalAccessControlTrafficLogFilter::setAction()
     * @uses AccessControl_ExternalAccessControlTrafficLogFilter::setApiCallName()
     * @uses AccessControl_ExternalAccessControlTrafficLogFilter::setDuration()
     * @uses AccessControl_ExternalAccessControlTrafficLogFilter::setIsConnectionError()
     * @uses AccessControl_ExternalAccessControlTrafficLogFilter::setIsError()
     * @uses AccessControl_ExternalAccessControlTrafficLogFilter::setRequestDateFrom()
     * @uses AccessControl_ExternalAccessControlTrafficLogFilter::setRequestDateTo()
     * @param string $action
     * @param string $apiCallName
     * @param int $duration
     * @param bool $isConnectionError
     * @param bool $isError
     * @param string $requestDateFrom
     * @param string $requestDateTo
     */
    public function __construct($action = null, $apiCallName = null, $duration = null, $isConnectionError = null, $isError = null, $requestDateFrom = null, $requestDateTo = null)
    {
        $this
            ->setAction($action)
            ->setApiCallName($apiCallName)
            ->setDuration($duration)
            ->setIsConnectionError($isConnectionError)
            ->setIsError($isError)
            ->setRequestDateFrom($requestDateFrom)
            ->setRequestDateTo($requestDateTo);
    }
    /**
     * Get Action value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAction()
    {
        return isset($this->Action) ? $this->Action : null;
    }
    /**
     * Set Action value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $action
     * @return \patest\StructType\AccessControl_ExternalAccessControlTrafficLogFilter
     */
    public function setAction($action = null)
    {
        // validation for constraint: string
        if (!is_null($action) && !is_string($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($action, true), gettype($action)), __LINE__);
        }
        if (is_null($action) || (is_array($action) && empty($action))) {
            unset($this->Action);
        } else {
            $this->Action = $action;
        }
        return $this;
    }
    /**
     * Get ApiCallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApiCallName()
    {
        return isset($this->ApiCallName) ? $this->ApiCallName : null;
    }
    /**
     * Set ApiCallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apiCallName
     * @return \patest\StructType\AccessControl_ExternalAccessControlTrafficLogFilter
     */
    public function setApiCallName($apiCallName = null)
    {
        // validation for constraint: string
        if (!is_null($apiCallName) && !is_string($apiCallName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apiCallName, true), gettype($apiCallName)), __LINE__);
        }
        if (is_null($apiCallName) || (is_array($apiCallName) && empty($apiCallName))) {
            unset($this->ApiCallName);
        } else {
            $this->ApiCallName = $apiCallName;
        }
        return $this;
    }
    /**
     * Get Duration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDuration()
    {
        return isset($this->Duration) ? $this->Duration : null;
    }
    /**
     * Set Duration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $duration
     * @return \patest\StructType\AccessControl_ExternalAccessControlTrafficLogFilter
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !(is_int($duration) || ctype_digit($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        if (is_null($duration) || (is_array($duration) && empty($duration))) {
            unset($this->Duration);
        } else {
            $this->Duration = $duration;
        }
        return $this;
    }
    /**
     * Get IsConnectionError value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsConnectionError()
    {
        return isset($this->IsConnectionError) ? $this->IsConnectionError : null;
    }
    /**
     * Set IsConnectionError value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isConnectionError
     * @return \patest\StructType\AccessControl_ExternalAccessControlTrafficLogFilter
     */
    public function setIsConnectionError($isConnectionError = null)
    {
        // validation for constraint: boolean
        if (!is_null($isConnectionError) && !is_bool($isConnectionError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isConnectionError, true), gettype($isConnectionError)), __LINE__);
        }
        if (is_null($isConnectionError) || (is_array($isConnectionError) && empty($isConnectionError))) {
            unset($this->IsConnectionError);
        } else {
            $this->IsConnectionError = $isConnectionError;
        }
        return $this;
    }
    /**
     * Get IsError value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsError()
    {
        return isset($this->IsError) ? $this->IsError : null;
    }
    /**
     * Set IsError value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isError
     * @return \patest\StructType\AccessControl_ExternalAccessControlTrafficLogFilter
     */
    public function setIsError($isError = null)
    {
        // validation for constraint: boolean
        if (!is_null($isError) && !is_bool($isError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isError, true), gettype($isError)), __LINE__);
        }
        if (is_null($isError) || (is_array($isError) && empty($isError))) {
            unset($this->IsError);
        } else {
            $this->IsError = $isError;
        }
        return $this;
    }
    /**
     * Get RequestDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestDateFrom()
    {
        return isset($this->RequestDateFrom) ? $this->RequestDateFrom : null;
    }
    /**
     * Set RequestDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestDateFrom
     * @return \patest\StructType\AccessControl_ExternalAccessControlTrafficLogFilter
     */
    public function setRequestDateFrom($requestDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($requestDateFrom) && !is_string($requestDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestDateFrom, true), gettype($requestDateFrom)), __LINE__);
        }
        if (is_null($requestDateFrom) || (is_array($requestDateFrom) && empty($requestDateFrom))) {
            unset($this->RequestDateFrom);
        } else {
            $this->RequestDateFrom = $requestDateFrom;
        }
        return $this;
    }
    /**
     * Get RequestDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestDateTo()
    {
        return isset($this->RequestDateTo) ? $this->RequestDateTo : null;
    }
    /**
     * Set RequestDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestDateTo
     * @return \patest\StructType\AccessControl_ExternalAccessControlTrafficLogFilter
     */
    public function setRequestDateTo($requestDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($requestDateTo) && !is_string($requestDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestDateTo, true), gettype($requestDateTo)), __LINE__);
        }
        if (is_null($requestDateTo) || (is_array($requestDateTo) && empty($requestDateTo))) {
            unset($this->RequestDateTo);
        } else {
            $this->RequestDateTo = $requestDateTo;
        }
        return $this;
    }
}
