<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.ExternalAccessControlTrafficLog StructType
 * @subpackage Structs
 */
class AccessControl_ExternalAccessControlTrafficLog extends PersistableEntity
{
    /**
     * The AccessControlSystemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlSystemId;
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Action;
    /**
     * The ApiCallName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApiCallName;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Duration;
    /**
     * The EndPointUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndPointUrl;
    /**
     * The InitiatedByUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InitiatedByUserId;
    /**
     * The IsConnectionError
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsConnectionError;
    /**
     * The IsError
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsError;
    /**
     * The RequestDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestDate;
    /**
     * The RequestMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestMessage;
    /**
     * The ResponseDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResponseDate;
    /**
     * The ResponseMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResponseMessage;
    /**
     * Constructor method for AccessControl.ExternalAccessControlTrafficLog
     * @uses AccessControl_ExternalAccessControlTrafficLog::setAccessControlSystemId()
     * @uses AccessControl_ExternalAccessControlTrafficLog::setAction()
     * @uses AccessControl_ExternalAccessControlTrafficLog::setApiCallName()
     * @uses AccessControl_ExternalAccessControlTrafficLog::setDuration()
     * @uses AccessControl_ExternalAccessControlTrafficLog::setEndPointUrl()
     * @uses AccessControl_ExternalAccessControlTrafficLog::setInitiatedByUserId()
     * @uses AccessControl_ExternalAccessControlTrafficLog::setIsConnectionError()
     * @uses AccessControl_ExternalAccessControlTrafficLog::setIsError()
     * @uses AccessControl_ExternalAccessControlTrafficLog::setRequestDate()
     * @uses AccessControl_ExternalAccessControlTrafficLog::setRequestMessage()
     * @uses AccessControl_ExternalAccessControlTrafficLog::setResponseDate()
     * @uses AccessControl_ExternalAccessControlTrafficLog::setResponseMessage()
     * @param string $accessControlSystemId
     * @param string $action
     * @param string $apiCallName
     * @param int $duration
     * @param string $endPointUrl
     * @param string $initiatedByUserId
     * @param bool $isConnectionError
     * @param bool $isError
     * @param string $requestDate
     * @param string $requestMessage
     * @param string $responseDate
     * @param string $responseMessage
     */
    public function __construct($accessControlSystemId = null, $action = null, $apiCallName = null, $duration = null, $endPointUrl = null, $initiatedByUserId = null, $isConnectionError = null, $isError = null, $requestDate = null, $requestMessage = null, $responseDate = null, $responseMessage = null)
    {
        $this
            ->setAccessControlSystemId($accessControlSystemId)
            ->setAction($action)
            ->setApiCallName($apiCallName)
            ->setDuration($duration)
            ->setEndPointUrl($endPointUrl)
            ->setInitiatedByUserId($initiatedByUserId)
            ->setIsConnectionError($isConnectionError)
            ->setIsError($isError)
            ->setRequestDate($requestDate)
            ->setRequestMessage($requestMessage)
            ->setResponseDate($responseDate)
            ->setResponseMessage($responseMessage);
    }
    /**
     * Get AccessControlSystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemId()
    {
        return isset($this->AccessControlSystemId) ? $this->AccessControlSystemId : null;
    }
    /**
     * Set AccessControlSystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemId
     * @return \patest\StructType\AccessControl_ExternalAccessControlTrafficLog
     */
    public function setAccessControlSystemId($accessControlSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemId) && !is_string($accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemId, true), gettype($accessControlSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlSystemId, true)), __LINE__);
        }
        if (is_null($accessControlSystemId) || (is_array($accessControlSystemId) && empty($accessControlSystemId))) {
            unset($this->AccessControlSystemId);
        } else {
            $this->AccessControlSystemId = $accessControlSystemId;
        }
        return $this;
    }
    /**
     * Get Action value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAction()
    {
        return isset($this->Action) ? $this->Action : null;
    }
    /**
     * Set Action value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $action
     * @return \patest\StructType\AccessControl_ExternalAccessControlTrafficLog
     */
    public function setAction($action = null)
    {
        // validation for constraint: string
        if (!is_null($action) && !is_string($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($action, true), gettype($action)), __LINE__);
        }
        if (is_null($action) || (is_array($action) && empty($action))) {
            unset($this->Action);
        } else {
            $this->Action = $action;
        }
        return $this;
    }
    /**
     * Get ApiCallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApiCallName()
    {
        return isset($this->ApiCallName) ? $this->ApiCallName : null;
    }
    /**
     * Set ApiCallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apiCallName
     * @return \patest\StructType\AccessControl_ExternalAccessControlTrafficLog
     */
    public function setApiCallName($apiCallName = null)
    {
        // validation for constraint: string
        if (!is_null($apiCallName) && !is_string($apiCallName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apiCallName, true), gettype($apiCallName)), __LINE__);
        }
        if (is_null($apiCallName) || (is_array($apiCallName) && empty($apiCallName))) {
            unset($this->ApiCallName);
        } else {
            $this->ApiCallName = $apiCallName;
        }
        return $this;
    }
    /**
     * Get Duration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDuration()
    {
        return isset($this->Duration) ? $this->Duration : null;
    }
    /**
     * Set Duration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $duration
     * @return \patest\StructType\AccessControl_ExternalAccessControlTrafficLog
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !(is_int($duration) || ctype_digit($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        if (is_null($duration) || (is_array($duration) && empty($duration))) {
            unset($this->Duration);
        } else {
            $this->Duration = $duration;
        }
        return $this;
    }
    /**
     * Get EndPointUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndPointUrl()
    {
        return isset($this->EndPointUrl) ? $this->EndPointUrl : null;
    }
    /**
     * Set EndPointUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endPointUrl
     * @return \patest\StructType\AccessControl_ExternalAccessControlTrafficLog
     */
    public function setEndPointUrl($endPointUrl = null)
    {
        // validation for constraint: string
        if (!is_null($endPointUrl) && !is_string($endPointUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endPointUrl, true), gettype($endPointUrl)), __LINE__);
        }
        if (is_null($endPointUrl) || (is_array($endPointUrl) && empty($endPointUrl))) {
            unset($this->EndPointUrl);
        } else {
            $this->EndPointUrl = $endPointUrl;
        }
        return $this;
    }
    /**
     * Get InitiatedByUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInitiatedByUserId()
    {
        return isset($this->InitiatedByUserId) ? $this->InitiatedByUserId : null;
    }
    /**
     * Set InitiatedByUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $initiatedByUserId
     * @return \patest\StructType\AccessControl_ExternalAccessControlTrafficLog
     */
    public function setInitiatedByUserId($initiatedByUserId = null)
    {
        // validation for constraint: string
        if (!is_null($initiatedByUserId) && !is_string($initiatedByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($initiatedByUserId, true), gettype($initiatedByUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($initiatedByUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $initiatedByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($initiatedByUserId, true)), __LINE__);
        }
        if (is_null($initiatedByUserId) || (is_array($initiatedByUserId) && empty($initiatedByUserId))) {
            unset($this->InitiatedByUserId);
        } else {
            $this->InitiatedByUserId = $initiatedByUserId;
        }
        return $this;
    }
    /**
     * Get IsConnectionError value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsConnectionError()
    {
        return isset($this->IsConnectionError) ? $this->IsConnectionError : null;
    }
    /**
     * Set IsConnectionError value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isConnectionError
     * @return \patest\StructType\AccessControl_ExternalAccessControlTrafficLog
     */
    public function setIsConnectionError($isConnectionError = null)
    {
        // validation for constraint: boolean
        if (!is_null($isConnectionError) && !is_bool($isConnectionError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isConnectionError, true), gettype($isConnectionError)), __LINE__);
        }
        if (is_null($isConnectionError) || (is_array($isConnectionError) && empty($isConnectionError))) {
            unset($this->IsConnectionError);
        } else {
            $this->IsConnectionError = $isConnectionError;
        }
        return $this;
    }
    /**
     * Get IsError value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsError()
    {
        return isset($this->IsError) ? $this->IsError : null;
    }
    /**
     * Set IsError value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isError
     * @return \patest\StructType\AccessControl_ExternalAccessControlTrafficLog
     */
    public function setIsError($isError = null)
    {
        // validation for constraint: boolean
        if (!is_null($isError) && !is_bool($isError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isError, true), gettype($isError)), __LINE__);
        }
        if (is_null($isError) || (is_array($isError) && empty($isError))) {
            unset($this->IsError);
        } else {
            $this->IsError = $isError;
        }
        return $this;
    }
    /**
     * Get RequestDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestDate()
    {
        return isset($this->RequestDate) ? $this->RequestDate : null;
    }
    /**
     * Set RequestDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestDate
     * @return \patest\StructType\AccessControl_ExternalAccessControlTrafficLog
     */
    public function setRequestDate($requestDate = null)
    {
        // validation for constraint: string
        if (!is_null($requestDate) && !is_string($requestDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestDate, true), gettype($requestDate)), __LINE__);
        }
        if (is_null($requestDate) || (is_array($requestDate) && empty($requestDate))) {
            unset($this->RequestDate);
        } else {
            $this->RequestDate = $requestDate;
        }
        return $this;
    }
    /**
     * Get RequestMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestMessage()
    {
        return isset($this->RequestMessage) ? $this->RequestMessage : null;
    }
    /**
     * Set RequestMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestMessage
     * @return \patest\StructType\AccessControl_ExternalAccessControlTrafficLog
     */
    public function setRequestMessage($requestMessage = null)
    {
        // validation for constraint: string
        if (!is_null($requestMessage) && !is_string($requestMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestMessage, true), gettype($requestMessage)), __LINE__);
        }
        if (is_null($requestMessage) || (is_array($requestMessage) && empty($requestMessage))) {
            unset($this->RequestMessage);
        } else {
            $this->RequestMessage = $requestMessage;
        }
        return $this;
    }
    /**
     * Get ResponseDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResponseDate()
    {
        return isset($this->ResponseDate) ? $this->ResponseDate : null;
    }
    /**
     * Set ResponseDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $responseDate
     * @return \patest\StructType\AccessControl_ExternalAccessControlTrafficLog
     */
    public function setResponseDate($responseDate = null)
    {
        // validation for constraint: string
        if (!is_null($responseDate) && !is_string($responseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseDate, true), gettype($responseDate)), __LINE__);
        }
        if (is_null($responseDate) || (is_array($responseDate) && empty($responseDate))) {
            unset($this->ResponseDate);
        } else {
            $this->ResponseDate = $responseDate;
        }
        return $this;
    }
    /**
     * Get ResponseMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResponseMessage()
    {
        return isset($this->ResponseMessage) ? $this->ResponseMessage : null;
    }
    /**
     * Set ResponseMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $responseMessage
     * @return \patest\StructType\AccessControl_ExternalAccessControlTrafficLog
     */
    public function setResponseMessage($responseMessage = null)
    {
        // validation for constraint: string
        if (!is_null($responseMessage) && !is_string($responseMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseMessage, true), gettype($responseMessage)), __LINE__);
        }
        if (is_null($responseMessage) || (is_array($responseMessage) && empty($responseMessage))) {
            unset($this->ResponseMessage);
        } else {
            $this->ResponseMessage = $responseMessage;
        }
        return $this;
    }
}
