<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.BarcodeInfo.Base StructType
 * @subpackage Structs
 */
class AccessControl_BarcodeInfo_Base extends AnyEntity
{
    /**
     * The AllowedEntriesCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AllowedEntriesCount;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The BarcodeRefEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BarcodeRefEntityName;
    /**
     * The CancelDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CancelDate;
    /**
     * The CancelReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $CancelReason;
    /**
     * The ClientLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ClientLocalId;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The CustomerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomerName;
    /**
     * The CustomerPictureUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomerPictureUrl;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsFirstEntry
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFirstEntry;
    /**
     * The LastEntryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastEntryDate;
    /**
     * The LastEntryScanningLocation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $LastEntryScanningLocation;
    /**
     * The PriceLevelName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PriceLevelName;
    /**
     * The PriceTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PriceTypeName;
    /**
     * The RequiresMoreData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $RequiresMoreData;
    /**
     * The ScanningLocation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ScanningLocation;
    /**
     * The ScreenTemplate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ScreenTemplate;
    /**
     * The ValidityDates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfAccessControl_BarcodeValidityDates
     */
    public $ValidityDates;
    /**
     * The ValidityDatesSummary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidityDatesSummary;
    /**
     * Constructor method for AccessControl.BarcodeInfo.Base
     * @uses AccessControl_BarcodeInfo_Base::setAllowedEntriesCount()
     * @uses AccessControl_BarcodeInfo_Base::setBarcode()
     * @uses AccessControl_BarcodeInfo_Base::setBarcodeRefEntityName()
     * @uses AccessControl_BarcodeInfo_Base::setCancelDate()
     * @uses AccessControl_BarcodeInfo_Base::setCancelReason()
     * @uses AccessControl_BarcodeInfo_Base::setClientLocalId()
     * @uses AccessControl_BarcodeInfo_Base::setCreationDate()
     * @uses AccessControl_BarcodeInfo_Base::setCustomerName()
     * @uses AccessControl_BarcodeInfo_Base::setCustomerPictureUrl()
     * @uses AccessControl_BarcodeInfo_Base::setIsActive()
     * @uses AccessControl_BarcodeInfo_Base::setIsFirstEntry()
     * @uses AccessControl_BarcodeInfo_Base::setLastEntryDate()
     * @uses AccessControl_BarcodeInfo_Base::setLastEntryScanningLocation()
     * @uses AccessControl_BarcodeInfo_Base::setPriceLevelName()
     * @uses AccessControl_BarcodeInfo_Base::setPriceTypeName()
     * @uses AccessControl_BarcodeInfo_Base::setRequiresMoreData()
     * @uses AccessControl_BarcodeInfo_Base::setScanningLocation()
     * @uses AccessControl_BarcodeInfo_Base::setScreenTemplate()
     * @uses AccessControl_BarcodeInfo_Base::setValidityDates()
     * @uses AccessControl_BarcodeInfo_Base::setValidityDatesSummary()
     * @param int $allowedEntriesCount
     * @param string $barcode
     * @param string $barcodeRefEntityName
     * @param string $cancelDate
     * @param \patest\StructType\GlobalString $cancelReason
     * @param int $clientLocalId
     * @param string $creationDate
     * @param string $customerName
     * @param string $customerPictureUrl
     * @param bool $isActive
     * @param bool $isFirstEntry
     * @param string $lastEntryDate
     * @param \patest\StructType\GlobalString $lastEntryScanningLocation
     * @param \patest\StructType\GlobalString $priceLevelName
     * @param \patest\StructType\GlobalString $priceTypeName
     * @param bool $requiresMoreData
     * @param \patest\StructType\GlobalString $scanningLocation
     * @param string $screenTemplate
     * @param \patest\StructType\RecordSetOfAccessControl_BarcodeValidityDates $validityDates
     * @param string $validityDatesSummary
     */
    public function __construct($allowedEntriesCount = null, $barcode = null, $barcodeRefEntityName = null, $cancelDate = null, \patest\StructType\GlobalString $cancelReason = null, $clientLocalId = null, $creationDate = null, $customerName = null, $customerPictureUrl = null, $isActive = null, $isFirstEntry = null, $lastEntryDate = null, \patest\StructType\GlobalString $lastEntryScanningLocation = null, \patest\StructType\GlobalString $priceLevelName = null, \patest\StructType\GlobalString $priceTypeName = null, $requiresMoreData = null, \patest\StructType\GlobalString $scanningLocation = null, $screenTemplate = null, \patest\StructType\RecordSetOfAccessControl_BarcodeValidityDates $validityDates = null, $validityDatesSummary = null)
    {
        $this
            ->setAllowedEntriesCount($allowedEntriesCount)
            ->setBarcode($barcode)
            ->setBarcodeRefEntityName($barcodeRefEntityName)
            ->setCancelDate($cancelDate)
            ->setCancelReason($cancelReason)
            ->setClientLocalId($clientLocalId)
            ->setCreationDate($creationDate)
            ->setCustomerName($customerName)
            ->setCustomerPictureUrl($customerPictureUrl)
            ->setIsActive($isActive)
            ->setIsFirstEntry($isFirstEntry)
            ->setLastEntryDate($lastEntryDate)
            ->setLastEntryScanningLocation($lastEntryScanningLocation)
            ->setPriceLevelName($priceLevelName)
            ->setPriceTypeName($priceTypeName)
            ->setRequiresMoreData($requiresMoreData)
            ->setScanningLocation($scanningLocation)
            ->setScreenTemplate($screenTemplate)
            ->setValidityDates($validityDates)
            ->setValidityDatesSummary($validityDatesSummary);
    }
    /**
     * Get AllowedEntriesCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAllowedEntriesCount()
    {
        return isset($this->AllowedEntriesCount) ? $this->AllowedEntriesCount : null;
    }
    /**
     * Set AllowedEntriesCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $allowedEntriesCount
     * @return \patest\StructType\AccessControl_BarcodeInfo_Base
     */
    public function setAllowedEntriesCount($allowedEntriesCount = null)
    {
        // validation for constraint: int
        if (!is_null($allowedEntriesCount) && !(is_int($allowedEntriesCount) || ctype_digit($allowedEntriesCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($allowedEntriesCount, true), gettype($allowedEntriesCount)), __LINE__);
        }
        if (is_null($allowedEntriesCount) || (is_array($allowedEntriesCount) && empty($allowedEntriesCount))) {
            unset($this->AllowedEntriesCount);
        } else {
            $this->AllowedEntriesCount = $allowedEntriesCount;
        }
        return $this;
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\AccessControl_BarcodeInfo_Base
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get BarcodeRefEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcodeRefEntityName()
    {
        return isset($this->BarcodeRefEntityName) ? $this->BarcodeRefEntityName : null;
    }
    /**
     * Set BarcodeRefEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcodeRefEntityName
     * @return \patest\StructType\AccessControl_BarcodeInfo_Base
     */
    public function setBarcodeRefEntityName($barcodeRefEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeRefEntityName) && !is_string($barcodeRefEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeRefEntityName, true), gettype($barcodeRefEntityName)), __LINE__);
        }
        if (is_null($barcodeRefEntityName) || (is_array($barcodeRefEntityName) && empty($barcodeRefEntityName))) {
            unset($this->BarcodeRefEntityName);
        } else {
            $this->BarcodeRefEntityName = $barcodeRefEntityName;
        }
        return $this;
    }
    /**
     * Get CancelDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCancelDate()
    {
        return isset($this->CancelDate) ? $this->CancelDate : null;
    }
    /**
     * Set CancelDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cancelDate
     * @return \patest\StructType\AccessControl_BarcodeInfo_Base
     */
    public function setCancelDate($cancelDate = null)
    {
        // validation for constraint: string
        if (!is_null($cancelDate) && !is_string($cancelDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancelDate, true), gettype($cancelDate)), __LINE__);
        }
        if (is_null($cancelDate) || (is_array($cancelDate) && empty($cancelDate))) {
            unset($this->CancelDate);
        } else {
            $this->CancelDate = $cancelDate;
        }
        return $this;
    }
    /**
     * Get CancelReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getCancelReason()
    {
        return isset($this->CancelReason) ? $this->CancelReason : null;
    }
    /**
     * Set CancelReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $cancelReason
     * @return \patest\StructType\AccessControl_BarcodeInfo_Base
     */
    public function setCancelReason(\patest\StructType\GlobalString $cancelReason = null)
    {
        if (is_null($cancelReason) || (is_array($cancelReason) && empty($cancelReason))) {
            unset($this->CancelReason);
        } else {
            $this->CancelReason = $cancelReason;
        }
        return $this;
    }
    /**
     * Get ClientLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getClientLocalId()
    {
        return isset($this->ClientLocalId) ? $this->ClientLocalId : null;
    }
    /**
     * Set ClientLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $clientLocalId
     * @return \patest\StructType\AccessControl_BarcodeInfo_Base
     */
    public function setClientLocalId($clientLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($clientLocalId) && !(is_int($clientLocalId) || ctype_digit($clientLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clientLocalId, true), gettype($clientLocalId)), __LINE__);
        }
        if (is_null($clientLocalId) || (is_array($clientLocalId) && empty($clientLocalId))) {
            unset($this->ClientLocalId);
        } else {
            $this->ClientLocalId = $clientLocalId;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\AccessControl_BarcodeInfo_Base
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get CustomerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerName()
    {
        return isset($this->CustomerName) ? $this->CustomerName : null;
    }
    /**
     * Set CustomerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerName
     * @return \patest\StructType\AccessControl_BarcodeInfo_Base
     */
    public function setCustomerName($customerName = null)
    {
        // validation for constraint: string
        if (!is_null($customerName) && !is_string($customerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerName, true), gettype($customerName)), __LINE__);
        }
        if (is_null($customerName) || (is_array($customerName) && empty($customerName))) {
            unset($this->CustomerName);
        } else {
            $this->CustomerName = $customerName;
        }
        return $this;
    }
    /**
     * Get CustomerPictureUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerPictureUrl()
    {
        return isset($this->CustomerPictureUrl) ? $this->CustomerPictureUrl : null;
    }
    /**
     * Set CustomerPictureUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerPictureUrl
     * @return \patest\StructType\AccessControl_BarcodeInfo_Base
     */
    public function setCustomerPictureUrl($customerPictureUrl = null)
    {
        // validation for constraint: string
        if (!is_null($customerPictureUrl) && !is_string($customerPictureUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerPictureUrl, true), gettype($customerPictureUrl)), __LINE__);
        }
        if (is_null($customerPictureUrl) || (is_array($customerPictureUrl) && empty($customerPictureUrl))) {
            unset($this->CustomerPictureUrl);
        } else {
            $this->CustomerPictureUrl = $customerPictureUrl;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\AccessControl_BarcodeInfo_Base
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsFirstEntry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFirstEntry()
    {
        return isset($this->IsFirstEntry) ? $this->IsFirstEntry : null;
    }
    /**
     * Set IsFirstEntry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFirstEntry
     * @return \patest\StructType\AccessControl_BarcodeInfo_Base
     */
    public function setIsFirstEntry($isFirstEntry = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFirstEntry) && !is_bool($isFirstEntry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFirstEntry, true), gettype($isFirstEntry)), __LINE__);
        }
        if (is_null($isFirstEntry) || (is_array($isFirstEntry) && empty($isFirstEntry))) {
            unset($this->IsFirstEntry);
        } else {
            $this->IsFirstEntry = $isFirstEntry;
        }
        return $this;
    }
    /**
     * Get LastEntryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastEntryDate()
    {
        return isset($this->LastEntryDate) ? $this->LastEntryDate : null;
    }
    /**
     * Set LastEntryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastEntryDate
     * @return \patest\StructType\AccessControl_BarcodeInfo_Base
     */
    public function setLastEntryDate($lastEntryDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastEntryDate) && !is_string($lastEntryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastEntryDate, true), gettype($lastEntryDate)), __LINE__);
        }
        if (is_null($lastEntryDate) || (is_array($lastEntryDate) && empty($lastEntryDate))) {
            unset($this->LastEntryDate);
        } else {
            $this->LastEntryDate = $lastEntryDate;
        }
        return $this;
    }
    /**
     * Get LastEntryScanningLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getLastEntryScanningLocation()
    {
        return isset($this->LastEntryScanningLocation) ? $this->LastEntryScanningLocation : null;
    }
    /**
     * Set LastEntryScanningLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $lastEntryScanningLocation
     * @return \patest\StructType\AccessControl_BarcodeInfo_Base
     */
    public function setLastEntryScanningLocation(\patest\StructType\GlobalString $lastEntryScanningLocation = null)
    {
        if (is_null($lastEntryScanningLocation) || (is_array($lastEntryScanningLocation) && empty($lastEntryScanningLocation))) {
            unset($this->LastEntryScanningLocation);
        } else {
            $this->LastEntryScanningLocation = $lastEntryScanningLocation;
        }
        return $this;
    }
    /**
     * Get PriceLevelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPriceLevelName()
    {
        return isset($this->PriceLevelName) ? $this->PriceLevelName : null;
    }
    /**
     * Set PriceLevelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $priceLevelName
     * @return \patest\StructType\AccessControl_BarcodeInfo_Base
     */
    public function setPriceLevelName(\patest\StructType\GlobalString $priceLevelName = null)
    {
        if (is_null($priceLevelName) || (is_array($priceLevelName) && empty($priceLevelName))) {
            unset($this->PriceLevelName);
        } else {
            $this->PriceLevelName = $priceLevelName;
        }
        return $this;
    }
    /**
     * Get PriceTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPriceTypeName()
    {
        return isset($this->PriceTypeName) ? $this->PriceTypeName : null;
    }
    /**
     * Set PriceTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $priceTypeName
     * @return \patest\StructType\AccessControl_BarcodeInfo_Base
     */
    public function setPriceTypeName(\patest\StructType\GlobalString $priceTypeName = null)
    {
        if (is_null($priceTypeName) || (is_array($priceTypeName) && empty($priceTypeName))) {
            unset($this->PriceTypeName);
        } else {
            $this->PriceTypeName = $priceTypeName;
        }
        return $this;
    }
    /**
     * Get RequiresMoreData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRequiresMoreData()
    {
        return isset($this->RequiresMoreData) ? $this->RequiresMoreData : null;
    }
    /**
     * Set RequiresMoreData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $requiresMoreData
     * @return \patest\StructType\AccessControl_BarcodeInfo_Base
     */
    public function setRequiresMoreData($requiresMoreData = null)
    {
        // validation for constraint: boolean
        if (!is_null($requiresMoreData) && !is_bool($requiresMoreData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($requiresMoreData, true), gettype($requiresMoreData)), __LINE__);
        }
        if (is_null($requiresMoreData) || (is_array($requiresMoreData) && empty($requiresMoreData))) {
            unset($this->RequiresMoreData);
        } else {
            $this->RequiresMoreData = $requiresMoreData;
        }
        return $this;
    }
    /**
     * Get ScanningLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getScanningLocation()
    {
        return isset($this->ScanningLocation) ? $this->ScanningLocation : null;
    }
    /**
     * Set ScanningLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $scanningLocation
     * @return \patest\StructType\AccessControl_BarcodeInfo_Base
     */
    public function setScanningLocation(\patest\StructType\GlobalString $scanningLocation = null)
    {
        if (is_null($scanningLocation) || (is_array($scanningLocation) && empty($scanningLocation))) {
            unset($this->ScanningLocation);
        } else {
            $this->ScanningLocation = $scanningLocation;
        }
        return $this;
    }
    /**
     * Get ScreenTemplate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScreenTemplate()
    {
        return isset($this->ScreenTemplate) ? $this->ScreenTemplate : null;
    }
    /**
     * Set ScreenTemplate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $screenTemplate
     * @return \patest\StructType\AccessControl_BarcodeInfo_Base
     */
    public function setScreenTemplate($screenTemplate = null)
    {
        // validation for constraint: string
        if (!is_null($screenTemplate) && !is_string($screenTemplate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($screenTemplate, true), gettype($screenTemplate)), __LINE__);
        }
        if (is_null($screenTemplate) || (is_array($screenTemplate) && empty($screenTemplate))) {
            unset($this->ScreenTemplate);
        } else {
            $this->ScreenTemplate = $screenTemplate;
        }
        return $this;
    }
    /**
     * Get ValidityDates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfAccessControl_BarcodeValidityDates|null
     */
    public function getValidityDates()
    {
        return isset($this->ValidityDates) ? $this->ValidityDates : null;
    }
    /**
     * Set ValidityDates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfAccessControl_BarcodeValidityDates $validityDates
     * @return \patest\StructType\AccessControl_BarcodeInfo_Base
     */
    public function setValidityDates(\patest\StructType\RecordSetOfAccessControl_BarcodeValidityDates $validityDates = null)
    {
        if (is_null($validityDates) || (is_array($validityDates) && empty($validityDates))) {
            unset($this->ValidityDates);
        } else {
            $this->ValidityDates = $validityDates;
        }
        return $this;
    }
    /**
     * Get ValidityDatesSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidityDatesSummary()
    {
        return isset($this->ValidityDatesSummary) ? $this->ValidityDatesSummary : null;
    }
    /**
     * Set ValidityDatesSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validityDatesSummary
     * @return \patest\StructType\AccessControl_BarcodeInfo_Base
     */
    public function setValidityDatesSummary($validityDatesSummary = null)
    {
        // validation for constraint: string
        if (!is_null($validityDatesSummary) && !is_string($validityDatesSummary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validityDatesSummary, true), gettype($validityDatesSummary)), __LINE__);
        }
        if (is_null($validityDatesSummary) || (is_array($validityDatesSummary) && empty($validityDatesSummary))) {
            unset($this->ValidityDatesSummary);
        } else {
            $this->ValidityDatesSummary = $validityDatesSummary;
        }
        return $this;
    }
}
