<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.BarcodeGeneratorConfig.RandomNumber
 * StructType
 * @subpackage Structs
 */
class AccessControl_BarcodeGeneratorConfig_RandomNumber extends AccessControl_BarcodeGeneratorConfig_BaseEntity
{
    /**
     * The BarcodeLength
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BarcodeLength;
    /**
     * The EmbedTicketInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EmbedTicketInfo;
    /**
     * Constructor method for AccessControl.BarcodeGeneratorConfig.RandomNumber
     * @uses AccessControl_BarcodeGeneratorConfig_RandomNumber::setBarcodeLength()
     * @uses AccessControl_BarcodeGeneratorConfig_RandomNumber::setEmbedTicketInfo()
     * @param int $barcodeLength
     * @param bool $embedTicketInfo
     */
    public function __construct($barcodeLength = null, $embedTicketInfo = null)
    {
        $this
            ->setBarcodeLength($barcodeLength)
            ->setEmbedTicketInfo($embedTicketInfo);
    }
    /**
     * Get BarcodeLength value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBarcodeLength()
    {
        return isset($this->BarcodeLength) ? $this->BarcodeLength : null;
    }
    /**
     * Set BarcodeLength value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $barcodeLength
     * @return \patest\StructType\AccessControl_BarcodeGeneratorConfig_RandomNumber
     */
    public function setBarcodeLength($barcodeLength = null)
    {
        // validation for constraint: int
        if (!is_null($barcodeLength) && !(is_int($barcodeLength) || ctype_digit($barcodeLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($barcodeLength, true), gettype($barcodeLength)), __LINE__);
        }
        if (is_null($barcodeLength) || (is_array($barcodeLength) && empty($barcodeLength))) {
            unset($this->BarcodeLength);
        } else {
            $this->BarcodeLength = $barcodeLength;
        }
        return $this;
    }
    /**
     * Get EmbedTicketInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEmbedTicketInfo()
    {
        return isset($this->EmbedTicketInfo) ? $this->EmbedTicketInfo : null;
    }
    /**
     * Set EmbedTicketInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $embedTicketInfo
     * @return \patest\StructType\AccessControl_BarcodeGeneratorConfig_RandomNumber
     */
    public function setEmbedTicketInfo($embedTicketInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($embedTicketInfo) && !is_bool($embedTicketInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($embedTicketInfo, true), gettype($embedTicketInfo)), __LINE__);
        }
        if (is_null($embedTicketInfo) || (is_array($embedTicketInfo) && empty($embedTicketInfo))) {
            unset($this->EmbedTicketInfo);
        } else {
            $this->EmbedTicketInfo = $embedTicketInfo;
        }
        return $this;
    }
}
