<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.AccessCardExtended StructType
 * @subpackage Structs
 */
class AccessControl_AccessCardExtended extends AccessControl_AccessCard
{
    /**
     * The AccessControlProviderId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessControlProviderId;
    /**
     * The CommitDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommitDate;
    /**
     * The IsStandaloneReprintAllowed
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsStandaloneReprintAllowed;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * Constructor method for AccessControl.AccessCardExtended
     * @uses AccessControl_AccessCardExtended::setAccessControlProviderId()
     * @uses AccessControl_AccessCardExtended::setCommitDate()
     * @uses AccessControl_AccessCardExtended::setIsStandaloneReprintAllowed()
     * @uses AccessControl_AccessCardExtended::setTransactionNumber()
     * @uses AccessControl_AccessCardExtended::setUserName()
     * @param string $accessControlProviderId
     * @param string $commitDate
     * @param bool $isStandaloneReprintAllowed
     * @param int $transactionNumber
     * @param string $userName
     */
    public function __construct($accessControlProviderId = null, $commitDate = null, $isStandaloneReprintAllowed = null, $transactionNumber = null, $userName = null)
    {
        $this
            ->setAccessControlProviderId($accessControlProviderId)
            ->setCommitDate($commitDate)
            ->setIsStandaloneReprintAllowed($isStandaloneReprintAllowed)
            ->setTransactionNumber($transactionNumber)
            ->setUserName($userName);
    }
    /**
     * Get AccessControlProviderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlProviderId()
    {
        return isset($this->AccessControlProviderId) ? $this->AccessControlProviderId : null;
    }
    /**
     * Set AccessControlProviderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlProviderId
     * @return \patest\StructType\AccessControl_AccessCardExtended
     */
    public function setAccessControlProviderId($accessControlProviderId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlProviderId) && !is_string($accessControlProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlProviderId, true), gettype($accessControlProviderId)), __LINE__);
        }
        if (is_null($accessControlProviderId) || (is_array($accessControlProviderId) && empty($accessControlProviderId))) {
            unset($this->AccessControlProviderId);
        } else {
            $this->AccessControlProviderId = $accessControlProviderId;
        }
        return $this;
    }
    /**
     * Get CommitDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommitDate()
    {
        return isset($this->CommitDate) ? $this->CommitDate : null;
    }
    /**
     * Set CommitDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commitDate
     * @return \patest\StructType\AccessControl_AccessCardExtended
     */
    public function setCommitDate($commitDate = null)
    {
        // validation for constraint: string
        if (!is_null($commitDate) && !is_string($commitDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commitDate, true), gettype($commitDate)), __LINE__);
        }
        if (is_null($commitDate) || (is_array($commitDate) && empty($commitDate))) {
            unset($this->CommitDate);
        } else {
            $this->CommitDate = $commitDate;
        }
        return $this;
    }
    /**
     * Get IsStandaloneReprintAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsStandaloneReprintAllowed()
    {
        return isset($this->IsStandaloneReprintAllowed) ? $this->IsStandaloneReprintAllowed : null;
    }
    /**
     * Set IsStandaloneReprintAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isStandaloneReprintAllowed
     * @return \patest\StructType\AccessControl_AccessCardExtended
     */
    public function setIsStandaloneReprintAllowed($isStandaloneReprintAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isStandaloneReprintAllowed) && !is_bool($isStandaloneReprintAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isStandaloneReprintAllowed, true), gettype($isStandaloneReprintAllowed)), __LINE__);
        }
        if (is_null($isStandaloneReprintAllowed) || (is_array($isStandaloneReprintAllowed) && empty($isStandaloneReprintAllowed))) {
            unset($this->IsStandaloneReprintAllowed);
        } else {
            $this->IsStandaloneReprintAllowed = $isStandaloneReprintAllowed;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\AccessControl_AccessCardExtended
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get UserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserName()
    {
        return isset($this->UserName) ? $this->UserName : null;
    }
    /**
     * Set UserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userName
     * @return \patest\StructType\AccessControl_AccessCardExtended
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        if (is_null($userName) || (is_array($userName) && empty($userName))) {
            unset($this->UserName);
        } else {
            $this->UserName = $userName;
        }
        return $this;
    }
}
