<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.AccessCard StructType
 * @subpackage Structs
 */
class AccessControl_AccessCard extends PersistableEntity
{
    /**
     * The AccessControlSystemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlSystemId;
    /**
     * The AccessControlSystemMemberId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlSystemMemberId;
    /**
     * The AccessControlSystemMemberRealId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessControlSystemMemberRealId;
    /**
     * The ActiveActivations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfAccessControl_ActiveAccessCardActivation
     */
    public $ActiveActivations;
    /**
     * The ActiveProducts
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActiveProducts;
    /**
     * The CardName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $CardName;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * The CardType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardType;
    /**
     * The CardTypeName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $CardTypeName;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The IsDedicated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDedicated;
    /**
     * The OwnerClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerClientId;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * The ValidFromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidFromDate;
    /**
     * The ValidToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidToDate;
    /**
     * Constructor method for AccessControl.AccessCard
     * @uses AccessControl_AccessCard::setAccessControlSystemId()
     * @uses AccessControl_AccessCard::setAccessControlSystemMemberId()
     * @uses AccessControl_AccessCard::setAccessControlSystemMemberRealId()
     * @uses AccessControl_AccessCard::setActiveActivations()
     * @uses AccessControl_AccessCard::setActiveProducts()
     * @uses AccessControl_AccessCard::setCardName()
     * @uses AccessControl_AccessCard::setCardNumber()
     * @uses AccessControl_AccessCard::setCardType()
     * @uses AccessControl_AccessCard::setCardTypeName()
     * @uses AccessControl_AccessCard::setClientId()
     * @uses AccessControl_AccessCard::setCreationDate()
     * @uses AccessControl_AccessCard::setIsDedicated()
     * @uses AccessControl_AccessCard::setOwnerClientId()
     * @uses AccessControl_AccessCard::setPriceTypeId()
     * @uses AccessControl_AccessCard::setStatus()
     * @uses AccessControl_AccessCard::setTransactionId()
     * @uses AccessControl_AccessCard::setValidFromDate()
     * @uses AccessControl_AccessCard::setValidToDate()
     * @param string $accessControlSystemId
     * @param string $accessControlSystemMemberId
     * @param string $accessControlSystemMemberRealId
     * @param \patest\StructType\RecordSetOfAccessControl_ActiveAccessCardActivation $activeActivations
     * @param string $activeProducts
     * @param \patest\StructType\GlobalString $cardName
     * @param string $cardNumber
     * @param string $cardType
     * @param \patest\StructType\GlobalString $cardTypeName
     * @param string $clientId
     * @param string $creationDate
     * @param bool $isDedicated
     * @param string $ownerClientId
     * @param string $priceTypeId
     * @param string $status
     * @param string $transactionId
     * @param string $validFromDate
     * @param string $validToDate
     */
    public function __construct($accessControlSystemId = null, $accessControlSystemMemberId = null, $accessControlSystemMemberRealId = null, \patest\StructType\RecordSetOfAccessControl_ActiveAccessCardActivation $activeActivations = null, $activeProducts = null, \patest\StructType\GlobalString $cardName = null, $cardNumber = null, $cardType = null, \patest\StructType\GlobalString $cardTypeName = null, $clientId = null, $creationDate = null, $isDedicated = null, $ownerClientId = null, $priceTypeId = null, $status = null, $transactionId = null, $validFromDate = null, $validToDate = null)
    {
        $this
            ->setAccessControlSystemId($accessControlSystemId)
            ->setAccessControlSystemMemberId($accessControlSystemMemberId)
            ->setAccessControlSystemMemberRealId($accessControlSystemMemberRealId)
            ->setActiveActivations($activeActivations)
            ->setActiveProducts($activeProducts)
            ->setCardName($cardName)
            ->setCardNumber($cardNumber)
            ->setCardType($cardType)
            ->setCardTypeName($cardTypeName)
            ->setClientId($clientId)
            ->setCreationDate($creationDate)
            ->setIsDedicated($isDedicated)
            ->setOwnerClientId($ownerClientId)
            ->setPriceTypeId($priceTypeId)
            ->setStatus($status)
            ->setTransactionId($transactionId)
            ->setValidFromDate($validFromDate)
            ->setValidToDate($validToDate);
    }
    /**
     * Get AccessControlSystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemId()
    {
        return isset($this->AccessControlSystemId) ? $this->AccessControlSystemId : null;
    }
    /**
     * Set AccessControlSystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemId
     * @return \patest\StructType\AccessControl_AccessCard
     */
    public function setAccessControlSystemId($accessControlSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemId) && !is_string($accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemId, true), gettype($accessControlSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlSystemId, true)), __LINE__);
        }
        if (is_null($accessControlSystemId) || (is_array($accessControlSystemId) && empty($accessControlSystemId))) {
            unset($this->AccessControlSystemId);
        } else {
            $this->AccessControlSystemId = $accessControlSystemId;
        }
        return $this;
    }
    /**
     * Get AccessControlSystemMemberId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemMemberId()
    {
        return isset($this->AccessControlSystemMemberId) ? $this->AccessControlSystemMemberId : null;
    }
    /**
     * Set AccessControlSystemMemberId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemMemberId
     * @return \patest\StructType\AccessControl_AccessCard
     */
    public function setAccessControlSystemMemberId($accessControlSystemMemberId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemMemberId) && !is_string($accessControlSystemMemberId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemMemberId, true), gettype($accessControlSystemMemberId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlSystemMemberId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlSystemMemberId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlSystemMemberId, true)), __LINE__);
        }
        if (is_null($accessControlSystemMemberId) || (is_array($accessControlSystemMemberId) && empty($accessControlSystemMemberId))) {
            unset($this->AccessControlSystemMemberId);
        } else {
            $this->AccessControlSystemMemberId = $accessControlSystemMemberId;
        }
        return $this;
    }
    /**
     * Get AccessControlSystemMemberRealId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemMemberRealId()
    {
        return isset($this->AccessControlSystemMemberRealId) ? $this->AccessControlSystemMemberRealId : null;
    }
    /**
     * Set AccessControlSystemMemberRealId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemMemberRealId
     * @return \patest\StructType\AccessControl_AccessCard
     */
    public function setAccessControlSystemMemberRealId($accessControlSystemMemberRealId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemMemberRealId) && !is_string($accessControlSystemMemberRealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemMemberRealId, true), gettype($accessControlSystemMemberRealId)), __LINE__);
        }
        if (is_null($accessControlSystemMemberRealId) || (is_array($accessControlSystemMemberRealId) && empty($accessControlSystemMemberRealId))) {
            unset($this->AccessControlSystemMemberRealId);
        } else {
            $this->AccessControlSystemMemberRealId = $accessControlSystemMemberRealId;
        }
        return $this;
    }
    /**
     * Get ActiveActivations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfAccessControl_ActiveAccessCardActivation|null
     */
    public function getActiveActivations()
    {
        return isset($this->ActiveActivations) ? $this->ActiveActivations : null;
    }
    /**
     * Set ActiveActivations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfAccessControl_ActiveAccessCardActivation $activeActivations
     * @return \patest\StructType\AccessControl_AccessCard
     */
    public function setActiveActivations(\patest\StructType\RecordSetOfAccessControl_ActiveAccessCardActivation $activeActivations = null)
    {
        if (is_null($activeActivations) || (is_array($activeActivations) && empty($activeActivations))) {
            unset($this->ActiveActivations);
        } else {
            $this->ActiveActivations = $activeActivations;
        }
        return $this;
    }
    /**
     * Get ActiveProducts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActiveProducts()
    {
        return isset($this->ActiveProducts) ? $this->ActiveProducts : null;
    }
    /**
     * Set ActiveProducts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activeProducts
     * @return \patest\StructType\AccessControl_AccessCard
     */
    public function setActiveProducts($activeProducts = null)
    {
        // validation for constraint: string
        if (!is_null($activeProducts) && !is_string($activeProducts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activeProducts, true), gettype($activeProducts)), __LINE__);
        }
        if (is_null($activeProducts) || (is_array($activeProducts) && empty($activeProducts))) {
            unset($this->ActiveProducts);
        } else {
            $this->ActiveProducts = $activeProducts;
        }
        return $this;
    }
    /**
     * Get CardName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getCardName()
    {
        return isset($this->CardName) ? $this->CardName : null;
    }
    /**
     * Set CardName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $cardName
     * @return \patest\StructType\AccessControl_AccessCard
     */
    public function setCardName(\patest\StructType\GlobalString $cardName = null)
    {
        if (is_null($cardName) || (is_array($cardName) && empty($cardName))) {
            unset($this->CardName);
        } else {
            $this->CardName = $cardName;
        }
        return $this;
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \patest\StructType\AccessControl_AccessCard
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get CardType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardType()
    {
        return isset($this->CardType) ? $this->CardType : null;
    }
    /**
     * Set CardType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardType
     * @return \patest\StructType\AccessControl_AccessCard
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardType, true), gettype($cardType)), __LINE__);
        }
        if (is_null($cardType) || (is_array($cardType) && empty($cardType))) {
            unset($this->CardType);
        } else {
            $this->CardType = $cardType;
        }
        return $this;
    }
    /**
     * Get CardTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getCardTypeName()
    {
        return isset($this->CardTypeName) ? $this->CardTypeName : null;
    }
    /**
     * Set CardTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $cardTypeName
     * @return \patest\StructType\AccessControl_AccessCard
     */
    public function setCardTypeName(\patest\StructType\GlobalString $cardTypeName = null)
    {
        if (is_null($cardTypeName) || (is_array($cardTypeName) && empty($cardTypeName))) {
            unset($this->CardTypeName);
        } else {
            $this->CardTypeName = $cardTypeName;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\AccessControl_AccessCard
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\AccessControl_AccessCard
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get IsDedicated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDedicated()
    {
        return isset($this->IsDedicated) ? $this->IsDedicated : null;
    }
    /**
     * Set IsDedicated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDedicated
     * @return \patest\StructType\AccessControl_AccessCard
     */
    public function setIsDedicated($isDedicated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDedicated) && !is_bool($isDedicated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDedicated, true), gettype($isDedicated)), __LINE__);
        }
        if (is_null($isDedicated) || (is_array($isDedicated) && empty($isDedicated))) {
            unset($this->IsDedicated);
        } else {
            $this->IsDedicated = $isDedicated;
        }
        return $this;
    }
    /**
     * Get OwnerClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerClientId()
    {
        return isset($this->OwnerClientId) ? $this->OwnerClientId : null;
    }
    /**
     * Set OwnerClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerClientId
     * @return \patest\StructType\AccessControl_AccessCard
     */
    public function setOwnerClientId($ownerClientId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerClientId) && !is_string($ownerClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerClientId, true), gettype($ownerClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownerClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownerClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownerClientId, true)), __LINE__);
        }
        if (is_null($ownerClientId) || (is_array($ownerClientId) && empty($ownerClientId))) {
            unset($this->OwnerClientId);
        } else {
            $this->OwnerClientId = $ownerClientId;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\AccessControl_AccessCard
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AccessCardStatus::valueIsValid()
     * @uses \patest\EnumType\AccessCardStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\AccessControl_AccessCard
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AccessCardStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AccessCardStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\AccessCardStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionId()
    {
        return isset($this->TransactionId) ? $this->TransactionId : null;
    }
    /**
     * Set TransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionId
     * @return \patest\StructType\AccessControl_AccessCard
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        if (is_null($transactionId) || (is_array($transactionId) && empty($transactionId))) {
            unset($this->TransactionId);
        } else {
            $this->TransactionId = $transactionId;
        }
        return $this;
    }
    /**
     * Get ValidFromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidFromDate()
    {
        return isset($this->ValidFromDate) ? $this->ValidFromDate : null;
    }
    /**
     * Set ValidFromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validFromDate
     * @return \patest\StructType\AccessControl_AccessCard
     */
    public function setValidFromDate($validFromDate = null)
    {
        // validation for constraint: string
        if (!is_null($validFromDate) && !is_string($validFromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validFromDate, true), gettype($validFromDate)), __LINE__);
        }
        if (is_null($validFromDate) || (is_array($validFromDate) && empty($validFromDate))) {
            unset($this->ValidFromDate);
        } else {
            $this->ValidFromDate = $validFromDate;
        }
        return $this;
    }
    /**
     * Get ValidToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidToDate()
    {
        return isset($this->ValidToDate) ? $this->ValidToDate : null;
    }
    /**
     * Set ValidToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validToDate
     * @return \patest\StructType\AccessControl_AccessCard
     */
    public function setValidToDate($validToDate = null)
    {
        // validation for constraint: string
        if (!is_null($validToDate) && !is_string($validToDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validToDate, true), gettype($validToDate)), __LINE__);
        }
        if (is_null($validToDate) || (is_array($validToDate) && empty($validToDate))) {
            unset($this->ValidToDate);
        } else {
            $this->ValidToDate = $validToDate;
        }
        return $this;
    }
}
