<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessCodeDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AccessCodeDetails
 * @subpackage Structs
 */
class AccessCodeDetails extends AbstractStructBase
{
    /**
     * The CodeText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodeText;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The LastTransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LastTransactionNumber;
    /**
     * The LastUsageDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastUsageDate;
    /**
     * The PresaleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PresaleId;
    /**
     * The TransactionCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionCount;
    /**
     * Constructor method for AccessCodeDetails
     * @uses AccessCodeDetails::setCodeText()
     * @uses AccessCodeDetails::setId()
     * @uses AccessCodeDetails::setIsActive()
     * @uses AccessCodeDetails::setLastTransactionNumber()
     * @uses AccessCodeDetails::setLastUsageDate()
     * @uses AccessCodeDetails::setPresaleId()
     * @uses AccessCodeDetails::setTransactionCount()
     * @param string $codeText
     * @param string $id
     * @param bool $isActive
     * @param int $lastTransactionNumber
     * @param string $lastUsageDate
     * @param string $presaleId
     * @param int $transactionCount
     */
    public function __construct($codeText = null, $id = null, $isActive = null, $lastTransactionNumber = null, $lastUsageDate = null, $presaleId = null, $transactionCount = null)
    {
        $this
            ->setCodeText($codeText)
            ->setId($id)
            ->setIsActive($isActive)
            ->setLastTransactionNumber($lastTransactionNumber)
            ->setLastUsageDate($lastUsageDate)
            ->setPresaleId($presaleId)
            ->setTransactionCount($transactionCount);
    }
    /**
     * Get CodeText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeText()
    {
        return isset($this->CodeText) ? $this->CodeText : null;
    }
    /**
     * Set CodeText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codeText
     * @return \patest\StructType\AccessCodeDetails
     */
    public function setCodeText($codeText = null)
    {
        // validation for constraint: string
        if (!is_null($codeText) && !is_string($codeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeText, true), gettype($codeText)), __LINE__);
        }
        if (is_null($codeText) || (is_array($codeText) && empty($codeText))) {
            unset($this->CodeText);
        } else {
            $this->CodeText = $codeText;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\AccessCodeDetails
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\AccessCodeDetails
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get LastTransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLastTransactionNumber()
    {
        return isset($this->LastTransactionNumber) ? $this->LastTransactionNumber : null;
    }
    /**
     * Set LastTransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lastTransactionNumber
     * @return \patest\StructType\AccessCodeDetails
     */
    public function setLastTransactionNumber($lastTransactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($lastTransactionNumber) && !(is_int($lastTransactionNumber) || ctype_digit($lastTransactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lastTransactionNumber, true), gettype($lastTransactionNumber)), __LINE__);
        }
        if (is_null($lastTransactionNumber) || (is_array($lastTransactionNumber) && empty($lastTransactionNumber))) {
            unset($this->LastTransactionNumber);
        } else {
            $this->LastTransactionNumber = $lastTransactionNumber;
        }
        return $this;
    }
    /**
     * Get LastUsageDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastUsageDate()
    {
        return isset($this->LastUsageDate) ? $this->LastUsageDate : null;
    }
    /**
     * Set LastUsageDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastUsageDate
     * @return \patest\StructType\AccessCodeDetails
     */
    public function setLastUsageDate($lastUsageDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastUsageDate) && !is_string($lastUsageDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUsageDate, true), gettype($lastUsageDate)), __LINE__);
        }
        if (is_null($lastUsageDate) || (is_array($lastUsageDate) && empty($lastUsageDate))) {
            unset($this->LastUsageDate);
        } else {
            $this->LastUsageDate = $lastUsageDate;
        }
        return $this;
    }
    /**
     * Get PresaleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPresaleId()
    {
        return isset($this->PresaleId) ? $this->PresaleId : null;
    }
    /**
     * Set PresaleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $presaleId
     * @return \patest\StructType\AccessCodeDetails
     */
    public function setPresaleId($presaleId = null)
    {
        // validation for constraint: string
        if (!is_null($presaleId) && !is_string($presaleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($presaleId, true), gettype($presaleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($presaleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $presaleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($presaleId, true)), __LINE__);
        }
        if (is_null($presaleId) || (is_array($presaleId) && empty($presaleId))) {
            unset($this->PresaleId);
        } else {
            $this->PresaleId = $presaleId;
        }
        return $this;
    }
    /**
     * Get TransactionCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionCount()
    {
        return isset($this->TransactionCount) ? $this->TransactionCount : null;
    }
    /**
     * Set TransactionCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionCount
     * @return \patest\StructType\AccessCodeDetails
     */
    public function setTransactionCount($transactionCount = null)
    {
        // validation for constraint: int
        if (!is_null($transactionCount) && !(is_int($transactionCount) || ctype_digit($transactionCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionCount, true), gettype($transactionCount)), __LINE__);
        }
        if (is_null($transactionCount) || (is_array($transactionCount) && empty($transactionCount))) {
            unset($this->TransactionCount);
        } else {
            $this->TransactionCount = $transactionCount;
        }
        return $this;
    }
}
