<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Store ServiceType
 * @subpackage Services
 */
class Store extends AbstractSoapClientBase
{
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\Context $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\patest\StructType\Context $context, $nameSpace = 'http://foundation.toptix.com/2007', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Context', $context, $mustUnderstand, $actor);
    }
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://foundation.toptix.com/2007', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named StoreJournalEntries
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\StoreJournalEntriesRequest $iTenantAdministrationService_StoreJournalEntries_RequestMsg
     * @return \patest\StructType\StoreJournalEntriesResponse|bool
     */
    public function StoreJournalEntries(\patest\StructType\StoreJournalEntriesRequest $iTenantAdministrationService_StoreJournalEntries_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->StoreJournalEntries($iTenantAdministrationService_StoreJournalEntries_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Store
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\EntitiesCreateOrUpdateRequest $iSoapEntityManagementFacade_Store_RequestMsg
     * @return \patest\StructType\EntitiesCreateOrUpdateResponse|bool
     */
    public function Store(\patest\StructType\EntitiesCreateOrUpdateRequest $iSoapEntityManagementFacade_Store_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->Store($iSoapEntityManagementFacade_Store_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named StoreManuallyEnteredBarcodes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\StoreManuallyEnteredBarcodesRequest $iAccessControlFacade_StoreManuallyEnteredBarcodes_RequestMsg
     * @return \patest\StructType\StoreManuallyEnteredBarcodesResponse|bool
     */
    public function StoreManuallyEnteredBarcodes(\patest\StructType\StoreManuallyEnteredBarcodesRequest $iAccessControlFacade_StoreManuallyEnteredBarcodes_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->StoreManuallyEnteredBarcodes($iAccessControlFacade_StoreManuallyEnteredBarcodes_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named StoreCreditCardToken
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\StoreCreditCardTokenRequest $iPaymentFacade_StoreCreditCardToken_RequestMsg
     * @return \patest\StructType\StoreCreditCardTokenResponse|bool
     */
    public function StoreCreditCardToken(\patest\StructType\StoreCreditCardTokenRequest $iPaymentFacade_StoreCreditCardToken_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->StoreCreditCardToken($iPaymentFacade_StoreCreditCardToken_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named StoreHallVersionDesign
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\StoreHallVersionDesign_Request $iTicketingFacade_StoreHallVersionDesign_RequestMsg
     * @return \patest\StructType\StoreHallVersionDesign_Response|bool
     */
    public function StoreHallVersionDesign(\patest\StructType\StoreHallVersionDesign_Request $iTicketingFacade_StoreHallVersionDesign_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->StoreHallVersionDesign($iTicketingFacade_StoreHallVersionDesign_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\EntitiesCreateOrUpdateResponse|\patest\StructType\StoreCreditCardTokenResponse|\patest\StructType\StoreHallVersionDesign_Response|\patest\StructType\StoreJournalEntriesResponse|\patest\StructType\StoreManuallyEnteredBarcodesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
