<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Move ServiceType
 * @subpackage Services
 */
class Move extends AbstractSoapClientBase
{
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\patest\ArrayType\ArrayOfKeyValueOfstringstring $context, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Context', $context, $mustUnderstand, $actor);
    }
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named
     * MoveSubscriptionReservedSeatSelection
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\MoveSubscriptionReservedSeatSelectionRequest $iSubscriptionFacade_MoveSubscriptionReservedSeatSelection_RequestMsg
     * @return \patest\StructType\MoveSubscriptionReservedSeatSelectionResponse|bool
     */
    public function MoveSubscriptionReservedSeatSelection(\patest\StructType\MoveSubscriptionReservedSeatSelectionRequest $iSubscriptionFacade_MoveSubscriptionReservedSeatSelection_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->MoveSubscriptionReservedSeatSelection($iSubscriptionFacade_MoveSubscriptionReservedSeatSelection_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * MoveReservedSeatSelectionForMultipleEvents
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\MoveReservedSeatSelectionForMultipleEvents_Request $iTicketingFacade_MoveReservedSeatSelectionForMultipleEvents_RequestMsg
     * @return \patest\StructType\MoveReservedSeatSelectionForMultipleEvents_Response|bool
     */
    public function MoveReservedSeatSelectionForMultipleEvents(\patest\StructType\MoveReservedSeatSelectionForMultipleEvents_Request $iTicketingFacade_MoveReservedSeatSelectionForMultipleEvents_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->MoveReservedSeatSelectionForMultipleEvents($iTicketingFacade_MoveReservedSeatSelectionForMultipleEvents_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MoveReservedSeatSelection
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\MoveReservedSeatSelection_Request $iTicketingFacade_MoveReservedSeatSelection_RequestMsg
     * @return \patest\StructType\MoveReservedSeatSelection_Response|bool
     */
    public function MoveReservedSeatSelection(\patest\StructType\MoveReservedSeatSelection_Request $iTicketingFacade_MoveReservedSeatSelection_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->MoveReservedSeatSelection($iTicketingFacade_MoveReservedSeatSelection_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MoveAudience
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\MoveAudience_Request $iTicketingFacade_MoveAudience_RequestMsg
     * @return \patest\StructType\MoveAudience_Response|bool
     */
    public function MoveAudience(\patest\StructType\MoveAudience_Request $iTicketingFacade_MoveAudience_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->MoveAudience($iTicketingFacade_MoveAudience_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\MoveAudience_Response|\patest\StructType\MoveReservedSeatSelectionForMultipleEvents_Response|\patest\StructType\MoveReservedSeatSelection_Response|\patest\StructType\MoveSubscriptionReservedSeatSelectionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
