<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\Context $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\patest\StructType\Context $context, $nameSpace = 'http://foundation.toptix.com/2007', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Context', $context, $mustUnderstand, $actor);
    }
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://foundation.toptix.com/2007', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetAvailableData
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetAvailableDataRequest $iDataDistributionService_GetAvailableData_RequestMsg
     * @return \patest\StructType\GetAvailableDataResponse|bool
     */
    public function GetAvailableData(\patest\StructType\GetAvailableDataRequest $iDataDistributionService_GetAvailableData_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableData($iDataDistributionService_GetAvailableData_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRuleSystemDescription
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetRuleSystemDescriptionRequest $iFoundationService_GetRuleSystemDescription_RequestMsg
     * @return \patest\StructType\GetRuleSystemDescriptionResponse|bool
     */
    public function GetRuleSystemDescription(\patest\StructType\GetRuleSystemDescriptionRequest $iFoundationService_GetRuleSystemDescription_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRuleSystemDescription($iFoundationService_GetRuleSystemDescription_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetListOfLogFiles
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetListOfLogFilesRequest $iFoundationService_GetListOfLogFiles_RequestMsg
     * @return \patest\StructType\GetListOfLogFilesResponse|bool
     */
    public function GetListOfLogFiles(\patest\StructType\GetListOfLogFilesRequest $iFoundationService_GetListOfLogFiles_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetListOfLogFiles($iFoundationService_GetListOfLogFiles_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUrlForLogFile
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetUrlForLogFileRequest $iFoundationService_GetUrlForLogFile_RequestMsg
     * @return \patest\StructType\GetUrlForLogFileResponse|bool
     */
    public function GetUrlForLogFile(\patest\StructType\GetUrlForLogFileRequest $iFoundationService_GetUrlForLogFile_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUrlForLogFile($iFoundationService_GetUrlForLogFile_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetEntityManagementQueryTokenContext
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetEntityManagementQueryTokenContextRequest $iFoundationService_GetEntityManagementQueryTokenContext_RequestMsg
     * @return \patest\StructType\GetEntityManagementQueryTokenContextResponse|bool
     */
    public function GetEntityManagementQueryTokenContext(\patest\StructType\GetEntityManagementQueryTokenContextRequest $iFoundationService_GetEntityManagementQueryTokenContext_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEntityManagementQueryTokenContext($iFoundationService_GetEntityManagementQueryTokenContext_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUpdatedEntities
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetUpdatedEntitiesRequest $iIntegrationService_GetUpdatedEntities_RequestMsg
     * @return \patest\StructType\GetUpdatedEntitiesResponse|bool
     */
    public function GetUpdatedEntities(\patest\StructType\GetUpdatedEntitiesRequest $iIntegrationService_GetUpdatedEntities_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUpdatedEntities($iIntegrationService_GetUpdatedEntities_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDeletedEntities
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetDeletedEntitiesRequest $iIntegrationService_GetDeletedEntities_RequestMsg
     * @return \patest\StructType\GetDeletedEntitiesResponse|bool
     */
    public function GetDeletedEntities(\patest\StructType\GetDeletedEntitiesRequest $iIntegrationService_GetDeletedEntities_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDeletedEntities($iIntegrationService_GetDeletedEntities_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCrmIdForCardSwipe
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetCrmIdForCardSwipe_Request $iAccessControlFacade_GetCrmIdForCardSwipe_RequestMsg
     * @return \patest\StructType\GetCrmIdForCardSwipe_Response|bool
     */
    public function GetCrmIdForCardSwipe(\patest\StructType\GetCrmIdForCardSwipe_Request $iAccessControlFacade_GetCrmIdForCardSwipe_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCrmIdForCardSwipe($iAccessControlFacade_GetCrmIdForCardSwipe_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBarcodeEntities
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetBarcodeEntities_Request $iAccessControlFacade_GetBarcodeEntities_RequestMsg
     * @return \patest\StructType\GetBarcodeEntities_Response|bool
     */
    public function GetBarcodeEntities(\patest\StructType\GetBarcodeEntities_Request $iAccessControlFacade_GetBarcodeEntities_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBarcodeEntities($iAccessControlFacade_GetBarcodeEntities_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTransactionAccessControlData
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetTransactionAccessControlDataRequest $iAccessControlFacade_GetTransactionAccessControlData_RequestMsg
     * @return \patest\StructType\GetTransactionAccessControlDataResponse|bool
     */
    public function GetTransactionAccessControlData(\patest\StructType\GetTransactionAccessControlDataRequest $iAccessControlFacade_GetTransactionAccessControlData_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTransactionAccessControlData($iAccessControlFacade_GetTransactionAccessControlData_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccessControlSystems
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetAccessControlSystemsRequest $iAccessControlFacade_GetAccessControlSystems_RequestMsg
     * @return \patest\StructType\GetAccessControlSystemsResponse|bool
     */
    public function GetAccessControlSystems(\patest\StructType\GetAccessControlSystemsRequest $iAccessControlFacade_GetAccessControlSystems_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAccessControlSystems($iAccessControlFacade_GetAccessControlSystems_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBarcodeChanges
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetBarcodeChangesRequest $iAccessControlFacade_GetBarcodeChanges_RequestMsg
     * @return \patest\StructType\GetBarcodeChangesResponse|bool
     */
    public function GetBarcodeChanges(\patest\StructType\GetBarcodeChangesRequest $iAccessControlFacade_GetBarcodeChanges_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBarcodeChanges($iAccessControlFacade_GetBarcodeChanges_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTicketsScanningStatus
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetTicketsScanningStatus_Request $iAccessControlFacade_GetTicketsScanningStatus_RequestMsg
     * @return \patest\StructType\GetTicketsScanningStatus_Response|bool
     */
    public function GetTicketsScanningStatus(\patest\StructType\GetTicketsScanningStatus_Request $iAccessControlFacade_GetTicketsScanningStatus_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTicketsScanningStatus($iAccessControlFacade_GetTicketsScanningStatus_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccessInfoForTickets
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetAccessInfoForTickets_Request $iAccessControlFacade_GetAccessInfoForTickets_RequestMsg
     * @return \patest\StructType\GetAccessInfoForTickets_Response|bool
     */
    public function GetAccessInfoForTickets(\patest\StructType\GetAccessInfoForTickets_Request $iAccessControlFacade_GetAccessInfoForTickets_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAccessInfoForTickets($iAccessControlFacade_GetAccessInfoForTickets_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPasswordValidityParameters
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetPasswordValidityParameters_Request $iAuthenticationFacade_GetPasswordValidityParameters_RequestMsg
     * @return \patest\StructType\GetPasswordValidityParameters_Response|bool
     */
    public function GetPasswordValidityParameters(\patest\StructType\GetPasswordValidityParameters_Request $iAuthenticationFacade_GetPasswordValidityParameters_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPasswordValidityParameters($iAuthenticationFacade_GetPasswordValidityParameters_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetGuidanceDescription
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetGuidanceDescriptionRequest $iBizResourceFacade_GetGuidanceDescription_RequestMsg
     * @return \patest\StructType\GetGuidanceDescriptionResponse|bool
     */
    public function GetGuidanceDescription(\patest\StructType\GetGuidanceDescriptionRequest $iBizResourceFacade_GetGuidanceDescription_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetGuidanceDescription($iBizResourceFacade_GetGuidanceDescription_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCurrentClient
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetCurrentClient_Request $iCrmFacade_GetCurrentClient_RequestMsg
     * @return \patest\StructType\GetCurrentClient_Response|bool
     */
    public function GetCurrentClient(\patest\StructType\GetCurrentClient_Request $iCrmFacade_GetCurrentClient_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCurrentClient($iCrmFacade_GetCurrentClient_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableSolicitors
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetAvailableSolicitorsRequest $iCrmFacade_GetAvailableSolicitors_RequestMsg
     * @return \patest\StructType\GetAvailableSolicitorsResponse|bool
     */
    public function GetAvailableSolicitors(\patest\StructType\GetAvailableSolicitorsRequest $iCrmFacade_GetAvailableSolicitors_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableSolicitors($iCrmFacade_GetAvailableSolicitors_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableSalesRepresentatives
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetAvailableSalesRepresentativesRequest $iCrmFacade_GetAvailableSalesRepresentatives_RequestMsg
     * @return \patest\StructType\GetAvailableSalesRepresentativesResponse|bool
     */
    public function GetAvailableSalesRepresentatives(\patest\StructType\GetAvailableSalesRepresentativesRequest $iCrmFacade_GetAvailableSalesRepresentatives_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableSalesRepresentatives($iCrmFacade_GetAvailableSalesRepresentatives_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableServiceRepresentatives
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetAvailableServiceRepresentativesRequest $iCrmFacade_GetAvailableServiceRepresentatives_RequestMsg
     * @return \patest\StructType\GetAvailableServiceRepresentativesResponse|bool
     */
    public function GetAvailableServiceRepresentatives(\patest\StructType\GetAvailableServiceRepresentativesRequest $iCrmFacade_GetAvailableServiceRepresentatives_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableServiceRepresentatives($iCrmFacade_GetAvailableServiceRepresentatives_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetAvailableDataProtectionQuestions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetAvailableDataProtectionQuestionsRequest $iCrmFacade_GetAvailableDataProtectionQuestions_RequestMsg
     * @return \patest\StructType\GetAvailableDataProtectionQuestionsResponse|bool
     */
    public function GetAvailableDataProtectionQuestions(\patest\StructType\GetAvailableDataProtectionQuestionsRequest $iCrmFacade_GetAvailableDataProtectionQuestions_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableDataProtectionQuestions($iCrmFacade_GetAvailableDataProtectionQuestions_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSgoLinkageInfo
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\SgoLinkageInfoRequest $iCrmFacade_GetSgoLinkageInfo_RequestMsg
     * @return \patest\StructType\SgoLinkageInfoResponse|bool
     */
    public function GetSgoLinkageInfo(\patest\StructType\SgoLinkageInfoRequest $iCrmFacade_GetSgoLinkageInfo_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSgoLinkageInfo($iCrmFacade_GetSgoLinkageInfo_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSGAccountContext
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\SGAccountContextRequest $iCrmFacade_GetSGAccountContext_RequestMsg
     * @return \patest\StructType\SGAccountContextResponse|bool
     */
    public function GetSGAccountContext(\patest\StructType\SGAccountContextRequest $iCrmFacade_GetSGAccountContext_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSGAccountContext($iCrmFacade_GetSGAccountContext_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableDeliveries
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetAvailableDeliveries_Request $iDeliveryFacade_GetAvailableDeliveries_RequestMsg
     * @return \patest\StructType\GetAvailableDeliveries_Response|bool
     */
    public function GetAvailableDeliveries(\patest\StructType\GetAvailableDeliveries_Request $iDeliveryFacade_GetAvailableDeliveries_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableDeliveries($iDeliveryFacade_GetAvailableDeliveries_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSoftCreditDefaultsForClient
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetSoftCreditDefaultsForClient_Request $iDonationFacade_GetSoftCreditDefaultsForClient_RequestMsg
     * @return \patest\StructType\GetSoftCreditDefaultsForClient_Response|bool
     */
    public function GetSoftCreditDefaultsForClient(\patest\StructType\GetSoftCreditDefaultsForClient_Request $iDonationFacade_GetSoftCreditDefaultsForClient_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSoftCreditDefaultsForClient($iDonationFacade_GetSoftCreditDefaultsForClient_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMatchingGiftsReservations
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetMatchingGiftsReservations_Request $iDonationFacade_GetMatchingGiftsReservations_RequestMsg
     * @return \patest\StructType\GetMatchingGiftsReservations_Response|bool
     */
    public function GetMatchingGiftsReservations(\patest\StructType\GetMatchingGiftsReservations_Request $iDonationFacade_GetMatchingGiftsReservations_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMatchingGiftsReservations($iDonationFacade_GetMatchingGiftsReservations_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetClientWelcomeInfo
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetClientWelcomeInfoRequest $iEsroFacade_GetClientWelcomeInfo_RequestMsg
     * @return \patest\StructType\GetClientWelcomeInfoResponse|bool
     */
    public function GetClientWelcomeInfo(\patest\StructType\GetClientWelcomeInfoRequest $iEsroFacade_GetClientWelcomeInfo_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetClientWelcomeInfo($iEsroFacade_GetClientWelcomeInfo_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetAllBundleElementsAvailableProducts
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetAllBundleElementsAvailableProductsRequest $iEsroFacade_GetAllBundleElementsAvailableProducts_RequestMsg
     * @return \patest\StructType\GetAllBundleElementsAvailableProductsResponse|bool
     */
    public function GetAllBundleElementsAvailableProducts(\patest\StructType\GetAllBundleElementsAvailableProductsRequest $iEsroFacade_GetAllBundleElementsAvailableProducts_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAllBundleElementsAvailableProducts($iEsroFacade_GetAllBundleElementsAvailableProducts_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBundleElementAvailableProducts
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetBundleElementAvailableProductsRequest $iEsroFacade_GetBundleElementAvailableProducts_RequestMsg
     * @return \patest\StructType\GetBundleElementAvailableProductsResponse|bool
     */
    public function GetBundleElementAvailableProducts(\patest\StructType\GetBundleElementAvailableProductsRequest $iEsroFacade_GetBundleElementAvailableProducts_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBundleElementAvailableProducts($iEsroFacade_GetBundleElementAvailableProducts_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetExtraPromptElementsAvailableProducts
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetExtraPromptElementAvailablProductsRequest $iEsroFacade_GetExtraPromptElementsAvailableProducts_RequestMsg
     * @return \patest\StructType\GetExtraPromptElementAvailableProductsResponse|bool
     */
    public function GetExtraPromptElementsAvailableProducts(\patest\StructType\GetExtraPromptElementAvailablProductsRequest $iEsroFacade_GetExtraPromptElementsAvailableProducts_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetExtraPromptElementsAvailableProducts($iEsroFacade_GetExtraPromptElementsAvailableProducts_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetExtendedTicketInfo
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetExtendedTicketInfoRequest $iEsroFacade_GetExtendedTicketInfo_RequestMsg
     * @return \patest\StructType\GetExtendedTicketInfoResponse|bool
     */
    public function GetExtendedTicketInfo(\patest\StructType\GetExtendedTicketInfoRequest $iEsroFacade_GetExtendedTicketInfo_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetExtendedTicketInfo($iEsroFacade_GetExtendedTicketInfo_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetClientEvents
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetClientEventsRequest $iEsroFacade_GetClientEvents_RequestMsg
     * @return \patest\StructType\GetClientEventsResponse|bool
     */
    public function GetClientEvents(\patest\StructType\GetClientEventsRequest $iEsroFacade_GetClientEvents_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetClientEvents($iEsroFacade_GetClientEvents_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetClientEventTickets
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetClientEventTicketsRequest $iEsroFacade_GetClientEventTickets_RequestMsg
     * @return \patest\StructType\GetClientEventTicketsResponse|bool
     */
    public function GetClientEventTickets(\patest\StructType\GetClientEventTicketsRequest $iEsroFacade_GetClientEventTickets_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetClientEventTickets($iEsroFacade_GetClientEventTickets_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTicketsToManage
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetTicketsToManageRequest $iEsroFacade_GetTicketsToManage_RequestMsg
     * @return \patest\StructType\GetTicketsToManageResponse|bool
     */
    public function GetTicketsToManage(\patest\StructType\GetTicketsToManageRequest $iEsroFacade_GetTicketsToManage_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTicketsToManage($iEsroFacade_GetTicketsToManage_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRelatedClients
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetRelatedClientsRequest $iEsroFacade_GetRelatedClients_RequestMsg
     * @return \patest\StructType\GetRelatedClientsResponse|bool
     */
    public function GetRelatedClients(\patest\StructType\GetRelatedClientsRequest $iEsroFacade_GetRelatedClients_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRelatedClients($iEsroFacade_GetRelatedClients_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLinkedClients
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetLinkedClientsRequest $iEsroFacade_GetLinkedClients_RequestMsg
     * @return \patest\StructType\GetLinkedClientsResponse|bool
     */
    public function GetLinkedClients(\patest\StructType\GetLinkedClientsRequest $iEsroFacade_GetLinkedClients_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLinkedClients($iEsroFacade_GetLinkedClients_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCaptionsByKeys
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetCaptionsByKeysRequest $iEsroFacade_GetCaptionsByKeys_RequestMsg
     * @return \patest\StructType\GetCaptionsByKeysResponse|bool
     */
    public function GetCaptionsByKeys(\patest\StructType\GetCaptionsByKeysRequest $iEsroFacade_GetCaptionsByKeys_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCaptionsByKeys($iEsroFacade_GetCaptionsByKeys_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCardLoadingDescription
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetCardLoadingDescriptionRequest $iGiftCardFacade_GetCardLoadingDescription_RequestMsg
     * @return \patest\StructType\GetCardLoadingDescriptionResponse|bool
     */
    public function GetCardLoadingDescription(\patest\StructType\GetCardLoadingDescriptionRequest $iGiftCardFacade_GetCardLoadingDescription_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCardLoadingDescription($iGiftCardFacade_GetCardLoadingDescription_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetGiftVoucherDescription
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetGiftVoucherDescription_Request $iGiftVoucherFacade_GetGiftVoucherDescription_RequestMsg
     * @return \patest\StructType\GetGiftVoucherDescription_Response|bool
     */
    public function GetGiftVoucherDescription(\patest\StructType\GetGiftVoucherDescription_Request $iGiftVoucherFacade_GetGiftVoucherDescription_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetGiftVoucherDescription($iGiftVoucherFacade_GetGiftVoucherDescription_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMembershipDefinitionDescription
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetMembershipDefinitionDescription_Request $iMembershipFacade_GetMembershipDefinitionDescription_RequestMsg
     * @return \patest\StructType\GetMembershipDefinitionDescription_Response|bool
     */
    public function GetMembershipDefinitionDescription(\patest\StructType\GetMembershipDefinitionDescription_Request $iMembershipFacade_GetMembershipDefinitionDescription_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMembershipDefinitionDescription($iMembershipFacade_GetMembershipDefinitionDescription_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSchemeDescription
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetSchemeDescription_Request $iMembershipFacade_GetSchemeDescription_RequestMsg
     * @return \patest\StructType\GetSchemeDescription_Response|bool
     */
    public function GetSchemeDescription(\patest\StructType\GetSchemeDescription_Request $iMembershipFacade_GetSchemeDescription_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSchemeDescription($iMembershipFacade_GetSchemeDescription_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMerchandiseDescription
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetMerchandiseDescription_Request $iMerchandiseFacade_GetMerchandiseDescription_RequestMsg
     * @return \patest\StructType\GetMerchandiseDescription_Response|bool
     */
    public function GetMerchandiseDescription(\patest\StructType\GetMerchandiseDescription_Request $iMerchandiseFacade_GetMerchandiseDescription_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMerchandiseDescription($iMerchandiseFacade_GetMerchandiseDescription_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableMerchandiseItemTypes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetAvailableMerchandiseItemTypes_Request $iMerchandiseFacade_GetAvailableMerchandiseItemTypes_RequestMsg
     * @return \patest\StructType\GetAvailableMerchandiseItemTypes_Response|bool
     */
    public function GetAvailableMerchandiseItemTypes(\patest\StructType\GetAvailableMerchandiseItemTypes_Request $iMerchandiseFacade_GetAvailableMerchandiseItemTypes_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableMerchandiseItemTypes($iMerchandiseFacade_GetAvailableMerchandiseItemTypes_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMerchandiseItemsPrices
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetMerchandiseItemsPrices_Request $iMerchandiseFacade_GetMerchandiseItemsPrices_RequestMsg
     * @return \patest\StructType\GetMerchandiseItemsPrices_Response|bool
     */
    public function GetMerchandiseItemsPrices(\patest\StructType\GetMerchandiseItemsPrices_Request $iMerchandiseFacade_GetMerchandiseItemsPrices_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMerchandiseItemsPrices($iMerchandiseFacade_GetMerchandiseItemsPrices_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableProducts
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetAvailableProducts_Request $iMerchandiseFacade_GetAvailableProducts_RequestMsg
     * @return \patest\StructType\GetAvailableProducts_Response|bool
     */
    public function GetAvailableProducts(\patest\StructType\GetAvailableProducts_Request $iMerchandiseFacade_GetAvailableProducts_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableProducts($iMerchandiseFacade_GetAvailableProducts_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProductDescription
     * This method has been renamed because it is defined several times but with
     * different signature
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetProductDescription_Request $iMerchandiseFacade_GetProductDescription_RequestMsg
     * @return \patest\StructType\GetProductDescription_Response|bool
     */
    public function GetProductDescription(\patest\StructType\GetProductDescription_Request $iMerchandiseFacade_GetProductDescription_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProductDescription($iMerchandiseFacade_GetProductDescription_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTaggedProducts
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetTaggedProductsRequest_Request $iMerchandiseFacade_GetTaggedProducts_RequestMsg
     * @return \patest\StructType\GetTaggedProductsResponse_Request|bool
     */
    public function GetTaggedProducts(\patest\StructType\GetTaggedProductsRequest_Request $iMerchandiseFacade_GetTaggedProducts_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTaggedProducts($iMerchandiseFacade_GetTaggedProducts_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCategories
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetCategories_Request $iMerchandiseFacade_GetCategories_RequestMsg
     * @return \patest\StructType\GetCategories_Request|bool
     */
    public function GetCategories(\patest\StructType\GetCategories_Request $iMerchandiseFacade_GetCategories_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCategories($iMerchandiseFacade_GetCategories_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProductsAttributesTypes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetProductsAttributesTypes_Request $iMerchandiseFacade_GetProductsAttributesTypes_RequestMsg
     * @return \patest\StructType\GetProductsAttributesTypes_Response|bool
     */
    public function GetProductsAttributesTypes(\patest\StructType\GetProductsAttributesTypes_Request $iMerchandiseFacade_GetProductsAttributesTypes_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProductsAttributesTypes($iMerchandiseFacade_GetProductsAttributesTypes_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetClassNodes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetClassNodesRequest_Request $iMerchandiseFacade_GetClassNodes_RequestMsg
     * @return \patest\StructType\GetClassNodesResponse_Response|bool
     */
    public function GetClassNodes(\patest\StructType\GetClassNodesRequest_Request $iMerchandiseFacade_GetClassNodes_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetClassNodes($iMerchandiseFacade_GetClassNodes_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetClassContent
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetClassContentRequest $iMerchandiseFacade_GetClassContent_RequestMsg
     * @return \patest\StructType\GetClassContentResponse|bool
     */
    public function GetClassContent(\patest\StructType\GetClassContentRequest $iMerchandiseFacade_GetClassContent_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetClassContent($iMerchandiseFacade_GetClassContent_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailablePaymentMethods
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetAvailablePaymentMethods_Request $iPaymentFacade_GetAvailablePaymentMethods_RequestMsg
     * @return \patest\StructType\GetAvailablePaymentMethods_Response|bool
     */
    public function GetAvailablePaymentMethods(\patest\StructType\GetAvailablePaymentMethods_Request $iPaymentFacade_GetAvailablePaymentMethods_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailablePaymentMethods($iPaymentFacade_GetAvailablePaymentMethods_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerCreditCategories
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetCustomerCreditCategories_Request $iPaymentFacade_GetCustomerCreditCategories_RequestMsg
     * @return \patest\StructType\GetCustomerCreditCategories_Response|bool
     */
    public function GetCustomerCreditCategories(\patest\StructType\GetCustomerCreditCategories_Request $iPaymentFacade_GetCustomerCreditCategories_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerCreditCategories($iPaymentFacade_GetCustomerCreditCategories_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetClientBalance
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetClientBalance_Request $iPaymentFacade_GetClientBalance_RequestMsg
     * @return \patest\StructType\GetClientBalance_Response|bool
     */
    public function GetClientBalance(\patest\StructType\GetClientBalance_Request $iPaymentFacade_GetClientBalance_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetClientBalance($iPaymentFacade_GetClientBalance_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableDirectDebitMandates
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetAvailableDirectDebitMandates_Request $iPaymentFacade_GetAvailableDirectDebitMandates_RequestMsg
     * @return \patest\StructType\GetAvailableDirectDebitMandates_Response|bool
     */
    public function GetAvailableDirectDebitMandates(\patest\StructType\GetAvailableDirectDebitMandates_Request $iPaymentFacade_GetAvailableDirectDebitMandates_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableDirectDebitMandates($iPaymentFacade_GetAvailableDirectDebitMandates_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDirectDebitRecordsToSend
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetDirectDebitRecordsToSend_Request $iPaymentFacade_GetDirectDebitRecordsToSend_RequestMsg
     * @return \patest\StructType\GetDirectDebitRecordsToSend_Response|bool
     */
    public function GetDirectDebitRecordsToSend(\patest\StructType\GetDirectDebitRecordsToSend_Request $iPaymentFacade_GetDirectDebitRecordsToSend_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDirectDebitRecordsToSend($iPaymentFacade_GetDirectDebitRecordsToSend_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDirectDebitRecordsBatch
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetDirectDebitRecordsBatch_Request $iPaymentFacade_GetDirectDebitRecordsBatch_RequestMsg
     * @return \patest\StructType\GetDirectDebitRecordsBatch_Response|bool
     */
    public function GetDirectDebitRecordsBatch(\patest\StructType\GetDirectDebitRecordsBatch_Request $iPaymentFacade_GetDirectDebitRecordsBatch_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDirectDebitRecordsBatch($iPaymentFacade_GetDirectDebitRecordsBatch_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableDeposits
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetAvailableDepositsRequest $iPaymentFacade_GetAvailableDeposits_RequestMsg
     * @return \patest\StructType\GetAvailableDepositsResponse|bool
     */
    public function GetAvailableDeposits(\patest\StructType\GetAvailableDepositsRequest $iPaymentFacade_GetAvailableDeposits_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableDeposits($iPaymentFacade_GetAvailableDeposits_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPaymentPlanDefaults
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetPaymentPlanDefaults_Request $iPaymentFacade_GetPaymentPlanDefaults_RequestMsg
     * @return \patest\StructType\GetPaymentPlanDefaults_Response|bool
     */
    public function GetPaymentPlanDefaults(\patest\StructType\GetPaymentPlanDefaults_Request $iPaymentFacade_GetPaymentPlanDefaults_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPaymentPlanDefaults($iPaymentFacade_GetPaymentPlanDefaults_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUppConfiguration
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetUppConfigurationRequest $iPaymentFacade_GetUppConfiguration_RequestMsg
     * @return \patest\StructType\GetUppConfigurationResponse|bool
     */
    public function GetUppConfiguration(\patest\StructType\GetUppConfigurationRequest $iPaymentFacade_GetUppConfiguration_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUppConfiguration($iPaymentFacade_GetUppConfiguration_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetAvailablePrintOptionsForBasketSale
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetAvailablePrintOptionsForBasketSale_Request $iPrintingFacade_GetAvailablePrintOptionsForBasketSale_RequestMsg
     * @return \patest\StructType\GetAvailablePrintOptionsForBasketSale_Response|bool
     */
    public function GetAvailablePrintOptionsForBasketSale(\patest\StructType\GetAvailablePrintOptionsForBasketSale_Request $iPrintingFacade_GetAvailablePrintOptionsForBasketSale_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailablePrintOptionsForBasketSale($iPrintingFacade_GetAvailablePrintOptionsForBasketSale_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetAvailablePrintOptionsForBasketSalesBatch
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetAvailablePrintOptionsForBasketSalesBatch_Request $iPrintingFacade_GetAvailablePrintOptionsForBasketSalesBatch_RequestMsg
     * @return \patest\StructType\GetAvailablePrintOptionsForBasketSalesBatch_Response|bool
     */
    public function GetAvailablePrintOptionsForBasketSalesBatch(\patest\StructType\GetAvailablePrintOptionsForBasketSalesBatch_Request $iPrintingFacade_GetAvailablePrintOptionsForBasketSalesBatch_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailablePrintOptionsForBasketSalesBatch($iPrintingFacade_GetAvailablePrintOptionsForBasketSalesBatch_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetAvailablePrintOptionsForFollowUpBasketPrint
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetAvailablePrintOptionsForFollowUpBasketPrint_Request $iPrintingFacade_GetAvailablePrintOptionsForFollowUpBasketPrint_RequestMsg
     * @return \patest\StructType\GetAvailablePrintOptionsForFollowUpBasketPrint_Response|bool
     */
    public function GetAvailablePrintOptionsForFollowUpBasketPrint(\patest\StructType\GetAvailablePrintOptionsForFollowUpBasketPrint_Request $iPrintingFacade_GetAvailablePrintOptionsForFollowUpBasketPrint_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailablePrintOptionsForFollowUpBasketPrint($iPrintingFacade_GetAvailablePrintOptionsForFollowUpBasketPrint_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDocumentDesignerData
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetDocumentDesignerData_Request $iPrintingFacade_GetDocumentDesignerData_RequestMsg
     * @return \patest\StructType\GetDocumentDesignerData_Response|bool
     */
    public function GetDocumentDesignerData(\patest\StructType\GetDocumentDesignerData_Request $iPrintingFacade_GetDocumentDesignerData_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDocumentDesignerData($iPrintingFacade_GetDocumentDesignerData_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMergedXmlDocumentsAsXml
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetMergedXmlDocumentsAsXmlRequest $iPrintingFacade_GetMergedXmlDocumentsAsXml_RequestMsg
     * @return \patest\StructType\GetMergedXmlDocumentsAsXmlResponse|bool
     */
    public function GetMergedXmlDocumentsAsXml(\patest\StructType\GetMergedXmlDocumentsAsXmlRequest $iPrintingFacade_GetMergedXmlDocumentsAsXml_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMergedXmlDocumentsAsXml($iPrintingFacade_GetMergedXmlDocumentsAsXml_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTransactionPrintedPdfDocuments
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetTransactionPrintedPdfDocumentsRequest $iPrintingFacade_GetTransactionPrintedPdfDocuments_RequestMsg
     * @return \patest\StructType\GetTransactionPrintedPdfDocumentsResponse|bool
     */
    public function GetTransactionPrintedPdfDocuments(\patest\StructType\GetTransactionPrintedPdfDocumentsRequest $iPrintingFacade_GetTransactionPrintedPdfDocuments_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTransactionPrintedPdfDocuments($iPrintingFacade_GetTransactionPrintedPdfDocuments_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTransactionPrintingMethods
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetTransactionPrintingMethodsRequest $iPrintingFacade_GetTransactionPrintingMethods_RequestMsg
     * @return \patest\StructType\GetTransactionPrintingMethodsResponse|bool
     */
    public function GetTransactionPrintingMethods(\patest\StructType\GetTransactionPrintingMethodsRequest $iPrintingFacade_GetTransactionPrintingMethods_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTransactionPrintingMethods($iPrintingFacade_GetTransactionPrintingMethods_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProductDescription
     * This method has been renamed because it is defined several times but with
     * different signature
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetProductDescriptionRequest $iSaleFacade_GetProductDescription_RequestMsg
     * @return \patest\StructType\GetProductDescriptionResponse|bool
     */
    public function GetProductDescription_8c365580c170dab72fd67248a8d54227(\patest\StructType\GetProductDescriptionRequest $iSaleFacade_GetProductDescription_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProductDescription($iSaleFacade_GetProductDescription_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableTills
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetAvailableTills_Request $iSaleFacade_GetAvailableTills_RequestMsg
     * @return \patest\StructType\GetAvailableTills_Response|bool
     */
    public function GetAvailableTills(\patest\StructType\GetAvailableTills_Request $iSaleFacade_GetAvailableTills_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableTills($iSaleFacade_GetAvailableTills_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOpenShifts
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetOpenShifts_Request $iSaleFacade_GetOpenShifts_RequestMsg
     * @return \patest\StructType\GetOpenShifts_Response|bool
     */
    public function GetOpenShifts(\patest\StructType\GetOpenShifts_Request $iSaleFacade_GetOpenShifts_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOpenShifts($iSaleFacade_GetOpenShifts_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPrompts
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetPrompts_Request $iSaleFacade_GetPrompts_RequestMsg
     * @return \patest\StructType\GetPrompts_Response|bool
     */
    public function GetPrompts(\patest\StructType\GetPrompts_Request $iSaleFacade_GetPrompts_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPrompts($iSaleFacade_GetPrompts_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBundleDescription
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetBundleDescriptionRequest $iSaleFacade_GetBundleDescription_RequestMsg
     * @return \patest\StructType\GetBundleDescriptionResponse|bool
     */
    public function GetBundleDescription(\patest\StructType\GetBundleDescriptionRequest $iSaleFacade_GetBundleDescription_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBundleDescription($iSaleFacade_GetBundleDescription_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBundleAvailableDates
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetBundleAvailableDatesRequest $iSaleFacade_GetBundleAvailableDates_RequestMsg
     * @return \patest\StructType\GetBundleAvailableDatesResponse|bool
     */
    public function GetBundleAvailableDates(\patest\StructType\GetBundleAvailableDatesRequest $iSaleFacade_GetBundleAvailableDates_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBundleAvailableDates($iSaleFacade_GetBundleAvailableDates_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEventsPaidForSubscriptions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetEventsPaidForSubscriptionsRequest $iSaleFacade_GetEventsPaidForSubscriptions_RequestMsg
     * @return \patest\StructType\GetEventsPaidForSubscriptionsResponse|bool
     */
    public function GetEventsPaidForSubscriptions(\patest\StructType\GetEventsPaidForSubscriptionsRequest $iSaleFacade_GetEventsPaidForSubscriptions_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEventsPaidForSubscriptions($iSaleFacade_GetEventsPaidForSubscriptions_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBundleElementAvailableDates
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetBundleElementAvailableDatesRequest $iSaleFacade_GetBundleElementAvailableDates_RequestMsg
     * @return \patest\StructType\GetBundleElementAvailableDatesResponse|bool
     */
    public function GetBundleElementAvailableDates(\patest\StructType\GetBundleElementAvailableDatesRequest $iSaleFacade_GetBundleElementAvailableDates_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBundleElementAvailableDates($iSaleFacade_GetBundleElementAvailableDates_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDefaultBundleContent
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetDefaultBundleContentRequest $iSaleFacade_GetDefaultBundleContent_RequestMsg
     * @return \patest\StructType\GetDefaultBundleContentResponse|bool
     */
    public function GetDefaultBundleContent(\patest\StructType\GetDefaultBundleContentRequest $iSaleFacade_GetDefaultBundleContent_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDefaultBundleContent($iSaleFacade_GetDefaultBundleContent_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCurrentShift
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetCurrentShiftRequest $iSaleFacade_GetCurrentShift_RequestMsg
     * @return \patest\StructType\GetCurrentShiftResponse|bool
     */
    public function GetCurrentShift(\patest\StructType\GetCurrentShiftRequest $iSaleFacade_GetCurrentShift_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCurrentShift($iSaleFacade_GetCurrentShift_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetClientLiabilities
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetClientLiabilities_Request $iSaleFacade_GetClientLiabilities_RequestMsg
     * @return \patest\StructType\GetClientLiabilities_Response|bool
     */
    public function GetClientLiabilities(\patest\StructType\GetClientLiabilities_Request $iSaleFacade_GetClientLiabilities_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetClientLiabilities($iSaleFacade_GetClientLiabilities_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetProductsMaxTransactionCommission
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetProductsMaxTransactionCommission_Request $iSaleFacade_GetProductsMaxTransactionCommission_RequestMsg
     * @return \patest\StructType\GetProductsMaxTransactionCommission_Response|bool
     */
    public function GetProductsMaxTransactionCommission(\patest\StructType\GetProductsMaxTransactionCommission_Request $iSaleFacade_GetProductsMaxTransactionCommission_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProductsMaxTransactionCommission($iSaleFacade_GetProductsMaxTransactionCommission_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetActionInstances
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetActionInstances_Request $iSaleFacade_GetActionInstances_RequestMsg
     * @return \patest\StructType\GetActionInstances_Response|bool
     */
    public function GetActionInstances(\patest\StructType\GetActionInstances_Request $iSaleFacade_GetActionInstances_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetActionInstances($iSaleFacade_GetActionInstances_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetActionInstancesAsObject
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetActionInstancesAsObject_Request $iSaleFacade_GetActionInstancesAsObject_RequestMsg
     * @return \patest\StructType\GetActionInstancesAsObject_Response|bool
     */
    public function GetActionInstancesAsObject(\patest\StructType\GetActionInstancesAsObject_Request $iSaleFacade_GetActionInstancesAsObject_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetActionInstancesAsObject($iSaleFacade_GetActionInstancesAsObject_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSalePoints
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetSalePoints_Request $iSecurityFacade_GetSalePoints_RequestMsg
     * @return \patest\StructType\GetSalePoints_Response|bool
     */
    public function GetSalePoints(\patest\StructType\GetSalePoints_Request $iSecurityFacade_GetSalePoints_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSalePoints($iSecurityFacade_GetSalePoints_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetContextSalePointConfiguration
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetContextSalePointConfigurationRequest $iSecurityFacade_GetContextSalePointConfiguration_RequestMsg
     * @return \patest\StructType\GetContextSalePointConfigurationResponse|bool
     */
    public function GetContextSalePointConfiguration(\patest\StructType\GetContextSalePointConfigurationRequest $iSecurityFacade_GetContextSalePointConfiguration_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetContextSalePointConfiguration($iSecurityFacade_GetContextSalePointConfiguration_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserApplicationPreference
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetUserApplicationPreferenceRequest_Request $iSecurityFacade_GetUserApplicationPreference_RequestMsg
     * @return \patest\StructType\GetUserApplicationPreferenceRequest_Response|bool
     */
    public function GetUserApplicationPreference(\patest\StructType\GetUserApplicationPreferenceRequest_Request $iSecurityFacade_GetUserApplicationPreference_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUserApplicationPreference($iSecurityFacade_GetUserApplicationPreference_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSubscriptionDescription
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetSubscriptionDescriptionRequest $iSubscriptionFacade_GetSubscriptionDescription_RequestMsg
     * @return \patest\StructType\GetSubscriptionDescriptionResponse|bool
     */
    public function GetSubscriptionDescription(\patest\StructType\GetSubscriptionDescriptionRequest $iSubscriptionFacade_GetSubscriptionDescription_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSubscriptionDescription($iSubscriptionFacade_GetSubscriptionDescription_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSeriesPricing
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\SeriesPricingRequest $iSubscriptionFacade_GetSeriesPricing_RequestMsg
     * @return \patest\StructType\SeriesPricingResponse|bool
     */
    public function GetSeriesPricing(\patest\StructType\SeriesPricingRequest $iSubscriptionFacade_GetSeriesPricing_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSeriesPricing($iSubscriptionFacade_GetSeriesPricing_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNewSubscriptionPeriods
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetNewSubscriptionPeriodsRequest $iSubscriptionFacade_GetNewSubscriptionPeriods_RequestMsg
     * @return \patest\StructType\GetNewSubscriptionPeriodsResponse|bool
     */
    public function GetNewSubscriptionPeriods(\patest\StructType\GetNewSubscriptionPeriodsRequest $iSubscriptionFacade_GetNewSubscriptionPeriods_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetNewSubscriptionPeriods($iSubscriptionFacade_GetNewSubscriptionPeriods_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableSeries
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetAvailableSeries_Request $iSubscriptionFacade_GetAvailableSeries_RequestMsg
     * @return \patest\StructType\GetAvailableSeries_Response|bool
     */
    public function GetAvailableSeries(\patest\StructType\GetAvailableSeries_Request $iSubscriptionFacade_GetAvailableSeries_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableSeries($iSubscriptionFacade_GetAvailableSeries_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCalculatedRelocationsPolicy
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetCalculatedRelocationsPolicy_Request $iSubscriptionFacade_GetCalculatedRelocationsPolicy_RequestMsg
     * @return \patest\StructType\GetCalculatedRelocationsPolicy_Response|bool
     */
    public function GetCalculatedRelocationsPolicy(\patest\StructType\GetCalculatedRelocationsPolicy_Request $iSubscriptionFacade_GetCalculatedRelocationsPolicy_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCalculatedRelocationsPolicy($iSubscriptionFacade_GetCalculatedRelocationsPolicy_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetClientWaveTime
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetClientWaveTimeRequest $iSubscriptionFacade_GetClientWaveTime_RequestMsg
     * @return \patest\StructType\GetClientWaveTimeResponse|bool
     */
    public function GetClientWaveTime(\patest\StructType\GetClientWaveTimeRequest $iSubscriptionFacade_GetClientWaveTime_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetClientWaveTime($iSubscriptionFacade_GetClientWaveTime_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTransactionTicketsPrintStatus
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetTransactionTicketsPrintStatus_Request $iTicketingFacade_GetTransactionTicketsPrintStatus_RequestMsg
     * @return \patest\StructType\GetTransactionTicketsPrintStatus_Response|bool
     */
    public function GetTransactionTicketsPrintStatus(\patest\StructType\GetTransactionTicketsPrintStatus_Request $iTicketingFacade_GetTransactionTicketsPrintStatus_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTransactionTicketsPrintStatus($iTicketingFacade_GetTransactionTicketsPrintStatus_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableGenres
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetAvailableGenres_Request $iTicketingFacade_GetAvailableGenres_RequestMsg
     * @return \patest\StructType\GetAvailableGenres_Response|bool
     */
    public function GetAvailableGenres(\patest\StructType\GetAvailableGenres_Request $iTicketingFacade_GetAvailableGenres_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableGenres($iTicketingFacade_GetAvailableGenres_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableShows
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetAvailableShows_Request $iTicketingFacade_GetAvailableShows_RequestMsg
     * @return \patest\StructType\GetAvailableShows_Response|bool
     */
    public function GetAvailableShows(\patest\StructType\GetAvailableShows_Request $iTicketingFacade_GetAvailableShows_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableShows($iTicketingFacade_GetAvailableShows_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetShowDescription
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetShowDescription_Request $iTicketingFacade_GetShowDescription_RequestMsg
     * @return \patest\StructType\GetShowDescription_Response|bool
     */
    public function GetShowDescription(\patest\StructType\GetShowDescription_Request $iTicketingFacade_GetShowDescription_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetShowDescription($iTicketingFacade_GetShowDescription_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableEvents
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetAvailableEvents_Request $iTicketingFacade_GetAvailableEvents_RequestMsg
     * @return \patest\StructType\GetAvailableEvents_Response|bool
     */
    public function GetAvailableEvents(\patest\StructType\GetAvailableEvents_Request $iTicketingFacade_GetAvailableEvents_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableEvents($iTicketingFacade_GetAvailableEvents_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEventDescription
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetEventDescription_Request $iTicketingFacade_GetEventDescription_RequestMsg
     * @return \patest\StructType\GetEventDescription_Response|bool
     */
    public function GetEventDescription(\patest\StructType\GetEventDescription_Request $iTicketingFacade_GetEventDescription_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEventDescription($iTicketingFacade_GetEventDescription_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEventSeatStatus
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetEventSeatStatus_Request $iTicketingFacade_GetEventSeatStatus_RequestMsg
     * @return \patest\StructType\GetEventSeatStatus_Response|bool
     */
    public function GetEventSeatStatus(\patest\StructType\GetEventSeatStatus_Request $iTicketingFacade_GetEventSeatStatus_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEventSeatStatus($iTicketingFacade_GetEventSeatStatus_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSeriesSeatStatus
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetSeriesSeatStatus_Request $iTicketingFacade_GetSeriesSeatStatus_RequestMsg
     * @return \patest\StructType\GetSeriesSeatStatus_Response|bool
     */
    public function GetSeriesSeatStatus(\patest\StructType\GetSeriesSeatStatus_Request $iTicketingFacade_GetSeriesSeatStatus_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSeriesSeatStatus($iTicketingFacade_GetSeriesSeatStatus_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEventReservations
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetEventReservations_Request $iTicketingFacade_GetEventReservations_RequestMsg
     * @return \patest\StructType\GetEventReservations_Response|bool
     */
    public function GetEventReservations(\patest\StructType\GetEventReservations_Request $iTicketingFacade_GetEventReservations_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEventReservations($iTicketingFacade_GetEventReservations_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableRestrictions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetAvailableRestrictions_Request $iTicketingFacade_GetAvailableRestrictions_RequestMsg
     * @return \patest\StructType\GetAvailableRestrictions_Response|bool
     */
    public function GetAvailableRestrictions(\patest\StructType\GetAvailableRestrictions_Request $iTicketingFacade_GetAvailableRestrictions_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableRestrictions($iTicketingFacade_GetAvailableRestrictions_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLogicalSeatId
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetLogicalSeatId_Request $iTicketingFacade_GetLogicalSeatId_RequestMsg
     * @return \patest\StructType\GetLogicalSeatId_Response|bool
     */
    public function GetLogicalSeatId(\patest\StructType\GetLogicalSeatId_Request $iTicketingFacade_GetLogicalSeatId_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLogicalSeatId($iTicketingFacade_GetLogicalSeatId_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetGenresByShowId
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetGenresByShowId_Request $iTicketingFacade_GetGenresByShowId_RequestMsg
     * @return \patest\StructType\GetGenresByShowId_Response|bool
     */
    public function GetGenresByShowId(\patest\StructType\GetGenresByShowId_Request $iTicketingFacade_GetGenresByShowId_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetGenresByShowId($iTicketingFacade_GetGenresByShowId_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSeatHistoryAndInformation
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetSeatHistoryAndInformation_Request $iTicketingFacade_GetSeatHistoryAndInformation_RequestMsg
     * @return \patest\StructType\GetSeatHistoryAndInformation_Response|bool
     */
    public function GetSeatHistoryAndInformation(\patest\StructType\GetSeatHistoryAndInformation_Request $iTicketingFacade_GetSeatHistoryAndInformation_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSeatHistoryAndInformation($iTicketingFacade_GetSeatHistoryAndInformation_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAreasOfHallVersion
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetAreasOfHallVersion_Request $iTicketingFacade_GetAreasOfHallVersion_RequestMsg
     * @return \patest\StructType\GetAreasOfHallVersion_Response|bool
     */
    public function GetAreasOfHallVersion(\patest\StructType\GetAreasOfHallVersion_Request $iTicketingFacade_GetAreasOfHallVersion_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAreasOfHallVersion($iTicketingFacade_GetAreasOfHallVersion_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSectorsOfArea
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetSectorsOfArea_Request $iTicketingFacade_GetSectorsOfArea_RequestMsg
     * @return \patest\StructType\GetSectorsOfArea_Response|bool
     */
    public function GetSectorsOfArea(\patest\StructType\GetSectorsOfArea_Request $iTicketingFacade_GetSectorsOfArea_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSectorsOfArea($iTicketingFacade_GetSectorsOfArea_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSeatToolTipInfo
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetSeatToolTipInfo_Request $iTicketingFacade_GetSeatToolTipInfo_RequestMsg
     * @return \patest\StructType\GetSeatToolTipInfo_Response|bool
     */
    public function GetSeatToolTipInfo(\patest\StructType\GetSeatToolTipInfo_Request $iTicketingFacade_GetSeatToolTipInfo_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSeatToolTipInfo($iTicketingFacade_GetSeatToolTipInfo_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSetAsideAreaMap
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetSetAsideAreaMap_Request $iTicketingFacade_GetSetAsideAreaMap_RequestMsg
     * @return \patest\StructType\GetSetAsideAreaMap_Response|bool
     */
    public function GetSetAsideAreaMap(\patest\StructType\GetSetAsideAreaMap_Request $iTicketingFacade_GetSetAsideAreaMap_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSetAsideAreaMap($iTicketingFacade_GetSetAsideAreaMap_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLimitationCounters
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetLimitationCounters_Request $iTicketingFacade_GetLimitationCounters_RequestMsg
     * @return \patest\StructType\GetLimitationCounters_Response|bool
     */
    public function GetLimitationCounters(\patest\StructType\GetLimitationCounters_Request $iTicketingFacade_GetLimitationCounters_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLimitationCounters($iTicketingFacade_GetLimitationCounters_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEventPricing
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetEventPricing_Request $iTicketingFacade_GetEventPricing_RequestMsg
     * @return \patest\StructType\GetEventPricing_Response|bool
     */
    public function GetEventPricing(\patest\StructType\GetEventPricing_Request $iTicketingFacade_GetEventPricing_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEventPricing($iTicketingFacade_GetEventPricing_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEventData
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetEventData_Request $iTicketingFacade_GetEventData_RequestMsg
     * @return \patest\StructType\GetEventData_Response|bool
     */
    public function GetEventData(\patest\StructType\GetEventData_Request $iTicketingFacade_GetEventData_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEventData($iTicketingFacade_GetEventData_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailablePriceLevelsForBundle
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetAvailablePriceLevelsForBundle_Request $iTicketingFacade_GetAvailablePriceLevelsForBundle_RequestMsg
     * @return \patest\StructType\GetAvailablePriceLevelsForBundle_Response|bool
     */
    public function GetAvailablePriceLevelsForBundle(\patest\StructType\GetAvailablePriceLevelsForBundle_Request $iTicketingFacade_GetAvailablePriceLevelsForBundle_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailablePriceLevelsForBundle($iTicketingFacade_GetAvailablePriceLevelsForBundle_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTourShowsList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetTourShowsList_Request $iTicketingFacade_GetTourShowsList_RequestMsg
     * @return \patest\StructType\GetTourShowsList_Response|bool
     */
    public function GetTourShowsList(\patest\StructType\GetTourShowsList_Request $iTicketingFacade_GetTourShowsList_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTourShowsList($iTicketingFacade_GetTourShowsList_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEventPriceLevelsAndAvailability
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetEventPriceLevelsAndAvailability_Request $iTicketingFacade_GetEventPriceLevelsAndAvailability_RequestMsg
     * @return \patest\StructType\GetEventPriceLevelsAndAvailability_Response|bool
     */
    public function GetEventPriceLevelsAndAvailability(\patest\StructType\GetEventPriceLevelsAndAvailability_Request $iTicketingFacade_GetEventPriceLevelsAndAvailability_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEventPriceLevelsAndAvailability($iTicketingFacade_GetEventPriceLevelsAndAvailability_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTicketsExtendedInfo
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetTicketsExtendedInfo_Request $iTicketingFacade_GetTicketsExtendedInfo_RequestMsg
     * @return \patest\StructType\GetTicketsExtendedInfo_Response|bool
     */
    public function GetTicketsExtendedInfo(\patest\StructType\GetTicketsExtendedInfo_Request $iTicketingFacade_GetTicketsExtendedInfo_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTicketsExtendedInfo($iTicketingFacade_GetTicketsExtendedInfo_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEventInfoFromSgo
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetEventInfoFromSgoRequest_Request $iTicketingFacade_GetEventInfoFromSgo_RequestMsg
     * @return \patest\StructType\GetEventInfoFromSgoResponse|bool
     */
    public function GetEventInfoFromSgo(\patest\StructType\GetEventInfoFromSgoRequest_Request $iTicketingFacade_GetEventInfoFromSgo_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEventInfoFromSgo($iTicketingFacade_GetEventInfoFromSgo_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEventSaleStatusCachingResidue
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetEventSaleStatusCachingResidue_Request $iTicketingFacade_GetEventSaleStatusCachingResidue_RequestMsg
     * @return \patest\StructType\GetEventSaleStatusCachingResidue_Response|bool
     */
    public function GetEventSaleStatusCachingResidue(\patest\StructType\GetEventSaleStatusCachingResidue_Request $iTicketingFacade_GetEventSaleStatusCachingResidue_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEventSaleStatusCachingResidue($iTicketingFacade_GetEventSaleStatusCachingResidue_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPresaleExtraData
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetPresaleExtraData_Request $iTicketingFacade_GetPresaleExtraData_RequestMsg
     * @return \patest\StructType\GetPresaleExtraData_Response|bool
     */
    public function GetPresaleExtraData(\patest\StructType\GetPresaleExtraData_Request $iTicketingFacade_GetPresaleExtraData_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPresaleExtraData($iTicketingFacade_GetPresaleExtraData_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPresales
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetPresales_Request $iTicketingFacade_GetPresales_RequestMsg
     * @return \patest\StructType\GetPresales_Response|bool
     */
    public function GetPresales(\patest\StructType\GetPresales_Request $iTicketingFacade_GetPresales_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPresales($iTicketingFacade_GetPresales_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOnsale
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetOnsale_Request $iTicketingFacade_GetOnsale_RequestMsg
     * @return \patest\StructType\GetOnsale_Response|bool
     */
    public function GetOnsale(\patest\StructType\GetOnsale_Request $iTicketingFacade_GetOnsale_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOnsale($iTicketingFacade_GetOnsale_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPresaleHistory
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetPresaleHistory_Request $iTicketingFacade_GetPresaleHistory_RequestMsg
     * @return \patest\StructType\GetPresaleHistory_Response|bool
     */
    public function GetPresaleHistory(\patest\StructType\GetPresaleHistory_Request $iTicketingFacade_GetPresaleHistory_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPresaleHistory($iTicketingFacade_GetPresaleHistory_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDeactivateCodeStatus
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\DeactivateCodeStatus_Request $iTicketingFacade_GetDeactivateCodeStatus_RequestMsg
     * @return \patest\StructType\DeactivateCodeStatus_Response|bool
     */
    public function GetDeactivateCodeStatus(\patest\StructType\DeactivateCodeStatus_Request $iTicketingFacade_GetDeactivateCodeStatus_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDeactivateCodeStatus($iTicketingFacade_GetDeactivateCodeStatus_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPresaleCodeStatus
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\PresaleCodeStatus_Request $iTicketingFacade_GetPresaleCodeStatus_RequestMsg
     * @return \patest\StructType\PresaleCodeStatus_Response|bool
     */
    public function GetPresaleCodeStatus(\patest\StructType\PresaleCodeStatus_Request $iTicketingFacade_GetPresaleCodeStatus_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPresaleCodeStatus($iTicketingFacade_GetPresaleCodeStatus_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomSeatPrices
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetCustomSeatPricesRequest $iTicketingFacade_GetCustomSeatPrices_RequestMsg
     * @return \patest\StructType\GetCustomSeatPricesResponse|bool
     */
    public function GetCustomSeatPrices(\patest\StructType\GetCustomSeatPricesRequest $iTicketingFacade_GetCustomSeatPrices_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomSeatPrices($iTicketingFacade_GetCustomSeatPrices_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomSeatPriceForSingleSeat
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetCustomSeatPriceForSingleSeatRequest $iTicketingFacade_GetCustomSeatPriceForSingleSeat_RequestMsg
     * @return \patest\StructType\GetCustomSeatPriceForSingleSeatResponse|bool
     */
    public function GetCustomSeatPriceForSingleSeat(\patest\StructType\GetCustomSeatPriceForSingleSeatRequest $iTicketingFacade_GetCustomSeatPriceForSingleSeat_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomSeatPriceForSingleSeat($iTicketingFacade_GetCustomSeatPriceForSingleSeat_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetTicketSchemeEnrollmentsWithoutPaymentMethod
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetTicketSchemeEnrollmentsWithoutPaymentMethod_Request $iTicketingFacade_GetTicketSchemeEnrollmentsWithoutPaymentMethod_RequestMsg
     * @return \patest\StructType\GetTicketSchemeEnrollmentsWithoutPaymentMethod_Response|bool
     */
    public function GetTicketSchemeEnrollmentsWithoutPaymentMethod(\patest\StructType\GetTicketSchemeEnrollmentsWithoutPaymentMethod_Request $iTicketingFacade_GetTicketSchemeEnrollmentsWithoutPaymentMethod_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTicketSchemeEnrollmentsWithoutPaymentMethod($iTicketingFacade_GetTicketSchemeEnrollmentsWithoutPaymentMethod_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetTicketSchemeClientEnrollmentsSummary
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetTicketSchemeClientEnrollmentsSummary_Request $iTicketingFacade_GetTicketSchemeClientEnrollmentsSummary_RequestMsg
     * @return \patest\StructType\GetTicketSchemeClientEnrollmentsSummary_Response|bool
     */
    public function GetTicketSchemeClientEnrollmentsSummary(\patest\StructType\GetTicketSchemeClientEnrollmentsSummary_Request $iTicketingFacade_GetTicketSchemeClientEnrollmentsSummary_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTicketSchemeClientEnrollmentsSummary($iTicketingFacade_GetTicketSchemeClientEnrollmentsSummary_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPublicEventVisibilityInfo
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetPublicEventVisibilityInfoRequest $iTicketingFacade_GetPublicEventVisibilityInfo_RequestMsg
     * @return \patest\StructType\GetPublicEventVisibilityInfoResponse|bool
     */
    public function GetPublicEventVisibilityInfo(\patest\StructType\GetPublicEventVisibilityInfoRequest $iTicketingFacade_GetPublicEventVisibilityInfo_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPublicEventVisibilityInfo($iTicketingFacade_GetPublicEventVisibilityInfo_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEventsCrmHasTicketsFor
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetEventsCrmHasTicketsFor_Request $iTicketingFacade_GetEventsCrmHasTicketsFor_RequestMsg
     * @return \patest\StructType\GetEventsCrmHasTicketsFor_Response|bool
     */
    public function GetEventsCrmHasTicketsFor(\patest\StructType\GetEventsCrmHasTicketsFor_Request $iTicketingFacade_GetEventsCrmHasTicketsFor_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEventsCrmHasTicketsFor($iTicketingFacade_GetEventsCrmHasTicketsFor_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEventTickets
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetEventTickets_Request $iTicketingFacade_GetEventTickets_RequestMsg
     * @return \patest\StructType\GetEventTickets_Response|bool
     */
    public function GetEventTickets(\patest\StructType\GetEventTickets_Request $iTicketingFacade_GetEventTickets_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEventTickets($iTicketingFacade_GetEventTickets_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEventTicketViewConfiguration
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetEventTicketViewConfiguration_Request $iTicketingFacade_GetEventTicketViewConfiguration_RequestMsg
     * @return \patest\StructType\GetEventTicketViewConfiguration_Response|bool
     */
    public function GetEventTicketViewConfiguration(\patest\StructType\GetEventTicketViewConfiguration_Request $iTicketingFacade_GetEventTicketViewConfiguration_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEventTicketViewConfiguration($iTicketingFacade_GetEventTicketViewConfiguration_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTicketViewComponentById
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\TicketViewComponentGet_Request $iTicketingFacade_GetTicketViewComponentById_RequestMsg
     * @return \patest\StructType\GetTicketViewComponentById_Response|bool
     */
    public function GetTicketViewComponentById(\patest\StructType\TicketViewComponentGet_Request $iTicketingFacade_GetTicketViewComponentById_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTicketViewComponentById($iTicketingFacade_GetTicketViewComponentById_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetTicketViewAssociationsByApplicationObjectIdentifier
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetTicketViewAssociationsByApplicationObjectIdentifierRequest $iTicketingFacade_GetTicketViewAssociationsByApplicationObjectIdentifier_RequestMsg
     * @return \patest\StructType\GetTicketViewAssociationsByApplicationObjectIdentifierResponse|bool
     */
    public function GetTicketViewAssociationsByApplicationObjectIdentifier(\patest\StructType\GetTicketViewAssociationsByApplicationObjectIdentifierRequest $iTicketingFacade_GetTicketViewAssociationsByApplicationObjectIdentifier_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTicketViewAssociationsByApplicationObjectIdentifier($iTicketingFacade_GetTicketViewAssociationsByApplicationObjectIdentifier_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTicketViewAssociation
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetTicketViewAssociation_Request $iTicketingFacade_GetTicketViewAssociation_RequestMsg
     * @return \patest\StructType\GetTicketViewAssociation_Response|bool
     */
    public function GetTicketViewAssociation(\patest\StructType\GetTicketViewAssociation_Request $iTicketingFacade_GetTicketViewAssociation_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTicketViewAssociation($iTicketingFacade_GetTicketViewAssociation_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetTicketViewConfigurationImagesByImageType
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetTicketViewConfigurationImagesByImageTypeRequest $iTicketingFacade_GetTicketViewConfigurationImagesByImageType_RequestMsg
     * @return \patest\StructType\GetTicketViewConfigurationImagesByImageTypeResponse|bool
     */
    public function GetTicketViewConfigurationImagesByImageType(\patest\StructType\GetTicketViewConfigurationImagesByImageTypeRequest $iTicketingFacade_GetTicketViewConfigurationImagesByImageType_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTicketViewConfigurationImagesByImageType($iTicketingFacade_GetTicketViewConfigurationImagesByImageType_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEligibleEventsForExchangeOut
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetEligibleEventsForExchangeOut_Request $iTicketingFacade_GetEligibleEventsForExchangeOut_RequestMsg
     * @return \patest\StructType\GetEligibleEventsForExchangeOut_Response|bool
     */
    public function GetEligibleEventsForExchangeOut(\patest\StructType\GetEligibleEventsForExchangeOut_Request $iTicketingFacade_GetEligibleEventsForExchangeOut_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEligibleEventsForExchangeOut($iTicketingFacade_GetEligibleEventsForExchangeOut_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBallotPricing
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetBallotPricingRequest $iTicketingFacade_GetBallotPricing_RequestMsg
     * @return \patest\StructType\GetBallotPricingResponse|bool
     */
    public function GetBallotPricing(\patest\StructType\GetBallotPricingRequest $iTicketingFacade_GetBallotPricing_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBallotPricing($iTicketingFacade_GetBallotPricing_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBallotApplications
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetBallotApplicationsRequest $iTicketingFacade_GetBallotApplications_RequestMsg
     * @return \patest\StructType\GetBallotApplicationsResponse|bool
     */
    public function GetBallotApplications(\patest\StructType\GetBallotApplicationsRequest $iTicketingFacade_GetBallotApplications_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBallotApplications($iTicketingFacade_GetBallotApplications_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEventUpgradeConfig
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetEventUpgradeConfig_Request $iTicketingFacade_GetEventUpgradeConfig_RequestMsg
     * @return \patest\StructType\GetEventUpgradeConfig_Response|bool
     */
    public function GetEventUpgradeConfig(\patest\StructType\GetEventUpgradeConfig_Request $iTicketingFacade_GetEventUpgradeConfig_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEventUpgradeConfig($iTicketingFacade_GetEventUpgradeConfig_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPriceTypesForTickets
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetPriceTypesForTicketsRequest $iTicketingFacade_GetPriceTypesForTickets_RequestMsg
     * @return \patest\StructType\GetPriceTypesForTicketsResponse|bool
     */
    public function GetPriceTypesForTickets(\patest\StructType\GetPriceTypesForTicketsRequest $iTicketingFacade_GetPriceTypesForTickets_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPriceTypesForTickets($iTicketingFacade_GetPriceTypesForTickets_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMyTickets
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetMyTickets_Request $iTicketingFacade_GetMyTickets_RequestMsg
     * @return \patest\StructType\GetMyTickets_Response|bool
     */
    public function GetMyTickets(\patest\StructType\GetMyTickets_Request $iTicketingFacade_GetMyTickets_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMyTickets($iTicketingFacade_GetMyTickets_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetTicketViewConfigurationsForEvents
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GetTicketViewConfigurationsForEvents_Request $iTicketingFacade_GetTicketViewConfigurationsForEvents_RequestMsg
     * @return \patest\StructType\GetTicketViewConfigurationsForEvents_Response|bool
     */
    public function GetTicketViewConfigurationsForEvents(\patest\StructType\GetTicketViewConfigurationsForEvents_Request $iTicketingFacade_GetTicketViewConfigurationsForEvents_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTicketViewConfigurationsForEvents($iTicketingFacade_GetTicketViewConfigurationsForEvents_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\DeactivateCodeStatus_Response|\patest\StructType\GetAccessControlSystemsResponse|\patest\StructType\GetAccessInfoForTickets_Response|\patest\StructType\GetActionInstancesAsObject_Response|\patest\StructType\GetActionInstances_Response|\patest\StructType\GetAllBundleElementsAvailableProductsResponse|\patest\StructType\GetAreasOfHallVersion_Response|\patest\StructType\GetAvailableDataProtectionQuestionsResponse|\patest\StructType\GetAvailableDataResponse|\patest\StructType\GetAvailableDeliveries_Response|\patest\StructType\GetAvailableDepositsResponse|\patest\StructType\GetAvailableDirectDebitMandates_Response|\patest\StructType\GetAvailableEvents_Response|\patest\StructType\GetAvailableGenres_Response|\patest\StructType\GetAvailableMerchandiseItemTypes_Response|\patest\StructType\GetAvailablePaymentMethods_Response|\patest\StructType\GetAvailablePriceLevelsForBundle_Response|\patest\StructType\GetAvailablePrintOptionsForBasketSalesBatch_Response|\patest\StructType\GetAvailablePrintOptionsForBasketSale_Response|\patest\StructType\GetAvailablePrintOptionsForFollowUpBasketPrint_Response|\patest\StructType\GetAvailableProducts_Response|\patest\StructType\GetAvailableRestrictions_Response|\patest\StructType\GetAvailableSalesRepresentativesResponse|\patest\StructType\GetAvailableSeries_Response|\patest\StructType\GetAvailableServiceRepresentativesResponse|\patest\StructType\GetAvailableShows_Response|\patest\StructType\GetAvailableSolicitorsResponse|\patest\StructType\GetAvailableTills_Response|\patest\StructType\GetBallotApplicationsResponse|\patest\StructType\GetBallotPricingResponse|\patest\StructType\GetBarcodeChangesResponse|\patest\StructType\GetBarcodeEntities_Response|\patest\StructType\GetBundleAvailableDatesResponse|\patest\StructType\GetBundleDescriptionResponse|\patest\StructType\GetBundleElementAvailableDatesResponse|\patest\StructType\GetBundleElementAvailableProductsResponse|\patest\StructType\GetCalculatedRelocationsPolicy_Response|\patest\StructType\GetCaptionsByKeysResponse|\patest\StructType\GetCardLoadingDescriptionResponse|\patest\StructType\GetCategories_Request|\patest\StructType\GetClassContentResponse|\patest\StructType\GetClassNodesResponse_Response|\patest\StructType\GetClientBalance_Response|\patest\StructType\GetClientEventsResponse|\patest\StructType\GetClientEventTicketsResponse|\patest\StructType\GetClientLiabilities_Response|\patest\StructType\GetClientWaveTimeResponse|\patest\StructType\GetClientWelcomeInfoResponse|\patest\StructType\GetContextSalePointConfigurationResponse|\patest\StructType\GetCrmIdForCardSwipe_Response|\patest\StructType\GetCurrentClient_Response|\patest\StructType\GetCurrentShiftResponse|\patest\StructType\GetCustomerCreditCategories_Response|\patest\StructType\GetCustomSeatPriceForSingleSeatResponse|\patest\StructType\GetCustomSeatPricesResponse|\patest\StructType\GetDefaultBundleContentResponse|\patest\StructType\GetDeletedEntitiesResponse|\patest\StructType\GetDirectDebitRecordsBatch_Response|\patest\StructType\GetDirectDebitRecordsToSend_Response|\patest\StructType\GetDocumentDesignerData_Response|\patest\StructType\GetEligibleEventsForExchangeOut_Response|\patest\StructType\GetEntityManagementQueryTokenContextResponse|\patest\StructType\GetEventData_Response|\patest\StructType\GetEventDescription_Response|\patest\StructType\GetEventInfoFromSgoResponse|\patest\StructType\GetEventPriceLevelsAndAvailability_Response|\patest\StructType\GetEventPricing_Response|\patest\StructType\GetEventReservations_Response|\patest\StructType\GetEventSaleStatusCachingResidue_Response|\patest\StructType\GetEventsCrmHasTicketsFor_Response|\patest\StructType\GetEventSeatStatus_Response|\patest\StructType\GetEventsPaidForSubscriptionsResponse|\patest\StructType\GetEventTickets_Response|\patest\StructType\GetEventTicketViewConfiguration_Response|\patest\StructType\GetEventUpgradeConfig_Response|\patest\StructType\GetExtendedTicketInfoResponse|\patest\StructType\GetExtraPromptElementAvailableProductsResponse|\patest\StructType\GetGenresByShowId_Response|\patest\StructType\GetGiftVoucherDescription_Response|\patest\StructType\GetGuidanceDescriptionResponse|\patest\StructType\GetLimitationCounters_Response|\patest\StructType\GetLinkedClientsResponse|\patest\StructType\GetListOfLogFilesResponse|\patest\StructType\GetLogicalSeatId_Response|\patest\StructType\GetMatchingGiftsReservations_Response|\patest\StructType\GetMembershipDefinitionDescription_Response|\patest\StructType\GetMerchandiseDescription_Response|\patest\StructType\GetMerchandiseItemsPrices_Response|\patest\StructType\GetMergedXmlDocumentsAsXmlResponse|\patest\StructType\GetMyTickets_Response|\patest\StructType\GetNewSubscriptionPeriodsResponse|\patest\StructType\GetOnsale_Response|\patest\StructType\GetOpenShifts_Response|\patest\StructType\GetPasswordValidityParameters_Response|\patest\StructType\GetPaymentPlanDefaults_Response|\patest\StructType\GetPresaleExtraData_Response|\patest\StructType\GetPresaleHistory_Response|\patest\StructType\GetPresales_Response|\patest\StructType\GetPriceTypesForTicketsResponse|\patest\StructType\GetProductDescriptionResponse|\patest\StructType\GetProductDescription_Response|\patest\StructType\GetProductsAttributesTypes_Response|\patest\StructType\GetProductsMaxTransactionCommission_Response|\patest\StructType\GetPrompts_Response|\patest\StructType\GetPublicEventVisibilityInfoResponse|\patest\StructType\GetRelatedClientsResponse|\patest\StructType\GetRuleSystemDescriptionResponse|\patest\StructType\GetSalePoints_Response|\patest\StructType\GetSchemeDescription_Response|\patest\StructType\GetSeatHistoryAndInformation_Response|\patest\StructType\GetSeatToolTipInfo_Response|\patest\StructType\GetSectorsOfArea_Response|\patest\StructType\GetSeriesSeatStatus_Response|\patest\StructType\GetSetAsideAreaMap_Response|\patest\StructType\GetShowDescription_Response|\patest\StructType\GetSoftCreditDefaultsForClient_Response|\patest\StructType\GetSubscriptionDescriptionResponse|\patest\StructType\GetTaggedProductsResponse_Request|\patest\StructType\GetTicketSchemeClientEnrollmentsSummary_Response|\patest\StructType\GetTicketSchemeEnrollmentsWithoutPaymentMethod_Response|\patest\StructType\GetTicketsExtendedInfo_Response|\patest\StructType\GetTicketsScanningStatus_Response|\patest\StructType\GetTicketsToManageResponse|\patest\StructType\GetTicketViewAssociationsByApplicationObjectIdentifierResponse|\patest\StructType\GetTicketViewAssociation_Response|\patest\StructType\GetTicketViewComponentById_Response|\patest\StructType\GetTicketViewConfigurationImagesByImageTypeResponse|\patest\StructType\GetTicketViewConfigurationsForEvents_Response|\patest\StructType\GetTourShowsList_Response|\patest\StructType\GetTransactionAccessControlDataResponse|\patest\StructType\GetTransactionPrintedPdfDocumentsResponse|\patest\StructType\GetTransactionPrintingMethodsResponse|\patest\StructType\GetTransactionTicketsPrintStatus_Response|\patest\StructType\GetUpdatedEntitiesResponse|\patest\StructType\GetUppConfigurationResponse|\patest\StructType\GetUrlForLogFileResponse|\patest\StructType\GetUserApplicationPreferenceRequest_Response|\patest\StructType\PresaleCodeStatus_Response|\patest\StructType\SeriesPricingResponse|\patest\StructType\SGAccountContextResponse|\patest\StructType\SgoLinkageInfoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
