<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Discard ServiceType
 * @subpackage Services
 */
class Discard extends AbstractSoapClientBase
{
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\patest\ArrayType\ArrayOfKeyValueOfstringstring $context, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Context', $context, $mustUnderstand, $actor);
    }
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named DiscardTransaction
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\DiscardTransaction_Request $iSaleFacade_DiscardTransaction_RequestMsg
     * @return \patest\StructType\DiscardTransaction_Response|bool
     */
    public function DiscardTransaction(\patest\StructType\DiscardTransaction_Request $iSaleFacade_DiscardTransaction_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->DiscardTransaction($iSaleFacade_DiscardTransaction_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DiscardBasketItems
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\DiscardBasketItems_Request $iSaleFacade_DiscardBasketItems_RequestMsg
     * @return \patest\StructType\DiscardBasketItems_Response|bool
     */
    public function DiscardBasketItems(\patest\StructType\DiscardBasketItems_Request $iSaleFacade_DiscardBasketItems_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->DiscardBasketItems($iSaleFacade_DiscardBasketItems_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DiscardHospitalityTickets
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\DiscardHospitalityTickets_Request $iTicketingFacade_DiscardHospitalityTickets_RequestMsg
     * @return \patest\StructType\DiscardHospitalityTickets_Response|bool
     */
    public function DiscardHospitalityTickets(\patest\StructType\DiscardHospitalityTickets_Request $iTicketingFacade_DiscardHospitalityTickets_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->DiscardHospitalityTickets($iTicketingFacade_DiscardHospitalityTickets_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DiscardHospitalitySubscriptions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\DiscardHospitalitySubscriptions_Request $iTicketingFacade_DiscardHospitalitySubscriptions_RequestMsg
     * @return \patest\StructType\DiscardHospitalitySubscriptions_Response|bool
     */
    public function DiscardHospitalitySubscriptions(\patest\StructType\DiscardHospitalitySubscriptions_Request $iTicketingFacade_DiscardHospitalitySubscriptions_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->DiscardHospitalitySubscriptions($iTicketingFacade_DiscardHospitalitySubscriptions_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\DiscardBasketItems_Response|\patest\StructType\DiscardHospitalitySubscriptions_Response|\patest\StructType\DiscardHospitalityTickets_Response|\patest\StructType\DiscardTransaction_Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
