<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for SaleStatusExtended EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SaleStatusExtended
 * @subpackage Enumerations
 */
class SaleStatusExtended extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Sold'
     * @return string 'Sold'
     */
    const VALUE_SOLD = 'Sold';
    /**
     * Constant for value 'Reserved'
     * @return string 'Reserved'
     */
    const VALUE_RESERVED = 'Reserved';
    /**
     * Constant for value 'Returned'
     * @return string 'Returned'
     */
    const VALUE_RETURNED = 'Returned';
    /**
     * Constant for value 'RemovedFromSubs'
     * @return string 'RemovedFromSubs'
     */
    const VALUE_REMOVED_FROM_SUBS = 'RemovedFromSubs';
    /**
     * Return allowed values
     * @uses self::VALUE_SOLD
     * @uses self::VALUE_RESERVED
     * @uses self::VALUE_RETURNED
     * @uses self::VALUE_REMOVED_FROM_SUBS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SOLD,
            self::VALUE_RESERVED,
            self::VALUE_RETURNED,
            self::VALUE_REMOVED_FROM_SUBS,
        );
    }
}
