<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for PaymentSessionAction EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PaymentSessionAction
 * @subpackage Enumerations
 */
class PaymentSessionAction extends AbstractStructEnumBase
{
    /**
     * Constant for value 'OperationInitiated'
     * @return string 'OperationInitiated'
     */
    const VALUE_OPERATION_INITIATED = 'OperationInitiated';
    /**
     * Constant for value 'OperationDone'
     * @return string 'OperationDone'
     */
    const VALUE_OPERATION_DONE = 'OperationDone';
    /**
     * Constant for value 'OperationFailed'
     * @return string 'OperationFailed'
     */
    const VALUE_OPERATION_FAILED = 'OperationFailed';
    /**
     * Constant for value 'RollbackInitiated'
     * @return string 'RollbackInitiated'
     */
    const VALUE_ROLLBACK_INITIATED = 'RollbackInitiated';
    /**
     * Constant for value 'RollbackDone'
     * @return string 'RollbackDone'
     */
    const VALUE_ROLLBACK_DONE = 'RollbackDone';
    /**
     * Constant for value 'RollbackFailed'
     * @return string 'RollbackFailed'
     */
    const VALUE_ROLLBACK_FAILED = 'RollbackFailed';
    /**
     * Constant for value 'LogInfo'
     * @return string 'LogInfo'
     */
    const VALUE_LOG_INFO = 'LogInfo';
    /**
     * Constant for value 'LogWarning'
     * @return string 'LogWarning'
     */
    const VALUE_LOG_WARNING = 'LogWarning';
    /**
     * Constant for value 'LogError'
     * @return string 'LogError'
     */
    const VALUE_LOG_ERROR = 'LogError';
    /**
     * Constant for value 'LogHistory'
     * @return string 'LogHistory'
     */
    const VALUE_LOG_HISTORY = 'LogHistory';
    /**
     * Return allowed values
     * @uses self::VALUE_OPERATION_INITIATED
     * @uses self::VALUE_OPERATION_DONE
     * @uses self::VALUE_OPERATION_FAILED
     * @uses self::VALUE_ROLLBACK_INITIATED
     * @uses self::VALUE_ROLLBACK_DONE
     * @uses self::VALUE_ROLLBACK_FAILED
     * @uses self::VALUE_LOG_INFO
     * @uses self::VALUE_LOG_WARNING
     * @uses self::VALUE_LOG_ERROR
     * @uses self::VALUE_LOG_HISTORY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OPERATION_INITIATED,
            self::VALUE_OPERATION_DONE,
            self::VALUE_OPERATION_FAILED,
            self::VALUE_ROLLBACK_INITIATED,
            self::VALUE_ROLLBACK_DONE,
            self::VALUE_ROLLBACK_FAILED,
            self::VALUE_LOG_INFO,
            self::VALUE_LOG_WARNING,
            self::VALUE_LOG_ERROR,
            self::VALUE_LOG_HISTORY,
        );
    }
}
