<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for PaymentMethodUsage EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PaymentMethodUsage
 * @subpackage Enumerations
 */
class PaymentMethodUsage extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'Pay'
     * @return string 'Pay'
     */
    const VALUE_PAY = 'Pay';
    /**
     * Constant for value 'Reimburse'
     * @return string 'Reimburse'
     */
    const VALUE_REIMBURSE = 'Reimburse';
    /**
     * Constant for value 'Both'
     * @return string 'Both'
     */
    const VALUE_BOTH = 'Both';
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_PAY
     * @uses self::VALUE_REIMBURSE
     * @uses self::VALUE_BOTH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_PAY,
            self::VALUE_REIMBURSE,
            self::VALUE_BOTH,
        );
    }
}
